/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.jcr;

import java.io.Serializable;
import java.lang.reflect.Method;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.commons.proxy.Invoker;
import org.hippoecm.hst.core.jcr.DelegatingRepository;
import org.hippoecm.hst.core.jcr.LazySession;
import org.hippoecm.hst.proxy.ProxyFactory;
import org.hippoecm.repository.api.HippoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazySessionDelegatingRepository
extends DelegatingRepository {
    private static Logger log = LoggerFactory.getLogger(LazySessionDelegatingRepository.class);
    private boolean logoutOnSessionUnbound;
    private SessionsRefreshCounter sessionsRefreshCounter = new SessionsRefreshCounter();

    public LazySessionDelegatingRepository(Repository delegatee) {
        super(delegatee);
    }

    public void setLogoutOnSessionUnbound(boolean logoutOnSessionUnbound) {
        this.logoutOnSessionUnbound = logoutOnSessionUnbound;
    }

    @Override
    public Session login() throws LoginException, RepositoryException {
        return this.createLazySession(null, null);
    }

    @Override
    public Session login(Credentials credentials) throws LoginException, RepositoryException {
        return this.createLazySession(credentials, null);
    }

    @Override
    public Session login(String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.createLazySession(null, workspaceName);
    }

    @Override
    public Session login(Credentials credentials, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.createLazySession(credentials, workspaceName);
    }

    public void setSessionsRefreshPendingAfter(long sessionsRefreshPendingAfter) {
        this.sessionsRefreshCounter.setSessionsRefreshPendingAfter(sessionsRefreshPendingAfter);
    }

    public long getSessionsRefreshPendingAfter() {
        return this.sessionsRefreshCounter.getSessionsRefreshPendingAfter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Session createLazySession(Credentials credentials, String workspaceName) {
        Session lazySession = null;
        ProxyFactory factory = new ProxyFactory();
        LazySessionInvoker invoker = new LazySessionInvoker(this.getDelegatee(), credentials, workspaceName, this.logoutOnSessionUnbound);
        invoker.setSessionsRefreshCounter(this.sessionsRefreshCounter);
        ClassLoader sessionClassloader = this.getDelegatee().getClass().getClassLoader();
        ClassLoader currentClassloader = Thread.currentThread().getContextClassLoader();
        try {
            if (sessionClassloader != currentClassloader) {
                Thread.currentThread().setContextClassLoader(sessionClassloader);
            }
            lazySession = (Session)factory.createInvokerProxy(sessionClassloader, (Invoker)invoker, new Class[]{LazySession.class, Serializable.class, HttpSessionBindingListener.class});
        }
        finally {
            if (sessionClassloader != currentClassloader) {
                Thread.currentThread().setContextClassLoader(currentClassloader);
            }
        }
        return lazySession;
    }

    protected static class LazySessionInvoker
    implements Invoker,
    Serializable {
        private static final long serialVersionUID = 1L;
        private transient Repository repository;
        private transient Session session;
        private Credentials credentials;
        private String workspaceName;
        private boolean logoutOnSessionUnbound;
        private long lastLoggedIn;
        private long lastRefreshed;
        private SessionsRefreshCounter sessionsRefreshCounter;

        public LazySessionInvoker(Repository repository, Credentials credentials, String workspaceName, boolean logoutOnSessionUnbound) {
            this.repository = repository;
            this.credentials = credentials;
            this.workspaceName = workspaceName;
            this.logoutOnSessionUnbound = logoutOnSessionUnbound;
            this.lastRefreshed = System.currentTimeMillis();
        }

        public void setSessionsRefreshCounter(SessionsRefreshCounter sessionsRefreshCounter) {
            this.sessionsRefreshCounter = sessionsRefreshCounter;
        }

        public SessionsRefreshCounter getSessionsRefreshCounter() {
            return this.sessionsRefreshCounter;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Class<?> declaringClass = method.getDeclaringClass();
            String methodName = method.getName();
            if (LazySession.class.isAssignableFrom(declaringClass)) {
                if ("getRefreshPendingAfter".equals(methodName)) {
                    return this.sessionsRefreshCounter.getSessionsRefreshPendingAfter();
                }
                if ("logoutSession".equals(methodName)) {
                    this.clearSession();
                } else {
                    if ("lastLoggedIn".equals(methodName)) {
                        return this.lastLoggedIn;
                    }
                    if ("lastRefreshed".equals(methodName)) {
                        return this.lastRefreshed;
                    }
                }
                return null;
            }
            if (Session.class.isAssignableFrom(declaringClass)) {
                if (this.session == null) {
                    if ("logout".equals(methodName)) {
                        return null;
                    }
                    if ("refresh".equals(methodName)) {
                        return null;
                    }
                    if ("localRefresh".equals(methodName)) {
                        return null;
                    }
                    if ("isLive".equals(methodName)) {
                        return true;
                    }
                    this.session = this.credentials == null && this.workspaceName == null ? this.repository.login() : (this.credentials != null && this.workspaceName == null ? this.repository.login(this.credentials) : (this.credentials == null && this.workspaceName != null ? this.repository.login(this.workspaceName) : this.repository.login(this.credentials, this.workspaceName)));
                    this.lastLoggedIn = System.currentTimeMillis();
                }
                Object ret = null;
                try {
                    if ("localRefresh".equals(methodName)) {
                        this.lastRefreshed = System.currentTimeMillis();
                        if (this.session instanceof HippoSession) {
                            ret = method.invoke((Object)this.session, args);
                        } else {
                            this.session.refresh(false);
                        }
                    } else {
                        ret = method.invoke((Object)this.session, args);
                    }
                }
                catch (Exception e) {
                    if (e.getCause() != null) {
                        throw e.getCause();
                    }
                    throw e;
                }
                if ("refresh".equals(methodName)) {
                    this.lastRefreshed = System.currentTimeMillis();
                }
                return ret;
            }
            if (HttpSessionBindingListener.class.isAssignableFrom(declaringClass)) {
                if ("valueUnbound".equals(methodName)) {
                    log.debug("LazySession session value is being unbound.");
                    this.clearSession();
                }
                return null;
            }
            if ("toString".equals(methodName)) {
                return super.toString() + " (" + this.session + ")";
            }
            return null;
        }

        protected void clearSession() {
            if (!this.logoutOnSessionUnbound) {
                return;
            }
            this.lastLoggedIn = 0L;
            this.lastRefreshed = 0L;
            if (this.session == null) {
                return;
            }
            try {
                if (this.session.isLive()) {
                    this.session.logout();
                }
                this.session = null;
                log.debug("LazySession's session is logged out.");
            }
            catch (Throwable th) {
                if (log.isDebugEnabled()) {
                    log.warn("Failed to logout stateful session.", th);
                }
                log.warn("Failed to logout stateful session: " + th);
            }
        }
    }

    protected static class SessionsRefreshCounter
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private long sessionsRefreshPendingTimeMillis;

        protected SessionsRefreshCounter() {
        }

        public void setSessionsRefreshPendingAfter(long sessionsRefreshPendingTimeMillis) {
            this.sessionsRefreshPendingTimeMillis = sessionsRefreshPendingTimeMillis;
        }

        public long getSessionsRefreshPendingAfter() {
            return this.sessionsRefreshPendingTimeMillis;
        }
    }
}

