/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.container;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.cache.CacheElement;
import org.hippoecm.hst.cache.HstCache;
import org.hippoecm.hst.cache.webfiles.CacheableWebFile;
import org.hippoecm.hst.core.container.AbstractBaseOrderableValve;
import org.hippoecm.hst.core.container.ContainerException;
import org.hippoecm.hst.core.container.ValveContext;
import org.hippoecm.hst.core.request.HstRequestContext;
import org.hippoecm.hst.core.webfiles.WhitelistReader;
import org.hippoecm.hst.util.WebFileUtils;
import org.onehippo.cms7.services.HippoServiceRegistry;
import org.onehippo.cms7.services.webfiles.Binary;
import org.onehippo.cms7.services.webfiles.WebFile;
import org.onehippo.cms7.services.webfiles.WebFileBundle;
import org.onehippo.cms7.services.webfiles.WebFileException;
import org.onehippo.cms7.services.webfiles.WebFileNotFoundException;
import org.onehippo.cms7.services.webfiles.WebFileTagNotFoundException;
import org.onehippo.cms7.services.webfiles.WebFilesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebFileValve
extends AbstractBaseOrderableValve {
    private static final Logger log = LoggerFactory.getLogger(WebFileValve.class);
    private static final long ONE_YEAR_SECONDS = TimeUnit.SECONDS.convert(365L, TimeUnit.DAYS);
    private static final long ONE_YEAR_MILLISECONDS = TimeUnit.MILLISECONDS.convert(ONE_YEAR_SECONDS, TimeUnit.SECONDS);
    static final String WHITE_LIST_CONTENT_PATH = "/hst-whitelist.txt";
    private HstCache webFileCache;
    Cache negativeWebFileCache;

    public void setWebFileCache(HstCache webFileCache) {
        this.webFileCache = webFileCache;
    }

    public void setNegativeWebFileCacheBuilder(CacheBuilder negativeWebFileCacheBuilder) {
        this.negativeWebFileCache = negativeWebFileCacheBuilder.build();
    }

    @Override
    public void invoke(ValveContext context) throws ContainerException {
        HstRequestContext requestContext = context.getRequestContext();
        HttpServletResponse response = context.getServletResponse();
        try {
            CacheableWebFile webFile = this.getWebFile(requestContext);
            boolean includeCacheHeaders = webFile.getVersion() != null;
            WebFileValve.setHeaders(response, webFile, includeCacheHeaders);
            WebFileValve.writeWebFile(response, webFile);
        }
        catch (WebFileException e) {
            HttpServletRequest request = context.getServletRequest();
            if (log.isDebugEnabled()) {
                log.info("Cannot serve binary '{}'", (Object)request.getPathInfo(), (Object)e);
            } else {
                log.info("Cannot serve binary '{}', cause: {}", (Object)request.getPathInfo(), (Object)e.toString());
            }
            response.setStatus(404);
            return;
        }
        catch (Exception e) {
            throw new ContainerException((Throwable)e);
        }
        context.invokeNext();
    }

    private CacheableWebFile getWebFile(HstRequestContext requestContext) throws RepositoryException, ContainerException, IOException, WebFileException {
        WebFilesService service = this.getWebFilesService();
        Session session = requestContext.getSession();
        String bundleName = WebFileUtils.getBundleName((HstRequestContext)requestContext);
        log.debug("Trying to get web file bundle '{}' with session user '{}'", (Object)bundleName, (Object)session.getUserID());
        WebFileBundle webFileBundle = service.getJcrWebFileBundle(session, bundleName);
        String relativeContentPath = requestContext.getResolvedSiteMapItem().getRelativeContentPath();
        if (StringUtils.isEmpty((String)relativeContentPath)) {
            throw new WebFileException("Cannot serve web file for empty relative content path.");
        }
        boolean isWhitelisted = false;
        try {
            Set<String> whitelist = this.getWhitelistReader(requestContext).getWhitelist();
            for (String whitelisted : whitelist) {
                if (!relativeContentPath.startsWith(whitelisted) && !relativeContentPath.equals(whitelisted)) continue;
                isWhitelisted = true;
                break;
            }
        }
        catch (WebFileNotFoundException e) {
            isWhitelisted = false;
        }
        if (!isWhitelisted) {
            String msg = String.format("Web file for relative content path '%s' is not white listed in '%s' for '%s' hence won't be served publicly. If it is required to be served publicly, add it to the file '%s'", relativeContentPath, WHITE_LIST_CONTENT_PATH, bundleName, WHITE_LIST_CONTENT_PATH);
            throw new WebFileException(msg);
        }
        String contentPath = "/" + relativeContentPath;
        String version = this.getVersion(requestContext);
        String cacheKey = "/webfiles/" + bundleName + contentPath;
        if (this.negativeWebFileCache.getIfPresent((Object)cacheKey) != null) {
            throw new WebFileNotFoundException("Negative cache contains requested web file.");
        }
        CacheElement cacheElement = this.webFileCache.get((Object)cacheKey);
        if (cacheElement == null) {
            return this.cacheWebFile(webFileBundle, contentPath, version, cacheKey);
        }
        return (CacheableWebFile)cacheElement.getContent();
    }

    private WhitelistReader getWhitelistReader(HstRequestContext requestContext) throws ContainerException, RepositoryException, WebFileException, IOException {
        String bundleName = WebFileUtils.getBundleName((HstRequestContext)requestContext);
        String version = this.getVersion(requestContext);
        String cacheKey = "/webfiles/" + bundleName + WHITE_LIST_CONTENT_PATH;
        try {
            CacheElement cacheElement = this.webFileCache.get((Object)cacheKey);
            if (cacheElement != null && cacheElement.getContent() instanceof WhitelistReader) {
                return (WhitelistReader)cacheElement.getContent();
            }
            WebFilesService service = this.getWebFilesService();
            Session session = requestContext.getSession();
            WebFileBundle webFileBundle = service.getJcrWebFileBundle(session, bundleName);
            WebFile webFile = this.getWebFileFromBundle(webFileBundle, WHITE_LIST_CONTENT_PATH, version);
            WhitelistReader whiteListReader = new WhitelistReader(webFile.getBinary().getStream());
            CacheElement whiteListReaderElement = this.webFileCache.createElement((Object)cacheKey, (Object)whiteListReader);
            this.webFileCache.put(whiteListReaderElement);
            return whiteListReader;
        }
        catch (Exception e) {
            if (e instanceof WebFileNotFoundException) {
                log.info("No '{}' configured in web files for '{}'. All web files will be whitelisted. In the next PATCH version (HST 3.1.1) all web files will be blacklisted if there is no '{}' configured in web files.", new Object[]{WHITE_LIST_CONTENT_PATH, bundleName, WHITE_LIST_CONTENT_PATH});
            }
            this.clearBlockingLock(cacheKey);
            throw e;
        }
    }

    private WebFilesService getWebFilesService() throws ContainerException {
        WebFilesService service = (WebFilesService)HippoServiceRegistry.getService(WebFilesService.class);
        if (service == null) {
            log.error("Missing service for '{}'. Cannot serve web file.", (Object)WebFilesService.class.getName());
            throw new ContainerException("Missing service for '" + WebFilesService.class.getName() + "'. Cannot serve web file.");
        }
        return service;
    }

    private String getVersion(HstRequestContext requestContext) throws WebFileException {
        String version = requestContext.getResolvedSiteMapItem().getParameter("version");
        if (version == null) {
            log.info("Version is null. Serving latest WebFile version and don't set any cache headers on the response");
        }
        return version;
    }

    private CacheableWebFile cacheWebFile(WebFileBundle webFileBundle, String contentPath, String version, String cacheKey) throws IOException {
        try {
            WebFile webFile = this.getWebFileFromBundle(webFileBundle, contentPath, version);
            CacheableWebFile cacheableWebFile = new CacheableWebFile(webFile, version);
            CacheElement element = this.webFileCache.createElement((Object)cacheKey, (Object)cacheableWebFile);
            this.webFileCache.put(element);
            return cacheableWebFile;
        }
        catch (WebFileException e) {
            if (log.isDebugEnabled()) {
                log.info("Cannot serve binary for '{}'.", (Object)contentPath, (Object)e);
            } else {
                log.info("Cannot serve binary for '{}' : ", (Object)contentPath, (Object)e.toString());
            }
            this.negativeWebFileCache.put((Object)cacheKey, (Object)Boolean.TRUE);
            this.clearBlockingLock(cacheKey);
            throw e;
        }
        catch (Exception e) {
            this.clearBlockingLock(cacheKey);
            throw e;
        }
    }

    private WebFile getWebFileFromBundle(WebFileBundle webFileBundle, String contentPath, String version) throws IOException {
        if (version == null || version.equals(webFileBundle.getAntiCacheValue())) {
            return webFileBundle.get(contentPath);
        }
        throw new WebFileTagNotFoundException("Currently only version == null or version equal to anti cache value is supported");
    }

    private void clearBlockingLock(String cacheKey) {
        log.debug("Clear lock for {}", (Object)cacheKey);
        CacheElement element = this.webFileCache.createElement((Object)cacheKey, null);
        this.webFileCache.put(element);
    }

    private static void setHeaders(HttpServletResponse response, WebFile webFile, boolean includeCacheHeaders) throws RepositoryException {
        response.setHeader("Content-Length", Long.toString(webFile.getBinary().getSize()));
        response.setContentType(webFile.getMimeType());
        if (includeCacheHeaders) {
            response.setDateHeader("Expires", ONE_YEAR_MILLISECONDS + System.currentTimeMillis());
            response.setHeader("Cache-Control", "max-age=" + ONE_YEAR_SECONDS);
        }
    }

    private static void writeWebFile(HttpServletResponse response, WebFile webFile) throws IOException {
        Binary binary = webFile.getBinary();
        try (ServletOutputStream outputStream = response.getOutputStream();){
            IOUtils.copy((InputStream)binary.getStream(), (OutputStream)outputStream);
            outputStream.flush();
        }
    }

    public void onEvent(Event event) throws RepositoryException {
        String path = event.getPath();
        if (path != null) {
            boolean remove;
            int offset = path.indexOf("/jcr:content");
            if (offset != -1) {
                path = path.substring(0, offset);
            }
            if (remove = this.webFileCache.remove((Object)path)) {
                log.debug("Removed '{}' from webFileCache", (Object)path);
            }
            this.negativeWebFileCache.invalidate((Object)path);
        }
    }
}

