/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.container;

import javax.jcr.Repository;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.hippoecm.hst.core.container.AbstractBaseOrderableValve;
import org.hippoecm.hst.core.container.ContainerException;
import org.hippoecm.hst.core.container.ValveContext;
import org.hippoecm.hst.core.internal.HstMutableRequestContext;
import org.hippoecm.hst.core.jcr.LazySession;
import org.hippoecm.hst.core.request.HstRequestContext;
import org.hippoecm.hst.core.request.ResolvedMount;

public class SubjectBasedSessionValve
extends AbstractBaseOrderableValve {
    public static final String SUBJECT_BASED_SESSION_ATTR_NAME = SubjectBasedSessionValve.class.getName() + ".session";
    protected Repository subjectBasedRepository;

    public void setSubjectBasedRepository(Repository subjectBasedRepository) {
        this.subjectBasedRepository = subjectBasedRepository;
    }

    @Override
    public void invoke(ValveContext context) throws ContainerException {
        HttpServletRequest servletRequest = context.getServletRequest();
        HstRequestContext requestContext = (HstRequestContext)servletRequest.getAttribute("org.hippoecm.hst.core.request.HstRequestContext");
        ResolvedMount resolvedMount = requestContext.getResolvedMount();
        boolean subjectBasedSession = resolvedMount.isSubjectBasedSession();
        boolean sessionStateful = resolvedMount.isSessionStateful();
        if (subjectBasedSession) {
            if (requestContext.getSubject() == null) {
                log.debug("Subject based session cannot be set because no subject is found.");
            } else {
                this.markRequestUncacheable(context);
                this.setSubjectSession(context, requestContext, sessionStateful);
            }
        }
        context.invokeNext();
    }

    private void markRequestUncacheable(ValveContext context) {
        context.getPageCacheContext().markUncacheable("Page response marked as uncacheable because subjectBasedSession request rendering.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSubjectSession(ValveContext valveContext, HstRequestContext requestContext, boolean sessionStateful) throws ContainerException {
        LazySession lazySession = null;
        if (sessionStateful) {
            HttpSession httpSession = valveContext.getServletRequest().getSession(false);
            LazySession lazySession2 = lazySession = httpSession != null ? (LazySession)httpSession.getAttribute(SUBJECT_BASED_SESSION_ATTR_NAME) : (LazySession)null;
            if (lazySession != null) {
                boolean isLive = false;
                try {
                    isLive = lazySession.isLive();
                }
                catch (Exception e) {
                    log.error("Error during checking lazy session", (Throwable)e);
                }
                if (!isLive) {
                    try {
                        lazySession.logout();
                    }
                    catch (Exception e) {
                        log.warn("Exception logging out lazySession", (Throwable)e);
                    }
                    finally {
                        lazySession = null;
                    }
                }
            }
        } else {
            lazySession = (LazySession)requestContext.getAttribute(SUBJECT_BASED_SESSION_ATTR_NAME);
        }
        if (lazySession == null) {
            try {
                lazySession = (LazySession)this.subjectBasedRepository.login();
            }
            catch (Exception e) {
                throw new ContainerException("Failed to create session based on subject. Cause '" + e.toString() + "'", (Throwable)e);
            }
        }
        if (sessionStateful) {
            valveContext.getServletRequest().getSession(true).setAttribute(SUBJECT_BASED_SESSION_ATTR_NAME, (Object)lazySession);
        } else {
            requestContext.setAttribute(SUBJECT_BASED_SESSION_ATTR_NAME, (Object)lazySession);
        }
        ((HstMutableRequestContext)requestContext).setSession((Session)lazySession);
    }
}

