/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.container;

import java.io.IOException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.Credentials;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.configuration.hosting.Mount;
import org.hippoecm.hst.core.container.AbstractBaseOrderableValve;
import org.hippoecm.hst.core.container.ContainerException;
import org.hippoecm.hst.core.container.ContainerSecurityException;
import org.hippoecm.hst.core.container.ContainerSecurityNotAuthenticatedException;
import org.hippoecm.hst.core.container.ContainerSecurityNotAuthorizedException;
import org.hippoecm.hst.core.container.ValveContext;
import org.hippoecm.hst.core.internal.HstMutableRequestContext;
import org.hippoecm.hst.core.linking.HstLink;
import org.hippoecm.hst.core.request.HstRequestContext;
import org.hippoecm.hst.core.request.ResolvedMount;
import org.hippoecm.hst.core.request.ResolvedSiteMapItem;
import org.hippoecm.hst.security.AuthenticationProvider;
import org.hippoecm.hst.security.HstSubject;
import org.hippoecm.hst.security.PolicyContextWrapper;
import org.hippoecm.hst.security.TransientUser;

public class SecurityValve
extends AbstractBaseOrderableValve {
    public static final String DESTINATION_ATTR_NAME = "org.hippoecm.hst.security.servlet.destination";
    public static final String SECURITY_EXCEPTION_ATTR_NAME = "org.hippoecm.hst.security.servlet.exception";
    protected AuthenticationProvider authProvider;

    public void setAuthenticationProvider(AuthenticationProvider authProvider) {
        this.authProvider = authProvider;
    }

    @Override
    public void invoke(ValveContext context) throws ContainerException {
        Subject subject;
        HttpServletRequest servletRequest;
        HstRequestContext requestContext;
        block26: {
            requestContext = context.getRequestContext();
            if (requestContext.isCmsRequest() && requestContext.getResolvedMount().getMount().getVirtualHost().getVirtualHosts().isChannelMngrSiteAuthenticationSkipped()) {
                log.debug("Bypassing security valve because the request comes fo a CMS application and it's configured to skip authentication for those requests.");
                context.invokeNext();
                return;
            }
            servletRequest = context.getServletRequest();
            HttpServletResponse servletResponse = context.getServletResponse();
            ResolvedMount resolvedMount = requestContext.getResolvedMount();
            boolean accessAllowed = false;
            boolean authenticationRequired = false;
            Throwable securityException = null;
            try {
                this.checkAccess(servletRequest);
                accessAllowed = true;
            }
            catch (ContainerSecurityNotAuthenticatedException e) {
                authenticationRequired = true;
                securityException = e;
            }
            catch (ContainerSecurityNotAuthorizedException e) {
                securityException = e;
            }
            catch (ContainerSecurityException e) {
                securityException = e;
            }
            if (!accessAllowed) {
                HstLink destinationLink;
                block25: {
                    Mount destLinkMount;
                    String formLoginPage;
                    block24: {
                        destinationLink = null;
                        formLoginPage = resolvedMount.getFormLoginPage();
                        destLinkMount = resolvedMount.getMount();
                        try {
                            ResolvedSiteMapItem resolvedSiteMapItem;
                            Mount siteMount;
                            if (!destLinkMount.isMapped() && (siteMount = requestContext.getMount("site")) != null) {
                                destLinkMount = siteMount;
                            }
                            if (StringUtils.isBlank((String)formLoginPage)) {
                                formLoginPage = destLinkMount.getFormLoginPage();
                            }
                            String pathInfo = (resolvedSiteMapItem = requestContext.getResolvedSiteMapItem()) == null ? "" : resolvedSiteMapItem.getPathInfo();
                            destinationLink = requestContext.getHstLinkCreator().create(pathInfo, destLinkMount);
                        }
                        catch (Exception linkEx) {
                            if (log.isDebugEnabled()) {
                                log.warn("Failed to create destination link.", (Throwable)linkEx);
                            }
                            if (!log.isWarnEnabled()) break block24;
                            log.warn("Failed to create destination link. {}", (Object)linkEx.toString());
                        }
                    }
                    if (authenticationRequired && !StringUtils.isBlank((String)formLoginPage)) {
                        try {
                            HttpSession httpSession = servletRequest.getSession(true);
                            httpSession.setAttribute(DESTINATION_ATTR_NAME, (Object)destinationLink.toUrlForm(requestContext, true));
                            httpSession.setAttribute(SECURITY_EXCEPTION_ATTR_NAME, (Object)securityException);
                            String formLoginURL = requestContext.getHstLinkCreator().create(formLoginPage, destLinkMount).toUrlForm(requestContext, true);
                            servletResponse.sendRedirect(formLoginURL);
                            return;
                        }
                        catch (IOException ioe) {
                            if (log.isDebugEnabled()) {
                                log.warn("Failed to redirect to form login page. " + formLoginPage, (Throwable)ioe);
                            }
                            if (!log.isWarnEnabled()) break block25;
                            log.warn("Failed to redirect to form login page. " + formLoginPage + ". {}", (Object)ioe.toString());
                        }
                    }
                }
                try {
                    String queryString = requestContext.getServletRequest().getQueryString();
                    String destinationURL = destinationLink.toUrlForm(requestContext, true);
                    if (queryString != null) {
                        destinationURL = destinationURL.contains("?") ? destinationURL + "&" + queryString : destinationURL + "?" + queryString;
                    }
                    HttpSession httpSession = servletRequest.getSession(true);
                    httpSession.setAttribute(DESTINATION_ATTR_NAME, (Object)destinationURL);
                    if (authenticationRequired) {
                        servletResponse.sendError(401, securityException != null ? securityException.getLocalizedMessage() : null);
                    } else {
                        servletResponse.sendError(403, securityException != null ? securityException.getLocalizedMessage() : null);
                    }
                    return;
                }
                catch (IOException ioe) {
                    if (log.isDebugEnabled()) {
                        log.warn("Failed to send error code.", (Throwable)ioe);
                    }
                    if (!log.isWarnEnabled()) break block26;
                    log.warn("Failed to send error code. {}", (Object)ioe.toString());
                }
            }
        }
        if ((subject = requestContext.getSubject()) == null) {
            subject = this.getSubject(servletRequest);
        }
        if (subject == null) {
            context.invokeNext();
            return;
        }
        final ValveContext valveContext = context;
        ContainerException ce = (ContainerException)((Object)HstSubject.doAsPrivileged((Subject)subject, (PrivilegedAction)new PrivilegedAction<ContainerException>(){

            @Override
            public ContainerException run() {
                try {
                    valveContext.invokeNext();
                    ContainerException containerException = null;
                    return containerException;
                }
                catch (ContainerException e) {
                    ContainerException containerException = e;
                    return containerException;
                }
                finally {
                    HstSubject.clearSubject();
                }
            }
        }, null));
        if (ce != null) {
            throw ce;
        }
    }

    protected void checkAccess(HttpServletRequest servletRequest) throws ContainerSecurityException {
        boolean authenticated;
        HstRequestContext requestContext = (HstRequestContext)servletRequest.getAttribute("org.hippoecm.hst.core.request.HstRequestContext");
        ResolvedSiteMapItem resolvedSiteMapItem = requestContext.getResolvedSiteMapItem();
        Set roles = null;
        Set users = null;
        boolean bl = authenticated = resolvedSiteMapItem != null && resolvedSiteMapItem.isAuthenticated();
        if (authenticated) {
            roles = resolvedSiteMapItem.getRoles();
            users = resolvedSiteMapItem.getUsers();
        } else {
            ResolvedMount mount = requestContext.getResolvedMount();
            boolean bl2 = authenticated = mount != null && mount.isAuthenticated();
            if (authenticated) {
                roles = mount.getRoles();
                users = mount.getUsers();
            }
        }
        if (!authenticated) {
            log.debug("The sitemap item or site mount is non-authenticated.");
            return;
        }
        Principal userPrincipal = servletRequest.getUserPrincipal();
        if (userPrincipal == null) {
            log.debug("The user has not been authenticated yet.");
            throw new ContainerSecurityNotAuthenticatedException("Not authenticated yet.");
        }
        if (users.isEmpty() && roles.isEmpty()) {
            log.debug("The roles or users are not configured.");
        }
        if (!users.isEmpty()) {
            if (users.contains(userPrincipal.getName())) {
                return;
            }
            log.debug("The user is not assigned to users, {}", (Object)users);
        }
        if (!roles.isEmpty()) {
            for (String role : roles) {
                if (!servletRequest.isUserInRole(role)) continue;
                return;
            }
            log.debug("The user is not assigned to roles, {}", (Object)roles);
        }
        throw new ContainerSecurityNotAuthorizedException("Not authorized.");
    }

    protected Subject getSubject(HttpServletRequest request) {
        HttpSession session;
        Principal userPrincipal = request.getUserPrincipal();
        if (userPrincipal == null) {
            return null;
        }
        Subject subject = (Subject)PolicyContextWrapper.getContext((String)"javax.security.auth.Subject.container");
        if (subject == null && (session = request.getSession(false)) != null) {
            subject = (Subject)session.getAttribute("org.hippoecm.hst.security.servlet.subject");
        }
        if (subject == null) {
            Credentials subjectRepoCreds;
            TransientUser user = new TransientUser(userPrincipal.getName());
            HashSet<Principal> principals = new HashSet<Principal>();
            principals.add(userPrincipal);
            principals.add((Principal)user);
            if (this.authProvider != null) {
                Set roleSet = this.authProvider.getRolesByUsername(userPrincipal.getName());
                principals.addAll(roleSet);
            }
            HashSet pubCred = new HashSet();
            HashSet<Credentials> privCred = new HashSet<Credentials>();
            HttpSession session2 = request.getSession(false);
            if (session2 != null && (subjectRepoCreds = (Credentials)session2.getAttribute("org.hippoecm.hst.security.servlet.subject.repo.creds")) != null) {
                session2.removeAttribute("org.hippoecm.hst.security.servlet.subject.repo.creds");
                privCred.add(subjectRepoCreds);
            }
            subject = new Subject(true, principals, pubCred, privCred);
            if (session2 != null) {
                session2.setAttribute("org.hippoecm.hst.security.servlet.subject", (Object)subject);
            }
        }
        HstRequestContext requestContext = (HstRequestContext)request.getAttribute("org.hippoecm.hst.core.request.HstRequestContext");
        ((HstMutableRequestContext)requestContext).setSubject(subject);
        return subject;
    }
}

