/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.container;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hippoecm.hst.core.component.HstRequestImpl;
import org.hippoecm.hst.core.component.HstResourceResponseImpl;
import org.hippoecm.hst.core.container.AbstractBaseOrderableValve;
import org.hippoecm.hst.core.container.ContainerException;
import org.hippoecm.hst.core.container.HstComponentInvoker;
import org.hippoecm.hst.core.container.HstComponentWindow;
import org.hippoecm.hst.core.container.HstContainerURL;
import org.hippoecm.hst.core.container.PageErrors;
import org.hippoecm.hst.core.container.ValveContext;
import org.hippoecm.hst.core.request.HstRequestContext;

public class ResourceServingValve
extends AbstractBaseOrderableValve {
    @Override
    public void invoke(ValveContext context) throws ContainerException {
        HstRequestContext requestContext = context.getRequestContext();
        HstContainerURL baseURL = requestContext.getBaseURL();
        String resourceWindowRef = baseURL.getResourceWindowReferenceNamespace();
        if (resourceWindowRef == null) {
            context.invokeNext();
            return;
        }
        if (context.getServletResponse().isCommitted()) {
            log.warn("Stopping resource serving. The response is already committed.");
            context.invokeNext();
            return;
        }
        HttpServletRequest servletRequest = context.getServletRequest();
        HttpServletResponse servletResponse = context.getServletResponse();
        HstComponentWindow window = context.getRootComponentWindow();
        HstRequestImpl request = new HstRequestImpl(servletRequest, requestContext, window, "RESOURCE_PHASE");
        HstResourceResponseImpl response = new HstResourceResponseImpl(servletResponse, requestContext, window);
        HstComponentInvoker invoker = this.getComponentInvoker();
        invoker.invokeBeforeServeResource(context.getRequestContainerConfig(), (ServletRequest)request, (ServletResponse)response);
        PageErrors pageErrors = this.getPageErrors(new HstComponentWindow[]{window}, true);
        if (pageErrors != null) {
            this.handleComponentExceptions(pageErrors, context.getRequestContainerConfig(), window, request, response);
        }
        invoker.invokeServeResource(context.getRequestContainerConfig(), (ServletRequest)request, (ServletResponse)response);
        pageErrors = this.getPageErrors(new HstComponentWindow[]{window}, true);
        if (pageErrors != null) {
            this.handleComponentExceptions(pageErrors, context.getRequestContainerConfig(), window, request, response);
        }
    }
}

