/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.container;

import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.hippoecm.hst.container.RequestContextProvider;
import org.hippoecm.hst.content.annotations.Persistable;
import org.hippoecm.hst.core.component.HstComponentMetadata;
import org.hippoecm.hst.core.component.HstRequestImpl;
import org.hippoecm.hst.core.internal.HstMutableRequestContext;
import org.hippoecm.hst.core.jcr.LazySession;
import org.hippoecm.hst.core.request.HstRequestContext;
import org.hippoecm.hst.site.HstServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistableSessionAroundAdvice {
    private static Logger log = LoggerFactory.getLogger(PersistableSessionAroundAdvice.class);
    private static final String PERSISTABLE_SESSION_ATTR = PersistableSessionAroundAdvice.class.getName() + ".persistableSession";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(ProceedingJoinPoint call) throws Throwable {
        HstRequestContext requestContext = RequestContextProvider.get();
        if (requestContext == null) {
            return call.proceed();
        }
        Object[] args = call.getArgs();
        String invokerMethodName = call.getSignature().getName();
        String compMethodName = StringUtils.replaceOnce((String)invokerMethodName, (String)"invoke", (String)"do");
        if (args.length < 2 || !(args[1] instanceof HstRequestImpl)) {
            return call.proceed();
        }
        HstComponentMetadata compMetadata = ((HstRequestImpl)((Object)args[1])).getComponentWindow().getComponentMetadata();
        if (compMetadata == null || !compMetadata.hasMethodAnnotatedBy(Persistable.class.getName(), compMethodName)) {
            return call.proceed();
        }
        Session existingSession = requestContext.getSession(false);
        if (existingSession instanceof LazySession) {
            return call.proceed();
        }
        Session persistableSession = (Session)requestContext.getAttribute(PERSISTABLE_SESSION_ATTR);
        if (persistableSession == null) {
            try {
                Repository repository = (Repository)HstServices.getComponentManager().getComponent(Repository.class.getName());
                Credentials persistableCredentials = requestContext.getContextCredentialsProvider().getWritableCredentials(requestContext);
                persistableSession = repository.login(persistableCredentials);
                requestContext.setAttribute(PERSISTABLE_SESSION_ATTR, (Object)persistableSession);
            }
            catch (Exception e) {
                log.warn("Failed to get a persistableSession", (Throwable)e);
            }
        }
        if (persistableSession == null) {
            return call.proceed();
        }
        try {
            ((HstMutableRequestContext)requestContext).setSession(persistableSession);
            Object object = call.proceed();
            return object;
        }
        finally {
            ((HstMutableRequestContext)requestContext).setSession(existingSession);
        }
    }
}

