/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.container;

import java.io.IOException;
import java.net.SocketException;
import java.util.List;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.ehcache.constructs.web.Header;
import org.hippoecm.hst.cache.ForwardPlaceHolderHstPageInfo;
import org.hippoecm.hst.cache.HstPageInfo;
import org.hippoecm.hst.core.container.AbstractBaseOrderableValve;
import org.hippoecm.hst.core.container.ContainerException;
import org.hippoecm.hst.core.container.ValveContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageInfoRenderingValve
extends AbstractBaseOrderableValve {
    static final String PAGE_INFO = PageInfoRenderingValve.class.getName() + ".pageInfo";
    private static final Logger log = LoggerFactory.getLogger(PageInfoRenderingValve.class);

    @Override
    public void invoke(ValveContext context) throws ContainerException {
        HttpServletRequest request = context.getServletRequest();
        context.invokeNext();
        HstPageInfo pageInfo = (HstPageInfo)((Object)request.getAttribute(PAGE_INFO));
        if (pageInfo == null) {
            return;
        }
        HttpServletResponse response = context.getServletResponse();
        try {
            if (pageInfo instanceof ForwardPlaceHolderHstPageInfo) {
                log.debug("'{}' is being forwarded internally.", (Object)request);
                String forwardPathInfo = ((ForwardPlaceHolderHstPageInfo)pageInfo).getForwardPathInfo();
                request.setAttribute("org.hippoecm.hst.container.forward.path_info", (Object)forwardPathInfo);
                return;
            }
            if (!response.isCommitted()) {
                this.writeResponse(response, pageInfo);
            }
        }
        catch (SocketException e) {
            if (log.isDebugEnabled()) {
                log.info("Unable to write response due to SocketException", (Throwable)e);
            } else {
                log.info("Unable to write response due to SocketException : {}", (Object)e.toString());
            }
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.warn("Unable to write response", (Throwable)e);
            }
            log.warn("Unable to write response : {}", (Object)e.toString());
        }
    }

    protected void writeResponse(HttpServletResponse response, HstPageInfo pageInfo) throws IOException {
        this.setStatus(response, pageInfo);
        this.setContentType(response, pageInfo);
        this.setHeaders(pageInfo, response);
        pageInfo.writeContent(response);
    }

    protected void setStatus(HttpServletResponse response, HstPageInfo pageInfo) {
        response.setStatus(pageInfo.getStatusCode());
    }

    protected void setContentType(HttpServletResponse response, HstPageInfo pageInfo) {
        String contentType = pageInfo.getContentType();
        if (contentType != null && contentType.length() > 0) {
            response.setContentType(contentType);
        }
    }

    protected void setHeaders(HstPageInfo pageInfo, HttpServletResponse response) {
        List headers = pageInfo.getHeaders();
        TreeSet<String> setHeaders = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        block5: for (Header header : headers) {
            String name = header.getName();
            switch (header.getType()) {
                case STRING: {
                    if (setHeaders.contains(name)) {
                        response.addHeader(name, (String)((Object)header.getValue()));
                        continue block5;
                    }
                    setHeaders.add(name);
                    response.setHeader(name, (String)((Object)header.getValue()));
                    continue block5;
                }
                case DATE: {
                    if (setHeaders.contains(name)) {
                        response.addDateHeader(name, ((Long)header.getValue()).longValue());
                        continue block5;
                    }
                    setHeaders.add(name);
                    response.setDateHeader(name, ((Long)header.getValue()).longValue());
                    continue block5;
                }
                case INT: {
                    if (setHeaders.contains(name)) {
                        response.addIntHeader(name, ((Integer)header.getValue()).intValue());
                        continue block5;
                    }
                    setHeaders.add(name);
                    response.setIntHeader(name, ((Integer)header.getValue()).intValue());
                    continue block5;
                }
            }
            throw new IllegalArgumentException("No mapping for Header: " + header);
        }
    }
}

