/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.container;

import java.io.Serializable;
import java.util.concurrent.Callable;
import org.hippoecm.hst.cache.CacheElement;
import org.hippoecm.hst.cache.HstCache;
import org.hippoecm.hst.cache.HstCacheException;
import org.hippoecm.hst.cache.HstPageInfo;
import org.hippoecm.hst.cache.UncacheableHstPageInfo;
import org.hippoecm.hst.core.container.AbstractBaseOrderableValve;
import org.hippoecm.hst.core.container.ContainerException;
import org.hippoecm.hst.core.container.DefaultRequestInfoCacheKeyFragmentCreator;
import org.hippoecm.hst.core.container.PageCacheKey;
import org.hippoecm.hst.core.container.PageInfoRenderingValve;
import org.hippoecm.hst.core.container.RequestInfoCacheKeyFragmentCreator;
import org.hippoecm.hst.core.container.ValveContext;
import org.hippoecm.hst.core.request.HstRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageCachingValve
extends AbstractBaseOrderableValve {
    private static final String REQUEST_INFO_CACHE_KEY_ATTR_NAME = PageCachingValve.class.getName() + ".reqInfo";
    private static final Logger log = LoggerFactory.getLogger(PageCachingValve.class);
    protected HstCache pageCache;
    private RequestInfoCacheKeyFragmentCreator requestInfoCacheKeyFragmentCreator;

    public PageCachingValve() {
        this(new DefaultRequestInfoCacheKeyFragmentCreator());
    }

    public PageCachingValve(RequestInfoCacheKeyFragmentCreator requestInfoCacheKeyFragmentCreator) {
        this.requestInfoCacheKeyFragmentCreator = requestInfoCacheKeyFragmentCreator;
    }

    public void setPageCache(HstCache pageCache) {
        this.pageCache = pageCache;
    }

    @Override
    public void invoke(ValveContext context) throws ContainerException {
        HstRequestContext requestContext = context.getRequestContext();
        if (!this.isRequestCacheable(context)) {
            context.invokeNext();
            return;
        }
        try {
            this.appendRequestInfoToCacheKey(context);
            HstPageInfo pageInfo = this.getPageInfoFromCacheOrBuild(context);
            if (pageInfo == null) {
                throw new ContainerException("PageInfo null. ");
            }
            requestContext.getServletRequest().setAttribute(PageInfoRenderingValve.PAGE_INFO, (Object)pageInfo);
        }
        catch (HstCacheException e) {
            throw new ContainerException("Cache exception : ", (Throwable)e);
        }
        catch (Exception e) {
            throw new ContainerException((Throwable)e);
        }
    }

    private void appendRequestInfoToCacheKey(ValveContext context) {
        Serializable requestInfo = this.requestInfoCacheKeyFragmentCreator.create(context.getRequestContext());
        PageCacheKey pageCacheKey = context.getPageCacheContext().getPageCacheKey();
        pageCacheKey.setAttribute(REQUEST_INFO_CACHE_KEY_ATTR_NAME, requestInfo);
    }

    protected HstPageInfo getPageInfoFromCacheOrBuild(final ValveContext context) throws Exception {
        final PageCacheKey keyPage = context.getPageCacheContext().getPageCacheKey();
        keyPage.seal();
        CacheElement element = this.pageCache.get((Object)keyPage, (Callable)new Callable<CacheElement>(){

            @Override
            public CacheElement call() throws Exception {
                HstPageInfo pageInfo = PageCachingValve.this.createHstPageInfoByInvokingNextValve(context, PageCachingValve.this.pageCache.getTimeToLiveSeconds());
                if (pageInfo.isOk()) {
                    if (pageInfo.isNoCachePresentOrExpiresImmediately()) {
                        log.debug("Creating uncacheable element for '{}' with keyPage '{}' because it contains no cache header or expires immediately.", (Object)context.getServletRequest(), (Object)keyPage);
                        return PageCachingValve.this.pageCache.createUncacheableElement((Object)keyPage, (Object)pageInfo);
                    }
                    if (pageInfo instanceof UncacheableHstPageInfo) {
                        return PageCachingValve.this.pageCache.createUncacheableElement((Object)keyPage, (Object)pageInfo);
                    }
                    log.debug("Caching request '{}' with keyPage '{}'", (Object)context.getServletRequest().getRequestURI(), (Object)keyPage);
                    CacheElement elem = PageCachingValve.this.pageCache.createElement((Object)keyPage, (Object)pageInfo);
                    Long expiresHeader = pageInfo.getExpiresInSeconds();
                    if (expiresHeader != null) {
                        elem.setTimeToLiveSeconds(expiresHeader.intValue());
                    }
                    return elem;
                }
                log.debug("PageInfo was not ok(200). Putting null into cache with keyPage {} ", (Object)keyPage);
                return PageCachingValve.this.pageCache.createUncacheableElement((Object)keyPage, (Object)pageInfo);
            }
        });
        return (HstPageInfo)((Object)element.getContent());
    }
}

