/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.container;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.core.container.AbstractBaseOrderableValve;
import org.hippoecm.hst.core.container.ContainerException;
import org.hippoecm.hst.core.container.ValveContext;
import org.hippoecm.hst.util.HstRequestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotFoundValve
extends AbstractBaseOrderableValve {
    private static final Logger log = LoggerFactory.getLogger(NotFoundValve.class);

    @Override
    public void invoke(ValveContext context) throws ContainerException {
        HttpServletResponse servletResponse = context.getServletResponse();
        String url = HstRequestUtils.getFarthestRequestHost((HttpServletRequest)context.getServletRequest()) + context.getServletRequest().getRequestURI();
        if (!StringUtils.isEmpty((String)context.getServletRequest().getQueryString())) {
            url = url + "?" + context.getServletRequest().getQueryString();
        }
        log.warn("Return HttpServletResponse.SC_NOT_FOUND (404) because NoopPipeline was invoked for {}", (Object)context.getServletRequest());
        servletResponse.setStatus(404);
    }
}

