/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.container;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.jstl.core.Config;
import javax.servlet.jsp.jstl.fmt.LocalizationContext;
import org.apache.commons.lang.LocaleUtils;
import org.hippoecm.hst.configuration.hosting.Mount;
import org.hippoecm.hst.configuration.sitemap.HstSiteMapItem;
import org.hippoecm.hst.core.container.AbstractBaseOrderableValve;
import org.hippoecm.hst.core.container.ContainerException;
import org.hippoecm.hst.core.container.ValveContext;
import org.hippoecm.hst.core.internal.HstMutableRequestContext;
import org.hippoecm.hst.core.request.HstRequestContext;
import org.hippoecm.hst.resourcebundle.CompositeResourceBundle;
import org.hippoecm.hst.resourcebundle.ResourceBundleRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalizationValve
extends AbstractBaseOrderableValve {
    private static final Logger log = LoggerFactory.getLogger(LocalizationValve.class);

    @Override
    public void invoke(ValveContext context) throws ContainerException {
        ResourceBundle defaultResourceBundle;
        HttpSession session;
        HstMutableRequestContext requestContext;
        HttpServletRequest servletRequest = context.getServletRequest();
        Locale preferredLocale = this.findPreferredLocale(servletRequest, (HstRequestContext)(requestContext = (HstMutableRequestContext)context.getRequestContext()));
        if (preferredLocale == null && (preferredLocale = (Locale)servletRequest.getAttribute("org.hippoecm.hst.container.preferred.locale")) == null && (session = servletRequest.getSession(false)) != null) {
            preferredLocale = (Locale)session.getAttribute("org.hippoecm.hst.container.preferred.locale");
        }
        if (preferredLocale != null) {
            ArrayList<Locale> locales = new ArrayList<Locale>();
            locales.add(preferredLocale);
            Enumeration e = servletRequest.getLocales();
            while (e.hasMoreElements()) {
                Locale locale = (Locale)e.nextElement();
                if (locale.equals(preferredLocale)) continue;
                locales.add(locale);
            }
            requestContext.setPreferredLocale(preferredLocale);
            requestContext.setLocales(locales);
            requestContext.setAttribute("javax.servlet.jsp.jstl.fmt.locale.application", (Object)preferredLocale);
            servletRequest.setAttribute("javax.servlet.jsp.jstl.fmt.locale.request", (Object)preferredLocale);
        }
        if ((defaultResourceBundle = this.findDefaultResourceBundle((HstRequestContext)requestContext)) != null) {
            Config.set((ServletRequest)servletRequest, (String)"javax.servlet.jsp.jstl.fmt.localizationContext", (Object)new LocalizationContext(defaultResourceBundle));
        }
        context.invokeNext();
    }

    protected Locale findPreferredLocale(HttpServletRequest request, HstRequestContext requestContext) {
        Mount mount;
        HstSiteMapItem siteMapItem;
        String localeString;
        if (requestContext.getResolvedSiteMapItem() != null && (localeString = (siteMapItem = requestContext.getResolvedSiteMapItem().getHstSiteMapItem()).getLocale()) != null) {
            try {
                Locale locale = LocaleUtils.toLocale((String)localeString);
                log.debug("Preferred locale for request is set to '{}' by sitemap item '{}'", (Object)localeString, (Object)siteMapItem.getId());
                return locale;
            }
            catch (IllegalArgumentException e) {
                log.warn("Invalid locale, '{}', on the sitemap item, '{}'.", (Object)localeString, (Object)siteMapItem.getId());
            }
        }
        if (requestContext.getResolvedMount() != null && (localeString = (mount = requestContext.getResolvedMount().getMount()).getLocale()) != null) {
            try {
                Locale locale = LocaleUtils.toLocale((String)localeString);
                log.debug("Preferred locale for request is set to '{}' by Mount '{}'", (Object)localeString, (Object)mount.getName());
                return locale;
            }
            catch (IllegalArgumentException e) {
                log.warn("Invalid locale, '{}', on the mount, '{}'.", (Object)localeString, (Object)mount.getName());
            }
        }
        return null;
    }

    protected ResourceBundle findDefaultResourceBundle(HstRequestContext requestContext) {
        ArrayList<ResourceBundle> bundles = new ArrayList<ResourceBundle>();
        if (requestContext.getResolvedMount() != null) {
            String[] bundleIds = null;
            bundleIds = requestContext.getResolvedSiteMapItem() != null ? requestContext.getResolvedSiteMapItem().getHstSiteMapItem().getResourceBundleIds() : requestContext.getResolvedMount().getMount().getDefaultResourceBundleIds();
            ResourceBundleRegistry bundleRegistry = this.getResourceBundleRegistry();
            Locale locale = requestContext.getPreferredLocale();
            ResourceBundle bundle = null;
            for (String bundleId : bundleIds) {
                try {
                    bundle = bundleRegistry != null ? (locale == null ? (requestContext.isPreview() ? bundleRegistry.getBundleForPreview(bundleId) : bundleRegistry.getBundle(bundleId)) : (requestContext.isPreview() ? bundleRegistry.getBundleForPreview(bundleId, locale) : bundleRegistry.getBundle(bundleId, locale))) : (locale == null ? ResourceBundle.getBundle(bundleId, Locale.getDefault(), Thread.currentThread().getContextClassLoader()) : ResourceBundle.getBundle(bundleId, locale, Thread.currentThread().getContextClassLoader()));
                    if (bundle == null) continue;
                    bundles.add(bundle);
                }
                catch (MissingResourceException e) {
                    log.warn("Resource bundle not found by the basename, '{}'. {}", (Object)bundleId, (Object)e);
                }
            }
        }
        if (bundles.isEmpty()) {
            return null;
        }
        if (bundles.size() == 1) {
            return (ResourceBundle)bundles.get(0);
        }
        return new CompositeResourceBundle(bundles.toArray(new ResourceBundle[bundles.size()]));
    }
}

