/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.container;

import org.hippoecm.hst.core.container.AbstractBaseOrderableValve;
import org.hippoecm.hst.core.container.ContainerException;
import org.hippoecm.hst.core.container.ValveContext;
import org.hippoecm.hst.jaxrs.JAXRSService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaxrsRestServiceValve
extends AbstractBaseOrderableValve {
    private static final Logger log = LoggerFactory.getLogger(JaxrsRestServiceValve.class);
    private JAXRSService service;

    public JaxrsRestServiceValve(JAXRSService service) {
        this.service = service;
    }

    @Override
    public void invoke(ValveContext context) throws ContainerException {
        try {
            this.service.invoke(context.getRequestContext(), context.getServletRequest(), context.getServletResponse());
        }
        catch (ContainerException ce) {
            throw ce;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.error("Failed to invoke jaxrs service.", (Throwable)e);
            } else {
                log.error("Failed to invoke jaxrs service. {}", (Object)e.toString());
            }
            throw new ContainerException((Throwable)e);
        }
    }

    @Override
    public void destroy() {
        this.service.destroy();
    }
}

