/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.container;

import javax.jcr.LoginException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import org.hippoecm.hst.core.container.AbstractBaseOrderableValve;
import org.hippoecm.hst.core.container.ContainerException;
import org.hippoecm.hst.core.container.ValveContext;
import org.hippoecm.hst.core.jcr.LazySession;
import org.hippoecm.hst.core.request.HstRequestContext;
import org.hippoecm.hst.core.request.ResolvedMount;

public class JCRSessionStatefulConcurrencyValve
extends AbstractBaseOrderableValve {
    protected long maxRefreshIntervalOnLazySession = 300000L;

    public void setMaxRefreshIntervalOnLazySession(long maxRefreshIntervalOnLazySession) {
        this.maxRefreshIntervalOnLazySession = maxRefreshIntervalOnLazySession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(ValveContext context) throws ContainerException {
        Session session;
        HttpServletRequest servletRequest = context.getServletRequest();
        HstRequestContext requestContext = (HstRequestContext)servletRequest.getAttribute("org.hippoecm.hst.core.request.HstRequestContext");
        ResolvedMount resolvedMount = requestContext.getResolvedMount();
        boolean subjectBasedSession = resolvedMount.isSubjectBasedSession();
        boolean sessionStateful = resolvedMount.isSessionStateful();
        if (!subjectBasedSession || !sessionStateful) {
            context.invokeNext();
            return;
        }
        try {
            session = requestContext.getSession();
        }
        catch (LoginException e) {
            throw new ContainerException((Throwable)e);
        }
        catch (RepositoryException e) {
            throw new ContainerException((Throwable)e);
        }
        if (session instanceof LazySession) {
            Session session2 = session;
            synchronized (session2) {
                LazySession lazySession = (LazySession)session;
                if (this.maxRefreshIntervalOnLazySession > 0L) {
                    if (System.currentTimeMillis() - lazySession.lastRefreshed() > this.maxRefreshIntervalOnLazySession) {
                        this.refreshSession(lazySession);
                    } else {
                        long refreshPendingTimeMillis = lazySession.getRefreshPendingAfter();
                        if (refreshPendingTimeMillis > 0L && lazySession.lastRefreshed() < refreshPendingTimeMillis) {
                            this.refreshSession(lazySession);
                        }
                    }
                } else {
                    this.refreshSession(lazySession);
                }
                context.invokeNext();
            }
            return;
        }
        context.invokeNext();
    }

    private void refreshSession(LazySession session) {
        if (session.isLive()) {
            session.localRefresh();
        }
    }
}

