/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.container;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.core.container.ContainerException;
import org.hippoecm.hst.core.container.HstComponentWindow;
import org.hippoecm.hst.core.container.HstContainerConfig;
import org.hippoecm.hst.core.container.OrderableValve;
import org.hippoecm.hst.core.container.PageCacheContext;
import org.hippoecm.hst.core.container.PageCacheKey;
import org.hippoecm.hst.core.container.Pipeline;
import org.hippoecm.hst.core.container.Valve;
import org.hippoecm.hst.core.container.ValveContext;
import org.hippoecm.hst.core.internal.HstMutableRequestContext;
import org.hippoecm.hst.core.order.ObjectOrderer;
import org.hippoecm.hst.core.request.HstRequestContext;
import org.hippoecm.hst.diagnosis.HDC;
import org.hippoecm.hst.diagnosis.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HstSitePipeline
implements Pipeline {
    protected static final Logger log = LoggerFactory.getLogger(HstSitePipeline.class);
    protected Valve[] initializationValves;
    protected Valve[] processingValves;
    protected Valve[] cleanupValves;
    private Valve[] mergedProcessingValves;
    private Valve[] mergedCleanupValves;

    public void setInitializationValves(Valve[] initializationValves) {
        if (initializationValves == null) {
            this.initializationValves = null;
        } else {
            this.initializationValves = new Valve[initializationValves.length];
            System.arraycopy(initializationValves, 0, this.initializationValves, 0, initializationValves.length);
        }
        this.mergedProcessingValves = null;
    }

    public void addInitializationValve(Valve initializationValve) {
        this.initializationValves = this.add(this.initializationValves, initializationValve);
        this.mergedProcessingValves = null;
    }

    public void setProcessingValves(Valve[] processingValves) {
        if (processingValves == null) {
            this.processingValves = null;
        } else {
            this.processingValves = new Valve[processingValves.length];
            System.arraycopy(processingValves, 0, this.processingValves, 0, processingValves.length);
        }
        this.mergedProcessingValves = null;
    }

    public void addProcessingValve(Valve processingValve) {
        this.processingValves = this.add(this.processingValves, processingValve);
        this.mergedProcessingValves = null;
    }

    public void setCleanupValves(Valve[] cleanupValve) {
        if (cleanupValve == null) {
            this.cleanupValves = null;
        } else {
            this.cleanupValves = new Valve[cleanupValve.length];
            System.arraycopy(cleanupValve, 0, this.cleanupValves, 0, cleanupValve.length);
        }
        this.mergedCleanupValves = null;
    }

    public void addCleanupValve(Valve cleanupValve) {
        this.cleanupValves = this.add(this.cleanupValves, cleanupValve);
        this.mergedCleanupValves = null;
    }

    private Valve[] add(Valve[] valves, Valve valve) {
        Valve[] newValves;
        if (valve == null) {
            return valves;
        }
        if (valves == null) {
            newValves = new Valve[]{valve};
        } else {
            newValves = new Valve[valves.length + 1];
            System.arraycopy(valves, 0, newValves, 0, valves.length);
            newValves[newValves.length - 1] = valve;
        }
        return newValves;
    }

    public void initialize() throws ContainerException {
    }

    public void invoke(HstContainerConfig requestContainerConfig, HstRequestContext requestContext, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ContainerException {
        if (this.mergedProcessingValves == null) {
            this.mergedProcessingValves = this.mergeProcessingValves();
            if (log.isInfoEnabled()) {
                log.info("mergedProcessingValves:\n\t{}", (Object)StringUtils.join((Object[])this.mergedProcessingValves, (String)"\n\t"));
            }
        }
        this.invokeValves(requestContainerConfig, requestContext, this.mergedProcessingValves, true);
    }

    public void cleanup(HstContainerConfig requestContainerConfig, HstRequestContext requestContext, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ContainerException {
        if (this.mergedCleanupValves == null) {
            this.mergedCleanupValves = this.mergeCleanupValves();
            if (log.isInfoEnabled()) {
                log.info("mergedCleanupValves:\n\t{}", (Object)StringUtils.join((Object[])this.mergedCleanupValves, (String)"\n\t"));
            }
        }
        this.invokeValves(requestContainerConfig, requestContext, this.mergedCleanupValves, false);
    }

    private void invokeValves(HstContainerConfig requestContainerConfig, HstRequestContext requestContext, Valve[] valves, boolean withDiagnostics) throws ContainerException {
        if (valves != null && valves.length > 0) {
            new Invocation(requestContainerConfig, requestContext, valves, withDiagnostics).invokeNext();
        }
    }

    public void destroy() throws ContainerException {
    }

    protected Valve[] mergeProcessingValves() {
        ObjectOrderer<Object> orderer = new ObjectOrderer<Valve>("initializationValves");
        if (this.initializationValves != null) {
            this.addValvesIntoObjectOrdererWithImposingImplicitOrdering(orderer, this.initializationValves);
        }
        Object[] orderedInitializationValves = orderer.getOrderedObjects().toArray(new Valve[orderer.getOrderedObjects().size()]);
        orderer = new ObjectOrderer("processingValves");
        if (this.processingValves != null) {
            this.addValvesIntoObjectOrdererWithImposingImplicitOrdering(orderer, this.processingValves);
        }
        Object[] orderedProcessingValves = orderer.getOrderedObjects().toArray(new Valve[orderer.getOrderedObjects().size()]);
        return (Valve[])ArrayUtils.addAll((Object[])orderedInitializationValves, (Object[])orderedProcessingValves);
    }

    protected Valve[] mergeCleanupValves() {
        ObjectOrderer<Valve> orderer = new ObjectOrderer<Valve>("cleanupValves");
        if (this.cleanupValves != null) {
            this.addValvesIntoObjectOrdererWithImposingImplicitOrdering(orderer, this.cleanupValves);
        }
        return orderer.getOrderedObjects().toArray(new Valve[orderer.getOrderedObjects().size()]);
    }

    private void addValvesIntoObjectOrdererWithImposingImplicitOrdering(ObjectOrderer<Valve> valveOrderer, Valve[] valves) {
        String prevOrderableValveName = null;
        for (Valve valve : valves) {
            String valveName;
            String afterValves = null;
            String beforeValves = null;
            if (valve instanceof OrderableValve) {
                OrderableValve orderableValve = (OrderableValve)valve;
                valveName = StringUtils.defaultIfEmpty((String)orderableValve.getValveName(), (String)valve.toString());
                if (StringUtils.isNotEmpty((String)orderableValve.getAfterValves())) {
                    afterValves = orderableValve.getAfterValves();
                }
                if (StringUtils.isNotEmpty((String)orderableValve.getBeforeValves())) {
                    beforeValves = orderableValve.getBeforeValves();
                }
            } else {
                valveName = valve.toString();
            }
            if (prevOrderableValveName != null && afterValves == null && beforeValves == null) {
                afterValves = prevOrderableValveName;
            }
            valveOrderer.add(valve, valveName, afterValves, beforeValves);
            prevOrderableValveName = valveName;
        }
    }

    private static final class PageCacheKeyImpl
    implements PageCacheKey {
        private Map<String, Serializable> linkedKeyFragments = new LinkedHashMap<String, Serializable>();
        private int hashCode;
        private boolean sealed;

        private PageCacheKeyImpl() {
        }

        public void setAttribute(String subKey, Serializable keyFragment) {
            if (this.sealed) {
                throw new IllegalStateException("PageCacheKey has been sealed already.");
            }
            this.linkedKeyFragments.put(subKey, keyFragment);
            this.hashCode = 0;
        }

        public void seal() {
            this.sealed = true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PageCacheKeyImpl)) {
                return false;
            }
            PageCacheKeyImpl cacheKey = (PageCacheKeyImpl)o;
            if (this.hashCode() != cacheKey.hashCode()) {
                return false;
            }
            Set<Map.Entry<String, Serializable>> entries = this.linkedKeyFragments.entrySet();
            Set<Map.Entry<String, Serializable>> otherEntries = ((PageCacheKeyImpl)o).linkedKeyFragments.entrySet();
            if (entries.size() != otherEntries.size()) {
                return false;
            }
            Iterator<Map.Entry<String, Serializable>> iterator = entries.iterator();
            Iterator<Map.Entry<String, Serializable>> otherIterator = otherEntries.iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Serializable> otherNext;
                Map.Entry<String, Serializable> next = iterator.next();
                if (next.equals(otherNext = otherIterator.next())) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int result = this.linkedKeyFragments.hashCode();
                this.hashCode = result = 31 * result + (this.sealed ? 1 : 0);
            }
            return this.hashCode;
        }

        public String toString() {
            return "PageCacheKey[" + this.linkedKeyFragments.toString() + ", sealed = " + this.sealed + "]";
        }
    }

    private static final class PageCacheContextImpl
    implements PageCacheContext {
        private final PageCacheKey pageCacheKey = new PageCacheKeyImpl();
        private boolean cacheable = true;
        private List<String> reasonsUncacheable = new ArrayList<String>();

        private PageCacheContextImpl() {
        }

        public boolean isCacheable() {
            return this.cacheable;
        }

        public void markUncacheable() {
            this.cacheable = false;
        }

        public void markUncacheable(String reasonUncacheable) {
            this.cacheable = false;
            this.reasonsUncacheable.add(reasonUncacheable);
        }

        public List<String> getReasonsUncacheable() {
            return this.reasonsUncacheable;
        }

        public PageCacheKey getPageCacheKey() {
            return this.pageCacheKey;
        }
    }

    static final class Invocation
    implements ValveContext {
        private final Valve[] valves;
        private boolean withDiagnostics;
        private final HstContainerConfig requestContainerConfig;
        private HstComponentWindow rootComponentWindow;
        private HstComponentWindow rootComponentRenderingWindow;
        private final HstRequestContext requestContext;
        private final PageCacheContext pageCacheContext = new PageCacheContextImpl();
        private int at = 0;
        private Task pipelineTask;

        public Invocation(HstContainerConfig requestContainerConfig, HstRequestContext requestContext, Valve[] valves) {
            this(requestContainerConfig, requestContext, valves, false);
        }

        public Invocation(HstContainerConfig requestContainerConfig, HstRequestContext requestContext, Valve[] valves, boolean withDiagnostics) {
            this.requestContainerConfig = requestContainerConfig;
            this.requestContext = requestContext;
            this.valves = valves;
            this.withDiagnostics = withDiagnostics;
        }

        public void invokeNext() throws ContainerException {
            if (this.at < this.valves.length) {
                Valve next = this.valves[this.at];
                ++this.at;
                try {
                    if (HDC.isStarted() && this.withDiagnostics) {
                        if (this.pipelineTask != null) {
                            this.pipelineTask.stop();
                        }
                        this.pipelineTask = HDC.getCurrentTask().startSubtask("Invoke Valve " + next.getClass().getName());
                    }
                    next.invoke((ValveContext)this);
                }
                finally {
                    if (this.pipelineTask != null) {
                        this.pipelineTask.stop();
                        this.pipelineTask = null;
                    }
                }
            }
        }

        public HstContainerConfig getRequestContainerConfig() {
            return this.requestContainerConfig;
        }

        public HstRequestContext getRequestContext() {
            return this.requestContext;
        }

        public HttpServletRequest getServletRequest() {
            return this.requestContext.getServletRequest();
        }

        public HttpServletResponse getServletResponse() {
            return this.requestContext.getServletResponse();
        }

        @Deprecated
        public void setHttpServletResponse(HttpServletResponse servletResponse) {
            ((HstMutableRequestContext)this.requestContext).setServletResponse(servletResponse);
        }

        public void setRootComponentWindow(HstComponentWindow rootComponentWindow) {
            this.rootComponentWindow = rootComponentWindow;
        }

        public HstComponentWindow getRootComponentWindow() {
            return this.rootComponentWindow;
        }

        public void setRootComponentRenderingWindow(HstComponentWindow rootComponentRenderingWindow) {
            this.rootComponentRenderingWindow = rootComponentRenderingWindow;
        }

        public HstComponentWindow getRootComponentRenderingWindow() {
            return this.rootComponentRenderingWindow == null ? this.rootComponentWindow : this.rootComponentRenderingWindow;
        }

        public PageCacheContext getPageCacheContext() {
            return this.pageCacheContext;
        }
    }
}

