/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.container;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hippoecm.hst.core.container.ContainerException;
import org.hippoecm.hst.core.container.HstContainerConfig;
import org.hippoecm.hst.core.container.HstRequestProcessor;
import org.hippoecm.hst.core.container.Pipeline;
import org.hippoecm.hst.core.container.Pipelines;
import org.hippoecm.hst.core.request.HstRequestContext;
import org.hippoecm.hst.diagnosis.HDC;
import org.hippoecm.hst.diagnosis.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HstRequestProcessorImpl
implements HstRequestProcessor {
    protected static final Logger log = LoggerFactory.getLogger(HstRequestProcessorImpl.class);
    private static ThreadLocal<HstContainerConfig> tlCurrentRequestContainerConfig = new ThreadLocal();
    protected Pipelines pipelines;

    public HstRequestProcessorImpl(Pipelines pipelines) {
        this.pipelines = pipelines;
    }

    public void processRequest(HstContainerConfig requestContainerConfig, HstRequestContext requestContext, HttpServletRequest servletRequest, HttpServletResponse servletResponse, String namedPipeline) throws ContainerException {
        Pipeline pipeline;
        ClassLoader containerClassLoader = requestContainerConfig.getContextClassLoader();
        ClassLoader processorClassLoader = this.getClass().getClassLoader();
        Pipeline pipeline2 = pipeline = namedPipeline != null ? this.pipelines.getPipeline(namedPipeline) : this.pipelines.getDefaultPipeline();
        if (pipeline == null) {
            if (namedPipeline != null) {
                throw new ContainerException("Unknown namedPipeline " + namedPipeline + ". Request processing cannot continue.");
            }
            throw new ContainerException("No default pipeline defined. Request processing cannot continue.");
        }
        Task pipelineTask = null;
        try {
            if (HDC.isStarted()) {
                pipelineTask = HDC.getCurrentTask().startSubtask("Pipeline processing");
                pipelineTask.setAttribute("pipeline", (Object)(namedPipeline == null ? "DefaultSitePipeline" : namedPipeline));
            }
            tlCurrentRequestContainerConfig.set(requestContainerConfig);
            if (processorClassLoader != containerClassLoader) {
                Thread.currentThread().setContextClassLoader(processorClassLoader);
            }
            pipeline.invoke(requestContainerConfig, requestContext, servletRequest, servletResponse);
        }
        catch (ContainerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ContainerException((Throwable)e);
        }
        finally {
            if (pipelineTask != null) {
                pipelineTask.stop();
            }
            pipeline.cleanup(requestContainerConfig, requestContext, servletRequest, servletResponse);
            tlCurrentRequestContainerConfig.remove();
            if (processorClassLoader != containerClassLoader) {
                Thread.currentThread().setContextClassLoader(containerClassLoader);
            }
        }
    }

    public HstContainerConfig getCurrentHstContainerConfig() {
        return tlCurrentRequestContainerConfig.get();
    }
}

