/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.container;

import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.configuration.hosting.Mount;
import org.hippoecm.hst.core.component.HstURL;
import org.hippoecm.hst.core.container.ContainerException;
import org.hippoecm.hst.core.container.HstContainerURL;
import org.hippoecm.hst.core.container.HstContainerURLImpl;
import org.hippoecm.hst.core.container.HstContainerURLProvider;
import org.hippoecm.hst.core.container.HstNavigationalStateCodec;
import org.hippoecm.hst.core.request.HstRequestContext;
import org.hippoecm.hst.core.request.ResolvedMount;
import org.hippoecm.hst.core.util.PathEncoder;
import org.hippoecm.hst.util.HstRequestUtils;
import org.hippoecm.hst.util.PathUtils;
import org.hippoecm.hst.util.QueryStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HstContainerURLProviderImpl
implements HstContainerURLProvider {
    protected static final Logger log = LoggerFactory.getLogger(HstContainerURLProvider.class);
    protected static final String REQUEST_INFO_SEPARATOR = "|";
    protected static final String DEFAULT_HST_URL_NAMESPACE_PREFIX = "_hn:";
    protected String urlNamespacePrefix = "_hn:";
    protected String urlNamespacedTypeParamName = this.urlNamespacePrefix + "type";
    protected String urlNamespacedReferenceParamName = this.urlNamespacePrefix + "ref";
    protected String urlNamespacedResourceIdParamName = this.urlNamespacePrefix + "rid";
    protected String parameterNameComponentSeparator = ":";
    protected HstNavigationalStateCodec navigationalStateCodec;

    public void setUrlNamespacePrefix(String urlNamespacePrefix) {
        this.urlNamespacePrefix = urlNamespacePrefix;
        this.urlNamespacedTypeParamName = urlNamespacePrefix + "type";
        this.urlNamespacedReferenceParamName = urlNamespacePrefix + "ref";
        this.urlNamespacedResourceIdParamName = urlNamespacePrefix + "rid";
    }

    public String getUrlNamespacePrefix() {
        return this.urlNamespacePrefix;
    }

    public void setParameterNameComponentSeparator(String parameterNameComponentSeparator) {
        this.parameterNameComponentSeparator = parameterNameComponentSeparator;
    }

    public String getParameterNameComponentSeparator() {
        return this.parameterNameComponentSeparator;
    }

    public void setNavigationalStateCodec(HstNavigationalStateCodec navigationalStateCodec) {
        this.navigationalStateCodec = navigationalStateCodec;
    }

    public HstNavigationalStateCodec getNavigationalStateCodec() {
        return this.navigationalStateCodec;
    }

    public HstContainerURL parseURL(HttpServletRequest request, ResolvedMount mount, String requestPath, Map<String, String[]> queryParams) {
        return this.parseURL(mount, request.getContextPath(), requestPath, queryParams, HstRequestUtils.getCharacterEncoding((HttpServletRequest)request), HstRequestUtils.getURIEncoding((HttpServletRequest)request));
    }

    public HstContainerURL parseURL(ResolvedMount mount, String contextPath, String requestPath, Map<String, String[]> queryParams, String requestCharacterEncoding, String requestURIEncoding) {
        HstContainerURLImpl url = new HstContainerURLImpl();
        url.setContextPath(contextPath);
        url.setHostName(mount.getMount().getVirtualHost().getHostName());
        url.setPortNumber(mount.getPortNumber());
        url.setResolvedMountPath(mount.getResolvedMountPath());
        url.setRequestPath(requestPath);
        url.setPathInfo(requestPath.substring(mount.getResolvedMountPath().length()));
        url.setCharacterEncoding(requestCharacterEncoding);
        url.setURIEncoding(requestURIEncoding);
        url.setPathInfo(requestPath.substring(mount.getResolvedMountPath().length()));
        url.setParameters(queryParams);
        this.parseRequestInfo(url);
        return url;
    }

    public HstContainerURL parseURL(HstRequestContext requestContext, ResolvedMount mount, String requestPath, Map<String, String[]> queryParams) {
        HstContainerURLImpl url = new HstContainerURLImpl();
        HstContainerURL baseURL = requestContext.getBaseURL();
        url.setContextPath(baseURL.getContextPath());
        url.setHostName(baseURL.getHostName());
        url.setPortNumber(baseURL.getPortNumber());
        url.setResolvedMountPath(mount.getResolvedMountPath());
        url.setRequestPath(requestPath);
        url.setPathInfo(requestPath.substring(mount.getResolvedMountPath().length()));
        url.setCharacterEncoding(baseURL.getCharacterEncoding());
        url.setURIEncoding(baseURL.getURIEncoding());
        url.setParameters(queryParams);
        this.parseRequestInfo(url);
        return url;
    }

    public HstContainerURL parseURL(HttpServletRequest request, HttpServletResponse response, ResolvedMount resolvedMount) {
        HstContainerURLImpl url = new HstContainerURLImpl();
        url.setContextPath(request.getContextPath());
        url.setHostName(HstRequestUtils.getFarthestRequestHost((HttpServletRequest)request));
        url.setPortNumber(HstRequestUtils.getRequestServerPort((HttpServletRequest)request));
        url.setRequestPath(HstRequestUtils.getRequestPath((HttpServletRequest)request));
        url.setCharacterEncoding(HstRequestUtils.getCharacterEncoding((HttpServletRequest)request));
        String uriEncoding = HstRequestUtils.getURIEncoding((HttpServletRequest)request);
        url.setURIEncoding(uriEncoding);
        try {
            Map paramMap = HstRequestUtils.parseQueryString((HttpServletRequest)request);
            url.setParameters(paramMap);
        }
        catch (UnsupportedEncodingException e) {
            if (log.isDebugEnabled()) {
                log.warn("Unsupported encoding in request, using empty query parameters:", (Throwable)e);
            }
            log.warn("Unsupported encoding in request, using empty query parameters: " + e.toString());
        }
        url.setResolvedMountPath(resolvedMount.getResolvedMountPath());
        url.setPathInfo(request.getPathInfo());
        this.parseRequestInfo(url);
        return url;
    }

    public HstContainerURL createURL(HstContainerURL baseContainerURL, String pathInfo) {
        HstContainerURLImpl url = new HstContainerURLImpl();
        url.setContextPath(baseContainerURL.getContextPath());
        url.setHostName(baseContainerURL.getHostName());
        url.setPortNumber(baseContainerURL.getPortNumber());
        pathInfo = PathUtils.normalizePath((String)pathInfo);
        if (pathInfo != null) {
            pathInfo = '/' + pathInfo;
        }
        url.setRequestPath(baseContainerURL.getResolvedMountPath() + pathInfo);
        url.setCharacterEncoding(baseContainerURL.getCharacterEncoding());
        url.setURIEncoding(baseContainerURL.getURIEncoding());
        url.setResolvedMountPath(baseContainerURL.getResolvedMountPath());
        url.setPathInfo(pathInfo);
        return url;
    }

    public HstContainerURL createURL(Mount mount, HstContainerURL baseContainerURL, String pathInfo) {
        HstContainerURLImpl url = new HstContainerURLImpl();
        if (mount.isContextPathInUrl()) {
            url.setContextPath(baseContainerURL.getContextPath());
        } else {
            url.setContextPath("");
        }
        url.setCharacterEncoding(baseContainerURL.getCharacterEncoding());
        url.setURIEncoding(baseContainerURL.getURIEncoding());
        if (mount.getPort() == 0) {
            url.setPortNumber(baseContainerURL.getPortNumber());
        } else {
            url.setPortNumber(mount.getPort());
        }
        boolean includeTrailingSlash = false;
        if (pathInfo != null && pathInfo.endsWith(mount.getVirtualHost().getVirtualHosts().getHstManager().getPathSuffixDelimiter())) {
            includeTrailingSlash = true;
        }
        boolean includeLeadingSlash = true;
        if (pathInfo != null && pathInfo.startsWith(mount.getVirtualHost().getVirtualHosts().getHstManager().getPathSuffixDelimiter())) {
            includeLeadingSlash = false;
        }
        if ((pathInfo = PathUtils.normalizePath((String)pathInfo)) != null) {
            if (includeLeadingSlash) {
                pathInfo = '/' + pathInfo;
            }
            if (includeTrailingSlash) {
                pathInfo = pathInfo + '/';
            }
        }
        url.setHostName(mount.getVirtualHost().getHostName());
        url.setRequestPath(mount.getMountPath() + pathInfo);
        url.setResolvedMountPath(mount.getMountPath());
        url.setPathInfo(pathInfo);
        return url;
    }

    public HstContainerURL createURL(HstContainerURL baseContainerURL, HstURL hstUrl) {
        HstContainerURLImpl containerURL;
        try {
            containerURL = (HstContainerURLImpl)((HstContainerURLImpl)baseContainerURL).clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Clone not supported on the container url. " + e);
        }
        containerURL.setActionWindowReferenceNamespace(null);
        containerURL.setResourceWindowReferenceNamespace(null);
        containerURL.setComponentRenderingWindowReferenceNamespace(null);
        String type = hstUrl.getType();
        if ("action".equals(type)) {
            containerURL.setActionWindowReferenceNamespace(hstUrl.getReferenceNamespace());
            this.mergeParameters(containerURL, hstUrl.getReferenceNamespace(), hstUrl.getParameterMap());
        } else if ("resource".equals(type)) {
            containerURL.setResourceWindowReferenceNamespace(hstUrl.getReferenceNamespace());
            containerURL.setResourceId(hstUrl.getResourceID());
            this.mergeParameters(containerURL, hstUrl.getReferenceNamespace(), hstUrl.getParameterMap());
        } else if ("component-rendering".equals(type)) {
            containerURL.setComponentRenderingWindowReferenceNamespace(hstUrl.getReferenceNamespace());
            this.mergeParameters(containerURL, hstUrl.getReferenceNamespace(), hstUrl.getParameterMap());
        } else {
            this.mergeParameters(containerURL, hstUrl.getReferenceNamespace(), hstUrl.getParameterMap());
        }
        return containerURL;
    }

    public void mergeParameters(HstContainerURL containerURL, String referenceNamespace, Map<String, String[]> parameterMap) {
        String paramName;
        Map containerParamsMap;
        String prefix;
        String string = prefix = StringUtils.isEmpty((String)referenceNamespace) ? "" : referenceNamespace + this.parameterNameComponentSeparator;
        if (!"".equals(prefix) && (containerParamsMap = containerURL.getParameterMap()) != null && !containerParamsMap.isEmpty()) {
            int prefixLen = prefix.length();
            paramName = null;
            Iterator iter = containerParamsMap.entrySet().iterator();
            while (iter.hasNext()) {
                paramName = (String)iter.next().getKey();
                if (!paramName.startsWith(prefix) || paramName.length() <= prefixLen) continue;
                iter.remove();
            }
        }
        for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
            paramName = prefix + entry.getKey();
            String[] paramValues = entry.getValue();
            if (paramValues == null || paramValues.length == 0) {
                containerURL.setParameter(paramName, (String)null);
                continue;
            }
            containerURL.setParameter(paramName, paramValues);
        }
    }

    @Deprecated
    public String toContextRelativeURLString(HstContainerURL containerURL, HstRequestContext requestContext) throws UnsupportedEncodingException, ContainerException {
        StringBuilder url = new StringBuilder(100);
        String mountPrefix = containerURL.getResolvedMountPath();
        if (mountPrefix != null) {
            url.append(mountPrefix);
        }
        String pathInfo = this.buildHstURLPath(containerURL, requestContext);
        url.append(pathInfo);
        return url.toString();
    }

    protected String buildHstURLPath(HstContainerURL containerURL, HstRequestContext requestContext) throws UnsupportedEncodingException {
        String encoding = containerURL.getURIEncoding();
        StringBuilder url = new StringBuilder(100);
        String pathSuffixDelimiter = requestContext.getResolvedMount().getMount().getVirtualHost().getVirtualHosts().getHstManager().getPathSuffixDelimiter();
        String containerUrlPathInfo = containerURL.getPathInfo();
        if ("/".equals(containerUrlPathInfo) || StringUtils.isEmpty((String)containerUrlPathInfo)) {
            if (StringUtils.isEmpty((String)containerURL.getResolvedMountPath())) {
                url.append('/');
            }
        } else {
            String encoded = PathEncoder.encode(containerUrlPathInfo, encoding);
            if (!encoded.startsWith("/")) {
                url.append("/");
            }
            url.append(encoded);
        }
        QueryStringBuilder queryStringBuilder = new QueryStringBuilder(encoding);
        if (containerURL.getActionWindowReferenceNamespace() != null) {
            queryStringBuilder.append(this.urlNamespacedTypeParamName, "action");
            queryStringBuilder.append(this.urlNamespacedReferenceParamName, containerURL.getActionWindowReferenceNamespace());
        } else if (containerURL.getResourceWindowReferenceNamespace() != null) {
            queryStringBuilder.append(this.urlNamespacedTypeParamName, "resource");
            queryStringBuilder.append(this.urlNamespacedReferenceParamName, containerURL.getResourceWindowReferenceNamespace());
            if (containerURL.getResourceId() != null) {
                queryStringBuilder.append(this.urlNamespacedResourceIdParamName, containerURL.getResourceId());
            }
        } else if (containerURL.getComponentRenderingWindowReferenceNamespace() != null) {
            queryStringBuilder.append(this.urlNamespacedTypeParamName, "component-rendering");
            queryStringBuilder.append(this.urlNamespacedReferenceParamName, containerURL.getComponentRenderingWindowReferenceNamespace());
        }
        Map parameters = containerURL.getParameterMap();
        if (parameters != null) {
            for (Map.Entry entry : parameters.entrySet()) {
                String name = (String)entry.getKey();
                for (String value : (String[])entry.getValue()) {
                    queryStringBuilder.append(name, value);
                }
            }
        }
        url.append(queryStringBuilder.toString());
        return url.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseRequestInfo(HstContainerURL url) {
        try {
            String requestType = url.getParameter(this.urlNamespacedTypeParamName);
            if ("action".equals(requestType)) {
                String actionWindowReferenceNamespace = url.getParameter(this.urlNamespacedReferenceParamName);
                url.setActionWindowReferenceNamespace(actionWindowReferenceNamespace);
                log.debug("action window chosen for {}: {}", (Object)url.getPathInfo(), (Object)actionWindowReferenceNamespace);
            } else if ("resource".equals(requestType)) {
                String resourceWindowReferenceNamespace = url.getParameter(this.urlNamespacedReferenceParamName);
                String resourceId = url.getParameter(this.urlNamespacedResourceIdParamName);
                url.setResourceId(resourceId);
                url.setResourceWindowReferenceNamespace(resourceWindowReferenceNamespace);
                log.debug("resource window chosen for {}: {}", (Object)url.getPathInfo(), (Object)(resourceWindowReferenceNamespace + ", " + resourceId));
            } else if ("component-rendering".equals(requestType)) {
                String componentRenderingReferenceNamespace = url.getParameter(this.urlNamespacedReferenceParamName);
                url.setComponentRenderingWindowReferenceNamespace(componentRenderingReferenceNamespace);
                log.debug("partial render window chosen for {}: {}", (Object)url.getPathInfo(), (Object)componentRenderingReferenceNamespace);
            }
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.warn("Invalid container URL path: {}", (Object)url.getRequestPath(), (Object)e);
            } else if (log.isWarnEnabled()) {
                log.warn("Invalid container URL path: {}", (Object)url.getRequestPath());
            }
        }
        finally {
            url.setParameter(this.urlNamespacedTypeParamName, (String)null);
            url.setParameter(this.urlNamespacedReferenceParamName, (String)null);
            url.setParameter(this.urlNamespacedResourceIdParamName, (String)null);
        }
    }

    public String toURLString(HstContainerURL containerURL, HstRequestContext requestContext) throws UnsupportedEncodingException, ContainerException {
        return this.toURLString(containerURL, requestContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toURLString(HstContainerURL containerURL, HstRequestContext requestContext, String contextPath) throws UnsupportedEncodingException, ContainerException {
        StringBuilder urlBuilder = new StringBuilder(100);
        if (contextPath != null) {
            urlBuilder.append(contextPath);
        } else if (requestContext.isCmsRequest() || requestContext.getResolvedMount().getMount().isContextPathInUrl()) {
            urlBuilder.append(containerURL.getContextPath());
        }
        if (!StringUtils.isEmpty((String)requestContext.getResolvedMount().getMatchingIgnoredPrefix())) {
            urlBuilder.append('/').append(requestContext.getResolvedMount().getMatchingIgnoredPrefix());
        }
        String resourceWindowReferenceNamespace = containerURL.getResourceWindowReferenceNamespace();
        String path = null;
        if ("org.hippoecm.hst.container.reference.namespace".equals(resourceWindowReferenceNamespace)) {
            String oldPathInfo = containerURL.getPathInfo();
            String resourcePath = containerURL.getResourceId();
            Map oldParamMap = containerURL.getParameterMap();
            try {
                containerURL.setResourceWindowReferenceNamespace(null);
                ((HstContainerURLImpl)containerURL).setPathInfo(resourcePath);
                containerURL.setParameters(null);
                path = this.buildHstURLPath(containerURL, requestContext);
            }
            finally {
                containerURL.setResourceWindowReferenceNamespace(resourceWindowReferenceNamespace);
                ((HstContainerURLImpl)containerURL).setPathInfo(oldPathInfo);
                containerURL.setParameters(oldParamMap);
            }
        } else {
            urlBuilder.append(containerURL.getResolvedMountPath());
            path = this.buildHstURLPath(containerURL, requestContext);
        }
        urlBuilder.append(path);
        return urlBuilder.toString();
    }
}

