/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.container;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.IteratorUtils;
import org.hippoecm.hst.configuration.components.HstComponentConfiguration;
import org.hippoecm.hst.configuration.components.HstComponentInfo;
import org.hippoecm.hst.core.component.HstComponent;
import org.hippoecm.hst.core.component.HstComponentException;
import org.hippoecm.hst.core.component.HstComponentMetadata;
import org.hippoecm.hst.core.component.HstResponseState;
import org.hippoecm.hst.core.component.HstServletResponseState;
import org.hippoecm.hst.core.container.HstComponentWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HstComponentWindowImpl
implements HstComponentWindow {
    protected static final Logger log = LoggerFactory.getLogger(HstComponentWindowImpl.class);
    protected HstComponentConfiguration hstComponentConfiguration;
    protected String referenceNamespace;
    protected HstComponent component;
    protected HstComponentMetadata componentMetadata;
    protected String componentName;
    protected String renderPath;
    protected String namedRenderer;
    protected String serveResourcePath;
    protected String namedResourceServer;
    protected HstComponentWindow parentWindow;
    protected List<HstComponentException> componentExceptions;
    protected LinkedHashMap<String, HstComponentWindow> childWindowMap;
    protected LinkedHashMap<String, HstComponentWindow> childWindowMapByReferenceName;
    protected Map<String, Object> attributes;
    protected boolean visible = true;
    protected HstResponseState responseState;

    public HstComponentWindowImpl(HstComponentConfiguration hstComponentConfiguration, String componentName, HstComponent component, HstComponentMetadata componentMetadata, HstComponentWindow parentWindow, String referenceNamespace) {
        this.hstComponentConfiguration = hstComponentConfiguration;
        this.componentName = componentName;
        this.component = component;
        this.componentMetadata = componentMetadata;
        this.parentWindow = parentWindow;
        this.referenceNamespace = referenceNamespace;
    }

    public HstComponent getComponent() {
        return this.component;
    }

    public HstComponentMetadata getComponentMetadata() {
        return this.componentMetadata;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public boolean hasComponentExceptions() {
        return this.componentExceptions != null && !this.componentExceptions.isEmpty();
    }

    public List<HstComponentException> getComponentExceptions() {
        return this.componentExceptions;
    }

    public void addComponentExcpetion(HstComponentException e) {
        if (this.componentExceptions == null) {
            this.componentExceptions = new LinkedList<HstComponentException>();
        }
        this.componentExceptions.add(e);
    }

    public void clearComponentExceptions() {
        if (this.componentExceptions != null) {
            this.componentExceptions.clear();
        }
    }

    public String getRenderPath() {
        if (this.renderPath == null) {
            this.renderPath = this.hstComponentConfiguration.getRenderPath();
        }
        return this.renderPath;
    }

    public String getNamedRenderer() {
        if (this.namedRenderer == null) {
            this.namedRenderer = this.hstComponentConfiguration.getNamedRenderer();
        }
        return this.namedRenderer;
    }

    public String getServeResourcePath() {
        if (this.serveResourcePath == null) {
            this.serveResourcePath = this.hstComponentConfiguration.getServeResourcePath();
        }
        return this.serveResourcePath;
    }

    public String getNamedResourceServer() {
        if (this.namedResourceServer == null) {
            this.namedResourceServer = this.hstComponentConfiguration.getNamedResourceServer();
        }
        return this.namedResourceServer;
    }

    public String getParameter(String paramName) {
        return this.hstComponentConfiguration.getParameter(paramName);
    }

    public String getLocalParameter(String paramName) {
        return this.hstComponentConfiguration.getLocalParameter(paramName);
    }

    public HstComponentWindow getParentWindow() {
        return this.parentWindow;
    }

    public Map<String, HstComponentWindow> getChildWindowMap() {
        return this.childWindowMap;
    }

    public List<String> getChildWindowNames() {
        if (this.childWindowMap == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<String>(this.childWindowMap.keySet()));
    }

    public HstComponentWindow getChildWindow(String name) {
        HstComponentWindow childWindow = null;
        if (this.childWindowMap != null) {
            childWindow = this.childWindowMap.get(name);
        }
        return childWindow;
    }

    public HstComponentWindow getChildWindowByReferenceName(String referenceName) {
        HstComponentWindow childWindow = null;
        if (this.childWindowMapByReferenceName != null) {
            childWindow = this.childWindowMapByReferenceName.get(referenceName);
        }
        return childWindow;
    }

    public String getName() {
        return this.hstComponentConfiguration.getName();
    }

    public String getReferenceName() {
        return this.hstComponentConfiguration.getReferenceName();
    }

    public String getPageErrorHandlerClassName() {
        return this.hstComponentConfiguration.getPageErrorHandlerClassName();
    }

    public String getReferenceNamespace() {
        return this.referenceNamespace;
    }

    public void bindResponseState(HttpServletRequest request, HttpServletResponse parentResponse) {
        if (this.responseState != null) {
            log.warn("Window '{}' already has a responseState. Return", (Object)this.getName());
            return;
        }
        this.responseState = new HstServletResponseState(request, parentResponse, (HstComponentWindow)this);
    }

    public HstResponseState getResponseState() {
        return this.responseState;
    }

    public void addChildWindow(HstComponentWindow child) {
        HstComponentWindow old;
        if (this.childWindowMap == null) {
            this.childWindowMap = new LinkedHashMap();
        }
        if ((old = this.childWindowMap.put(child.getName(), child)) != null) {
            log.error("Ambiguous components configuration because component sibblings found with same name: '{}'. The first one is replaced. This should not be possible. You can report the HST2 team so they can fix this.", (Object)child.getName());
        }
        if (this.childWindowMapByReferenceName == null) {
            this.childWindowMapByReferenceName = new LinkedHashMap();
        }
        this.childWindowMapByReferenceName.put(child.getReferenceName(), child);
    }

    public HstComponentInfo getComponentInfo() {
        return this.hstComponentConfiguration;
    }

    public Object getAttribute(String name) {
        if (this.attributes != null) {
            return this.attributes.get(name);
        }
        return null;
    }

    public void setAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(name, value);
    }

    public Object removeAttribute(String name) {
        if (this.attributes != null) {
            return this.attributes.remove(name);
        }
        return null;
    }

    public Enumeration<String> getAttributeNames() {
        if (this.attributes != null) {
            return IteratorUtils.asEnumeration(this.attributes.keySet().iterator());
        }
        return IteratorUtils.asEnumeration(Collections.emptySet().iterator());
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void removeChildWindow(HstComponentWindow window) {
        if (window == null) {
            throw new IllegalArgumentException("'window' argument not allowed to be null");
        }
        if (this.childWindowMap == null) {
            log.debug("Cannot remove '{}' since no child windows present for '{}'", (Object)window.getName(), (Object)this.getName());
            return;
        }
        HstComponentWindow removed = (HstComponentWindow)this.childWindowMap.remove(window.getName());
        if (removed == null) {
            log.debug("could not remove '{}' from '{}' because not a child.", (Object)window.getName(), (Object)this.getName());
        } else {
            log.debug("Removed '{}' from '{}'.", (Object)window.getName(), (Object)this.getName());
            if (this.childWindowMapByReferenceName != null) {
                this.childWindowMapByReferenceName.remove(window.getReferenceName());
            }
        }
    }
}

