/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.container;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.configuration.components.HstComponentConfiguration;
import org.hippoecm.hst.configuration.hosting.Mount;
import org.hippoecm.hst.core.component.HstComponent;
import org.hippoecm.hst.core.component.HstComponentException;
import org.hippoecm.hst.core.component.HstComponentFatalException;
import org.hippoecm.hst.core.component.HstComponentMetadata;
import org.hippoecm.hst.core.container.HstComponentFactory;
import org.hippoecm.hst.core.container.HstComponentWindow;
import org.hippoecm.hst.core.container.HstComponentWindowFactory;
import org.hippoecm.hst.core.container.HstComponentWindowFilter;
import org.hippoecm.hst.core.container.HstComponentWindowImpl;
import org.hippoecm.hst.core.container.HstContainerConfig;
import org.hippoecm.hst.core.request.HstRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HstComponentWindowFactoryImpl
implements HstComponentWindowFactory {
    private static final Logger log = LoggerFactory.getLogger(HstComponentWindowFactoryImpl.class);
    protected String referenceNameSeparator = "_";

    public void setReferenceNameSeparator(String referenceNameSeparator) {
        this.referenceNameSeparator = referenceNameSeparator;
    }

    public String getReferenceNameSeparator() {
        return this.referenceNameSeparator;
    }

    public HstComponentWindow create(HstContainerConfig requestContainerConfig, HstRequestContext requestContext, HstComponentConfiguration compConfig, HstComponentFactory compFactory) throws HstComponentException {
        return this.create(requestContainerConfig, requestContext, compConfig, compFactory, null);
    }

    public HstComponentWindow create(HstContainerConfig requestContainerConfig, HstRequestContext requestContext, HstComponentConfiguration compConfig, HstComponentFactory compFactory, HstComponentWindow parentWindow) throws HstComponentException {
        Map childCompConfigMap;
        String referenceName = compConfig.getReferenceName();
        StringBuilder referenceNamespaceBuilder = new StringBuilder();
        String parentReferenceNamespace = null;
        if (parentWindow != null) {
            parentReferenceNamespace = parentWindow.getReferenceNamespace();
        }
        if (parentReferenceNamespace == null || "".equals(parentReferenceNamespace)) {
            referenceNamespaceBuilder.append(referenceName);
        } else {
            referenceNamespaceBuilder.append(parentReferenceNamespace).append(this.referenceNameSeparator).append(referenceName);
        }
        String referenceNamespace = referenceNamespaceBuilder.toString();
        HstComponent component = null;
        HstComponentMetadata componentMetadata = null;
        HstComponentException componentFactoryException = null;
        try {
            Mount mount = requestContext.getResolvedMount().getMount();
            component = compFactory.getComponentInstance(requestContainerConfig, compConfig, mount);
            componentMetadata = compFactory.getComponentMetadata(requestContainerConfig, compConfig, mount);
        }
        catch (HstComponentFatalException e) {
            throw e;
        }
        catch (HstComponentException e) {
            componentFactoryException = e;
        }
        catch (Exception e) {
            componentFactoryException = new HstComponentException((Throwable)e);
        }
        String componentName = compConfig.getComponentClassName();
        if (StringUtils.isBlank((String)componentName)) {
            componentName = compFactory.getDefaultHstComponentClassName();
        }
        HstComponentWindowImpl window = new HstComponentWindowImpl(compConfig, componentName, component, componentMetadata, parentWindow, referenceNamespace);
        if (componentFactoryException != null) {
            window.addComponentExcpetion(componentFactoryException);
        }
        if ((childCompConfigMap = compConfig.getChildren()) != null && !childCompConfigMap.isEmpty()) {
            String tag;
            HstComponentConfiguration childCompConfig;
            Set filter = requestContext.getComponentFilterTags();
            boolean matchTag = false;
            if (!filter.isEmpty()) {
                for (Map.Entry entry : childCompConfigMap.entrySet()) {
                    childCompConfig = (HstComponentConfiguration)entry.getValue();
                    tag = childCompConfig.getComponentFilterTag();
                    if (tag == null || !filter.contains(tag)) continue;
                    matchTag = true;
                    break;
                }
            }
            for (Map.Entry entry : childCompConfigMap.entrySet()) {
                HstComponentWindowFilter creationFilter;
                childCompConfig = (HstComponentConfiguration)entry.getValue();
                if (childCompConfig.isMarkedDeleted()) {
                    log.debug("Skipping child component {} because it is marked to be deleted.", (Object)childCompConfig);
                    continue;
                }
                tag = childCompConfig.getComponentFilterTag();
                if (matchTag ? tag == null || !filter.contains(tag) : tag != null) continue;
                HstComponentWindow childCompWindow = this.create(requestContainerConfig, requestContext, childCompConfig, compFactory, window);
                Iterator iterator = requestContext.getComponentWindowFilters().iterator();
                while (iterator.hasNext() && (childCompWindow = (creationFilter = (HstComponentWindowFilter)iterator.next()).doFilter(requestContext, childCompConfig, childCompWindow)) != null) {
                }
                if (childCompWindow == null) continue;
                window.addChildWindow(childCompWindow);
                if (window.isVisible()) continue;
                childCompWindow.setVisible(false);
            }
        }
        return window;
    }
}

