/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.container;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hippoecm.hst.core.component.HstComponent;
import org.hippoecm.hst.core.component.HstComponentMetadata;
import org.hippoecm.hst.core.component.HstComponentMetadataReader;
import org.hippoecm.hst.core.container.HstComponentRegistry;
import org.hippoecm.hst.core.container.HstContainerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HstComponentRegistryImpl
implements HstComponentRegistry {
    static Logger log = LoggerFactory.getLogger(HstComponentRegistryImpl.class);
    protected Map<HstContainerConfig, Map<String, HstComponentHolder>> servletConfigComponentsMap = new ConcurrentHashMap<HstContainerConfig, Map<String, HstComponentHolder>>(128);

    public HstComponent getComponent(HstContainerConfig requestContainerConfig, String componentId) {
        HstComponentHolder holder = this.getServletConfigComponentsMap(requestContainerConfig, true).get(componentId);
        if (holder != null) {
            return holder.getComponent();
        }
        return null;
    }

    public HstComponentMetadata getComponentMetadata(HstContainerConfig requestContainerConfig, String componentId) {
        HstComponentHolder holder = this.getServletConfigComponentsMap(requestContainerConfig, true).get(componentId);
        if (holder != null) {
            return holder.getComponentMetadata();
        }
        return null;
    }

    public void registerComponent(HstContainerConfig requestContainerConfig, String componentId, HstComponent component) {
        HstComponentMetadata componentMetadata = HstComponentMetadataReader.getHstComponentMetadata(component.getClass());
        HstComponentHolder componentHolder = new HstComponentHolder(component, componentMetadata);
        this.getServletConfigComponentsMap(requestContainerConfig, true).put(componentId, componentHolder);
    }

    public void unregisterComponent(HstContainerConfig requestContainerConfig, String componentId) {
        block4: {
            HstComponentHolder holder = this.getServletConfigComponentsMap(requestContainerConfig, true).remove(componentId);
            if (holder != null) {
                try {
                    holder.getComponent().destroy();
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.warn("Exception occurred during destroying component: {}", (Object)e.toString(), (Object)e);
                    }
                    if (!log.isWarnEnabled()) break block4;
                    log.warn("Exception occurred during destroying component: {}", (Object)e.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAllComponents() {
        if (this.servletConfigComponentsMap.isEmpty()) {
            return;
        }
        Map copiedMap = Collections.synchronizedMap(new HashMap());
        Iterator iterator = this.servletConfigComponentsMap;
        synchronized (iterator) {
            for (HstContainerConfig requestContainerConfig : this.servletConfigComponentsMap.keySet()) {
                copiedMap.put(requestContainerConfig, new HashMap());
            }
        }
        for (HstContainerConfig requestContainerConfig : copiedMap.keySet()) {
            Map<String, HstComponentHolder> compMap = this.getServletConfigComponentsMap(requestContainerConfig, false);
            if (compMap == null) continue;
            HashMap<String, HstComponentHolder> copiedCompMap = new HashMap<String, HstComponentHolder>();
            Map<String, HstComponentHolder> map = compMap;
            synchronized (map) {
                for (Map.Entry<String, HstComponentHolder> compEntry : compMap.entrySet()) {
                    copiedCompMap.put(compEntry.getKey(), compEntry.getValue());
                }
            }
            copiedMap.put(requestContainerConfig, copiedCompMap);
        }
        for (Map.Entry entry : copiedMap.entrySet()) {
            for (Map.Entry compEntry : ((Map)entry.getValue()).entrySet()) {
                this.unregisterComponent((HstContainerConfig)entry.getKey(), (String)compEntry.getKey());
            }
        }
        this.servletConfigComponentsMap.clear();
    }

    protected Map<String, HstComponentHolder> getServletConfigComponentsMap(HstContainerConfig requestContainerConfig, boolean create) {
        Map<String, HstComponentHolder> componentsMap = this.servletConfigComponentsMap.get(requestContainerConfig);
        if (componentsMap == null && create) {
            componentsMap = new ConcurrentHashMap<String, HstComponentHolder>();
            this.servletConfigComponentsMap.put(requestContainerConfig, componentsMap);
        }
        return this.servletConfigComponentsMap.get(requestContainerConfig);
    }

    private static class HstComponentHolder {
        private HstComponent component;
        private HstComponentMetadata componentMetadata;

        private HstComponentHolder(HstComponent component, HstComponentMetadata componentMetadata) {
            this.component = component;
            this.componentMetadata = componentMetadata;
        }

        public HstComponent getComponent() {
            return this.component;
        }

        public HstComponentMetadata getComponentMetadata() {
            return this.componentMetadata;
        }
    }
}

