/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.container;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.core.component.HstComponent;
import org.hippoecm.hst.core.component.HstComponentException;
import org.hippoecm.hst.core.component.HstParameterInfoProxyFactoryImpl;
import org.hippoecm.hst.core.component.HstRequest;
import org.hippoecm.hst.core.component.HstRequestImpl;
import org.hippoecm.hst.core.component.HstResourceResponseImpl;
import org.hippoecm.hst.core.component.HstResponse;
import org.hippoecm.hst.core.component.HstResponseImpl;
import org.hippoecm.hst.core.container.ContainerException;
import org.hippoecm.hst.core.container.HstComponentInvoker;
import org.hippoecm.hst.core.container.HstComponentWindow;
import org.hippoecm.hst.core.container.HstContainerConfig;
import org.hippoecm.hst.diagnosis.HDC;
import org.hippoecm.hst.diagnosis.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HstComponentInvokerImpl
implements HstComponentInvoker {
    private static final Logger log = LoggerFactory.getLogger(HstComponentInvokerImpl.class);
    protected boolean exceptionThrowable;
    protected String errorRenderPath;
    protected String dispatchUrlPrefix;

    public void setExceptionThrowable(boolean exceptionThrowable) {
        this.exceptionThrowable = exceptionThrowable;
    }

    public void setErrorRenderPath(String errorRenderPath) {
        this.errorRenderPath = errorRenderPath;
    }

    public void setDispatchUrlPrefix(String dispatchUrlPrefix) {
        if (dispatchUrlPrefix != null && !dispatchUrlPrefix.startsWith("/")) {
            log.info("The configured dispatchUrlPrefix '{}' does not start with a '/'. We prepend a '/' as the location should be a context relative path.");
            this.dispatchUrlPrefix = "/" + dispatchUrlPrefix;
        } else {
            this.dispatchUrlPrefix = dispatchUrlPrefix;
        }
    }

    public void invokeAction(HstContainerConfig requestContainerConfig, ServletRequest servletRequest, ServletResponse servletResponse) throws ContainerException {
        block12: {
            HstRequest hstRequest = (HstRequest)servletRequest;
            HstResponse hstResponse = (HstResponse)servletResponse;
            HstComponentWindow window = ((HstRequestImpl)hstRequest).getComponentWindow();
            HstComponent component = window.getComponent();
            if (component != null) {
                try {
                    log.debug("invoking action of component: {}", (Object)component.getClass().getName());
                    component.doAction(hstRequest, hstResponse);
                }
                catch (HstComponentException e) {
                    if (this.exceptionThrowable) {
                        throw e;
                    }
                    window.addComponentExcpetion(e);
                    if (log.isDebugEnabled()) {
                        log.warn("Component exception caught on window " + window.getName() + " with component " + component.getClass().getName() + ": " + (Object)((Object)e), (Throwable)e);
                    } else if (log.isWarnEnabled()) {
                        log.warn("Component exception caught on window " + window.getName() + " with component " + component.getClass().getName() + ": {} at {}", (Object)e, (Object)this.getFirstStackTraceElement(e));
                    }
                    break block12;
                }
                catch (Exception e) {
                    if (this.exceptionThrowable) {
                        throw new HstComponentException((Throwable)e);
                    }
                    window.addComponentExcpetion(new HstComponentException((Throwable)e));
                    if (log.isDebugEnabled()) {
                        log.warn("Component exception caught: " + e, (Throwable)e);
                    } else if (log.isWarnEnabled()) {
                        log.warn("Component exception caught: {} at {}", (Object)e, (Object)this.getFirstStackTraceElement(e));
                    }
                    break block12;
                }
            }
            window.addComponentExcpetion(new HstComponentException("The component is not available."));
        }
    }

    public void invokePrepareBeforeRender(HstContainerConfig requestContainerConfig, ServletRequest servletRequest, ServletResponse servletResponse) throws ContainerException {
        block13: {
            HstRequest hstRequest = (HstRequest)servletRequest;
            HstResponse hstResponse = (HstResponse)servletResponse;
            HstComponentWindow window = ((HstRequestImpl)hstRequest).getComponentWindow();
            HstComponent component = window.getComponent();
            if (component != null) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("invoking doBeforeRender of component: {}", (Object)component.getClass().getName());
                    }
                    component.prepareBeforeRender(hstRequest, hstResponse);
                }
                catch (HstComponentException e) {
                    if (this.exceptionThrowable) {
                        throw e;
                    }
                    window.addComponentExcpetion(e);
                    if (log.isDebugEnabled()) {
                        log.warn("Component exception caught: " + (Object)((Object)e), (Throwable)e);
                    } else if (log.isWarnEnabled()) {
                        log.warn("Component exception caught: {} at {}", (Object)e, (Object)this.getFirstStackTraceElement(e));
                    }
                    break block13;
                }
                catch (Exception e) {
                    if (this.exceptionThrowable) {
                        throw new HstComponentException((Throwable)e);
                    }
                    window.addComponentExcpetion(new HstComponentException((Throwable)e));
                    if (log.isDebugEnabled()) {
                        log.warn("Component exception caught on window " + window.getName() + " with component " + component.getClass().getName() + ": " + e, (Throwable)e);
                    } else if (log.isWarnEnabled()) {
                        log.warn("Component exception caught on window " + window.getName() + " with component " + component.getClass().getName() + ": {} at {}", (Object)e, (Object)this.getFirstStackTraceElement(e));
                    }
                    break block13;
                }
            }
            window.addComponentExcpetion(new HstComponentException("The component is not available."));
        }
    }

    public void invokeBeforeRender(HstContainerConfig requestContainerConfig, ServletRequest servletRequest, ServletResponse servletResponse) throws ContainerException {
        block13: {
            HstRequest hstRequest = (HstRequest)servletRequest;
            HstResponse hstResponse = (HstResponse)servletResponse;
            HstComponentWindow window = ((HstRequestImpl)hstRequest).getComponentWindow();
            HstComponent component = window.getComponent();
            if (component != null) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("invoking doBeforeRender of component: {}", (Object)component.getClass().getName());
                    }
                    component.doBeforeRender(hstRequest, hstResponse);
                }
                catch (HstComponentException e) {
                    if (this.exceptionThrowable) {
                        throw e;
                    }
                    window.addComponentExcpetion(e);
                    if (log.isDebugEnabled()) {
                        log.warn("Component exception caught: " + (Object)((Object)e), (Throwable)e);
                    } else if (log.isWarnEnabled()) {
                        log.warn("Component exception caught: {} at {}", (Object)e, (Object)this.getFirstStackTraceElement(e));
                    }
                    break block13;
                }
                catch (Exception e) {
                    if (this.exceptionThrowable) {
                        throw new HstComponentException((Throwable)e);
                    }
                    window.addComponentExcpetion(new HstComponentException((Throwable)e));
                    if (log.isDebugEnabled()) {
                        log.warn("Component exception caught on window " + window.getName() + " with component " + component.getClass().getName() + ": " + e, (Throwable)e);
                    } else if (log.isWarnEnabled()) {
                        log.warn("Component exception caught on window " + window.getName() + " with component " + component.getClass().getName() + ": {} at {}", (Object)e, (Object)this.getFirstStackTraceElement(e));
                    }
                    break block13;
                }
            }
            window.addComponentExcpetion(new HstComponentException("The component is not available."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeRender(HstContainerConfig requestContainerConfig, ServletRequest servletRequest, ServletResponse servletResponse) throws ContainerException {
        HstRequest hstRequest = (HstRequest)servletRequest;
        HstResponse hstResponse = (HstResponse)servletResponse;
        HstComponentWindow window = ((HstRequestImpl)hstRequest).getComponentWindow();
        HstComponent component = window.getComponent();
        boolean namedDispatching = false;
        String dispatchUrl = ((HstResponseImpl)hstResponse).getRenderPath();
        if (StringUtils.isBlank((String)dispatchUrl) && component != null) {
            String templateParameter = null;
            try {
                HstParameterInfoProxyFactoryImpl.TemplateParameterInfo parameterInfoProxy = (HstParameterInfoProxyFactoryImpl.TemplateParameterInfo)hstRequest.getRequestContext().getParameterInfoProxyFactory().createParameterInfoProxy(HstParameterInfoProxyFactoryImpl.TEMPLATE_PARAMETER_INFO_HOLDER.getParametersInfo(), component.getComponentConfiguration(), hstRequest, (parameterValue, returnType) -> parameterValue);
                templateParameter = parameterInfoProxy.getTemplateParameter();
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.warn("Exception while trying to fetch param '{}'", (Object)"org.hippoecm.hst.core.component.template", (Object)e);
                }
                log.warn("Exception while trying to fetch param '{}' : {}", (Object)"org.hippoecm.hst.core.component.template", (Object)e.toString());
            }
            dispatchUrl = StringUtils.isNotBlank(templateParameter) ? templateParameter : window.getRenderPath();
        }
        if (dispatchUrl == null) {
            dispatchUrl = window.getNamedRenderer();
            namedDispatching = dispatchUrl != null;
        }
        ServletRequest wrappedRequest = ((HstRequestImpl)hstRequest).getRequest();
        try {
            this.setHstObjectAttributesForServlet(wrappedRequest, hstRequest, hstResponse);
            if (!StringUtils.isBlank((String)dispatchUrl)) {
                this.invokeDispatcher(requestContainerConfig, servletRequest, servletResponse, namedDispatching, dispatchUrl, window);
            } else {
                log.debug("The dispatch url is blank. Component name: '{}'. Component id: '{}'.", (Object)window.getName(), (Object)window.getComponentInfo().getId());
            }
        }
        catch (HstComponentException e) {
            if (this.exceptionThrowable) {
                throw e;
            }
            window.addComponentExcpetion(e);
            if (log.isDebugEnabled()) {
                log.warn("Component exception caught on window " + window.getName() + " with component " + component.getClass().getName() + ": " + (Object)((Object)e), (Throwable)e);
            } else if (log.isWarnEnabled()) {
                log.warn("Component exception caught on window " + window.getName() + " with component " + component.getClass().getName() + ": {} at {}", (Object)e, (Object)this.getFirstStackTraceElement(e));
            }
        }
        catch (Exception e) {
            if (this.exceptionThrowable) {
                throw new HstComponentException((Throwable)e);
            }
            window.addComponentExcpetion(new HstComponentException((Throwable)e));
            this.logComponentException(window, e);
        }
        finally {
            this.removeHstObjectAttributesForServlet(wrappedRequest, hstRequest, hstResponse);
        }
        if (window.hasComponentExceptions()) {
            this.renderErrorInformation(requestContainerConfig, servletRequest, servletResponse, window);
        }
    }

    private void logComponentException(HstComponentWindow window, Exception e) {
        if (log.isDebugEnabled()) {
            log.warn("Component exception caught on window " + window.getName() + " with component " + window.getComponentName() + ": " + e.toString(), (Throwable)e);
        } else if (log.isWarnEnabled()) {
            log.warn("Component exception caught on window '{}' with component '{}': {} at {}", new Object[]{window.getName(), window.getComponentName(), e.toString(), this.getFirstStackTraceElement(e)});
        }
    }

    public void invokeBeforeServeResource(HstContainerConfig requestContainerConfig, ServletRequest servletRequest, ServletResponse servletResponse) throws ContainerException {
        block12: {
            HstRequest hstRequest = (HstRequest)servletRequest;
            HstResponse hstResponse = (HstResponse)servletResponse;
            HstComponentWindow window = ((HstRequestImpl)hstRequest).getComponentWindow();
            HstComponent component = window.getComponent();
            if (component != null) {
                try {
                    component.doBeforeServeResource(hstRequest, hstResponse);
                }
                catch (HstComponentException e) {
                    if (this.exceptionThrowable) {
                        throw e;
                    }
                    window.addComponentExcpetion(e);
                    if (log.isDebugEnabled()) {
                        log.warn("Component exception caught on window " + window.getName() + " with component " + component.getClass().getName() + ": " + (Object)((Object)e), (Throwable)e);
                    } else if (log.isWarnEnabled()) {
                        log.warn("Component exception caught on window " + window.getName() + " with component " + component.getClass().getName() + ": {} at {}", (Object)e, (Object)this.getFirstStackTraceElement(e));
                    }
                    break block12;
                }
                catch (Exception e) {
                    if (this.exceptionThrowable) {
                        throw new HstComponentException((Throwable)e);
                    }
                    window.addComponentExcpetion(new HstComponentException((Throwable)e));
                    if (log.isDebugEnabled()) {
                        log.warn("Component exception caught: " + e, (Throwable)e);
                    } else if (log.isWarnEnabled()) {
                        log.warn("Component exception caught: {} at {}", (Object)e, (Object)this.getFirstStackTraceElement(e));
                    }
                    break block12;
                }
            }
            window.addComponentExcpetion(new HstComponentException("The component is not available."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeServeResource(HstContainerConfig requestContainerConfig, ServletRequest servletRequest, ServletResponse servletResponse) throws ContainerException {
        HstRequest hstRequest = (HstRequest)servletRequest;
        HstResponse hstResponse = (HstResponse)servletResponse;
        HstComponentWindow window = ((HstRequestImpl)hstRequest).getComponentWindow();
        HstComponent component = window.getComponent();
        boolean namedDispatching = false;
        String dispatchUrl = ((HstResourceResponseImpl)hstResponse).getServeResourcePath();
        if (StringUtils.isBlank((String)dispatchUrl)) {
            dispatchUrl = window.getServeResourcePath();
        }
        if (dispatchUrl == null) {
            dispatchUrl = window.getNamedResourceServer();
            boolean bl = namedDispatching = dispatchUrl != null;
        }
        if (dispatchUrl == null) {
            dispatchUrl = window.getRenderPath();
        }
        if (dispatchUrl == null) {
            dispatchUrl = window.getNamedRenderer();
            namedDispatching = dispatchUrl != null;
        }
        ServletRequest wrappedRequest = ((HstRequestImpl)hstRequest).getRequest();
        try {
            this.setHstObjectAttributesForServlet(wrappedRequest, hstRequest, hstResponse);
            this.invokeDispatcher(requestContainerConfig, servletRequest, servletResponse, namedDispatching, dispatchUrl, window);
        }
        catch (HstComponentException e) {
            if (this.exceptionThrowable) {
                throw e;
            }
            window.addComponentExcpetion(e);
            this.logComponentException(window, (Exception)((Object)e));
        }
        catch (Exception e) {
            if (this.exceptionThrowable) {
                throw new HstComponentException((Throwable)e);
            }
            window.addComponentExcpetion(new HstComponentException((Throwable)e));
            if (log.isDebugEnabled()) {
                log.warn("Component exception caught: " + e, (Throwable)e);
            } else if (log.isWarnEnabled()) {
                log.warn("Component exception caught: {} at {}", (Object)e, (Object)this.getFirstStackTraceElement(e));
            }
        }
        finally {
            this.removeHstObjectAttributesForServlet(wrappedRequest, hstRequest, hstResponse);
        }
        if (window.hasComponentExceptions()) {
            this.renderErrorInformation(requestContainerConfig, servletRequest, servletResponse, window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeDispatcher(HstContainerConfig requestContainerConfig, ServletRequest servletRequest, ServletResponse servletResponse, boolean namedDispatching, String dispatchUrl, HstComponentWindow window) throws Exception {
        RequestDispatcher disp = null;
        if (!StringUtils.isBlank((String)dispatchUrl)) {
            log.debug("Invoking dispatcher of url: {}", (Object)dispatchUrl);
            if (namedDispatching) {
                disp = requestContainerConfig.getServletContext().getNamedDispatcher(dispatchUrl);
            } else {
                if (dispatchUrl.startsWith("jcr:")) {
                    servletRequest.setAttribute("org.hippoecm.hst.core.container.HstComponentWindow.dispatch.uri.protocol", (Object)"jcr:");
                    dispatchUrl = dispatchUrl.substring("jcr:".length());
                } else if (dispatchUrl.startsWith("webfile:")) {
                    servletRequest.setAttribute("org.hippoecm.hst.core.container.HstComponentWindow.dispatch.uri.protocol", (Object)"webfile:");
                    dispatchUrl = dispatchUrl.substring("webfile:".length());
                } else if (dispatchUrl.startsWith("classpath:")) {
                    servletRequest.setAttribute("org.hippoecm.hst.core.container.HstComponentWindow.dispatch.uri.protocol", (Object)"classpath:");
                    dispatchUrl = dispatchUrl.substring("classpath:".length());
                    if (!dispatchUrl.startsWith("/")) {
                        String resolvedDispatchUrl = "/" + window.getComponent().getClass().getPackage().getName().replace(".", "/") + "/" + dispatchUrl;
                        log.debug("Relative classpath dispatch URL '{}' has been resolved to '{}'", (Object)dispatchUrl, (Object)resolvedDispatchUrl);
                        dispatchUrl = resolvedDispatchUrl;
                    }
                } else if (!dispatchUrl.startsWith("/")) {
                    dispatchUrl = this.dispatchUrlPrefix + dispatchUrl;
                }
                disp = requestContainerConfig.getServletContext().getRequestDispatcher(dispatchUrl);
            }
        }
        if (disp == null) {
            log.warn("The request dispatcher for dispatch url '{}' is null. Component name: '{}' . Component class: '" + window.getComponentName() + "'. Component id: '" + window.getComponentInfo().getId() + "'. If the component is inherited, the id might be a concatenation of some id's.", (Object)dispatchUrl, (Object)window.getName());
            window.addComponentExcpetion(new HstComponentException("The dispatch url is null."));
        } else {
            Task dispatchTask = null;
            try {
                if (HDC.isStarted()) {
                    dispatchTask = HDC.getCurrentTask().startSubtask("Dispatcher");
                    dispatchTask.setAttribute("dispatch", (Object)dispatchUrl);
                }
                disp.include(servletRequest, servletResponse);
            }
            finally {
                if (dispatchTask != null) {
                    dispatchTask.stop();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderErrorInformation(HstContainerConfig requestContainerConfig, ServletRequest servletRequest, ServletResponse servletResponse, HstComponentWindow window) {
        block7: {
            try {
                servletResponse.reset();
                if (this.errorRenderPath == null || this.errorRenderPath.length() == 0) break block7;
                try {
                    servletRequest.setAttribute("errorComponentWindow", (Object)window);
                    this.invokeDispatcher(requestContainerConfig, servletRequest, servletResponse, false, this.errorRenderPath, window);
                    servletResponse.flushBuffer();
                }
                finally {
                    servletRequest.removeAttribute("errorComponentWindow");
                }
            }
            catch (Exception e) {
                log.warn("Failed to dispatch to error page: " + e);
                try {
                    servletResponse.reset();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void setHstObjectAttributesForServlet(ServletRequest servletRequest, HstRequest hstRequest, HstResponse hstResponse) {
        servletRequest.setAttribute("org.hippoecm.hst.container.request", (Object)hstRequest);
        servletRequest.setAttribute("org.hippoecm.hst.container.response", (Object)hstResponse);
    }

    private void removeHstObjectAttributesForServlet(ServletRequest servletRequest, HstRequest hstRequest, HstResponse hstResponse) {
        servletRequest.removeAttribute("org.hippoecm.hst.container.request");
        servletRequest.removeAttribute("org.hippoecm.hst.container.response");
    }

    private StackTraceElement getFirstStackTraceElement(Throwable th) {
        StackTraceElement[] stackTraceElements = th.getStackTrace();
        if (stackTraceElements != null && stackTraceElements.length != 0) {
            return stackTraceElements[0];
        }
        return null;
    }
}

