/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.container;

import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.configuration.components.HstComponentConfiguration;
import org.hippoecm.hst.configuration.hosting.Mount;
import org.hippoecm.hst.core.component.GenericHstComponent;
import org.hippoecm.hst.core.component.HstComponent;
import org.hippoecm.hst.core.component.HstComponentException;
import org.hippoecm.hst.core.component.HstComponentMetadata;
import org.hippoecm.hst.core.container.ComponentManager;
import org.hippoecm.hst.core.container.ComponentManagerAware;
import org.hippoecm.hst.core.container.HstComponentFactory;
import org.hippoecm.hst.core.container.HstComponentRegistry;
import org.hippoecm.hst.core.container.HstContainerConfig;
import org.hippoecm.hst.core.request.ComponentConfiguration;
import org.hippoecm.hst.site.request.ComponentConfigurationImpl;

public class HstComponentFactoryImpl
implements HstComponentFactory,
ComponentManagerAware {
    protected HstComponentRegistry componentRegistry;
    protected Class<?> defaultHstComponentClass = GenericHstComponent.class;
    protected String defaultHstComponentClassName = GenericHstComponent.class.getName();
    private ComponentManager componentManager;

    public HstComponentFactoryImpl(HstComponentRegistry componentRegistry) {
        this.componentRegistry = componentRegistry;
    }

    public void setComponentManager(ComponentManager componentManager) {
        this.componentManager = componentManager;
    }

    public String getDefaultHstComponentClassName() {
        return this.defaultHstComponentClassName;
    }

    public Class<?> getDefaultHstComponentClass() {
        return this.defaultHstComponentClass;
    }

    public void setDefaultHstComponentClass(Class<?> defaultHstComponentClass) {
        this.defaultHstComponentClass = defaultHstComponentClass;
        this.defaultHstComponentClassName = defaultHstComponentClass.getName();
    }

    public HstComponent getComponentInstance(HstContainerConfig requestContainerConfig, HstComponentConfiguration compConfig, Mount mount) throws HstComponentException {
        String componentId = this.getComponentId(compConfig, mount);
        HstComponent component = this.componentRegistry.getComponent(requestContainerConfig, componentId);
        if (component == null) {
            String componentClassName = StringUtils.trim((String)compConfig.getComponentClassName());
            try {
                if (StringUtils.isNotEmpty((String)componentClassName)) {
                    component = (HstComponent)this.componentManager.getComponent(componentClassName);
                    if (component == null) {
                        Class<?> compClass = Class.forName(componentClassName);
                        component = (HstComponent)compClass.newInstance();
                    }
                } else {
                    Class<?> compClass = this.defaultHstComponentClass;
                    componentClassName = this.defaultHstComponentClassName;
                    component = (HstComponent)compClass.newInstance();
                }
                ComponentConfigurationImpl compConfigImpl = new ComponentConfigurationImpl(compConfig);
                component.init(requestContainerConfig.getServletContext(), (ComponentConfiguration)compConfigImpl);
            }
            catch (ClassNotFoundException e) {
                HstComponentException exc = new HstComponentException("Cannot find the class of " + compConfig.getCanonicalStoredLocation() + ": " + componentClassName);
                this.componentRegistry.registerComponent(requestContainerConfig, componentId, (HstComponent)new FailedComponent(exc));
                throw exc;
            }
            catch (InstantiationException e) {
                HstComponentException exc = new HstComponentException("Cannot instantiate the class of " + compConfig.getCanonicalStoredLocation() + ": " + componentClassName);
                this.componentRegistry.registerComponent(requestContainerConfig, componentId, (HstComponent)new FailedComponent(exc));
                throw exc;
            }
            catch (IllegalAccessException e) {
                HstComponentException exc = new HstComponentException("Illegal access to the class of " + compConfig.getCanonicalStoredLocation() + ": " + componentClassName);
                this.componentRegistry.registerComponent(requestContainerConfig, componentId, (HstComponent)new FailedComponent(exc));
                throw exc;
            }
            this.componentRegistry.registerComponent(requestContainerConfig, componentId, component);
        }
        if (component instanceof FailedComponent) {
            throw ((FailedComponent)component).exc;
        }
        return component;
    }

    public HstComponentMetadata getComponentMetadata(HstContainerConfig requestContainerConfig, HstComponentConfiguration compConfig, Mount mount) throws HstComponentException {
        String componentId = this.getComponentId(compConfig, mount);
        return this.componentRegistry.getComponentMetadata(requestContainerConfig, componentId);
    }

    public <T> T getObjectInstance(HstContainerConfig requestContainerConfig, String className) throws HstComponentException {
        try {
            Class<?> clazz = Class.forName(className);
            return (T)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new HstComponentException("Cannot find the class of " + className);
        }
        catch (InstantiationException e) {
            throw new HstComponentException("Cannot instantiate the class of " + className);
        }
        catch (IllegalAccessException e) {
            throw new HstComponentException("Illegal access to the class of " + className);
        }
    }

    private String getComponentId(HstComponentConfiguration compConfig, Mount mount) {
        StringBuilder componentIdBuilder = new StringBuilder();
        componentIdBuilder.append("mount:").append(mount.hashCode()).append('\uffff').append(mount.getIdentifier()).append('\uffff');
        componentIdBuilder.append("compId:").append(compConfig.getId()).append('\uffff').append(compConfig.hashCode());
        return componentIdBuilder.toString();
    }

    private static final class FailedComponent
    extends GenericHstComponent {
        private HstComponentException exc;

        public FailedComponent(HstComponentException exc) {
            this.exc = exc;
        }
    }
}

