/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.container;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.hippoecm.hst.core.container.AbstractBaseOrderableValve;
import org.hippoecm.hst.core.container.ContainerException;
import org.hippoecm.hst.core.container.ValveContext;
import org.hippoecm.hst.util.KeyValue;

public class GenericResponseHeadersValve
extends AbstractBaseOrderableValve {
    private List<KeyValue<String, Object>> settableHeaders;
    private List<KeyValue<String, Object>> addableHeaders;

    public void setSettableHeaders(List<KeyValue<String, Object>> settableHeaders) {
        this.settableHeaders = settableHeaders;
    }

    public void setAddableHeaders(List<KeyValue<String, Object>> addableHeaders) {
        this.addableHeaders = addableHeaders;
    }

    @Override
    public void invoke(ValveContext context) throws ContainerException {
        HttpServletResponse servletResponse = context.getServletResponse();
        String key = null;
        Object value = null;
        if (this.settableHeaders != null) {
            for (KeyValue<String, Object> pair : this.settableHeaders) {
                key = (String)pair.getKey();
                value = pair.getValue();
                if (value == null) continue;
                if (value instanceof Long) {
                    servletResponse.setDateHeader(key, ((Long)value).longValue());
                    continue;
                }
                if (value instanceof Integer) {
                    servletResponse.setIntHeader(key, ((Integer)value).intValue());
                    continue;
                }
                servletResponse.setHeader(key, value.toString());
            }
        }
        if (this.addableHeaders != null) {
            for (KeyValue<String, Object> pair : this.addableHeaders) {
                key = (String)pair.getKey();
                value = pair.getValue();
                if (value == null) continue;
                if (value instanceof Long) {
                    servletResponse.addDateHeader(key, ((Long)value).longValue());
                    continue;
                }
                if (value instanceof Integer) {
                    servletResponse.addIntHeader(key, ((Integer)value).intValue());
                    continue;
                }
                servletResponse.addHeader(key, value.toString());
            }
        }
        context.invokeNext();
    }
}

