/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.container;

import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.hippoecm.hst.container.HstContainerRequest;
import org.hippoecm.hst.core.container.AbstractBaseOrderableValve;
import org.hippoecm.hst.core.container.ContainerException;
import org.hippoecm.hst.core.container.ValveContext;
import org.hippoecm.hst.diagnosis.HDC;
import org.hippoecm.hst.diagnosis.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterChainInvokingValve
extends AbstractBaseOrderableValve {
    private static Logger log = LoggerFactory.getLogger(FilterChainInvokingValve.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(ValveContext context) throws ContainerException {
        HttpServletRequest request = context.getServletRequest();
        HttpServletResponse response = context.getServletResponse();
        FilterChain filterChain = (FilterChain)request.getAttribute("org.hippoecm.hst.container.filter.chain");
        try {
            HttpServletRequest unwrappedRequest = request;
            while (unwrappedRequest instanceof HttpServletRequestWrapper) {
                if (unwrappedRequest instanceof HstContainerRequest) {
                    unwrappedRequest = ((HttpServletRequestWrapper)unwrappedRequest).getRequest();
                    break;
                }
                unwrappedRequest = ((HttpServletRequestWrapper)unwrappedRequest).getRequest();
            }
            Task chainingTask = null;
            try {
                if (HDC.isStarted()) {
                    chainingTask = HDC.getCurrentTask().startSubtask("Filter Chain invocation task");
                }
                filterChain.doFilter((ServletRequest)unwrappedRequest, (ServletResponse)response);
            }
            finally {
                if (chainingTask != null) {
                    chainingTask.stop();
                }
            }
        }
        catch (Exception e) {
            log.warn("Failed to continue with the filterChain.", (Throwable)e);
        }
        context.invokeNext();
    }
}

