/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.container;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.ehcache.constructs.web.Header;
import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.cache.CacheElement;
import org.hippoecm.hst.cache.HstCache;
import org.hippoecm.hst.cache.HstPageInfo;
import org.hippoecm.hst.cache.UncacheableHstPageInfo;
import org.hippoecm.hst.cache.esi.ESIFragmentInfo;
import org.hippoecm.hst.cache.esi.ESIHstPageInfo;
import org.hippoecm.hst.cache.esi.ESIPageRenderer;
import org.hippoecm.hst.cache.esi.ESIPageScanner;
import org.hippoecm.hst.configuration.components.HstComponentInfo;
import org.hippoecm.hst.core.container.AbstractBaseOrderableValve;
import org.hippoecm.hst.core.container.ContainerException;
import org.hippoecm.hst.core.container.HstComponentWindow;
import org.hippoecm.hst.core.container.PageCacheKey;
import org.hippoecm.hst.core.container.PageInfoRenderingValve;
import org.hippoecm.hst.core.container.ValveContext;
import org.hippoecm.hst.core.request.HstRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESIPageInfoScanningValve
extends AbstractBaseOrderableValve {
    private static final Logger log = LoggerFactory.getLogger(ESIPageInfoScanningValve.class);
    protected HstCache pageCache;
    private boolean esiFragmentsProcessing;
    private boolean esiFragmentsProcessingOnlyForAsyncComponents;
    private final ESIPageScanner esiPageScanner;
    private final ESIPageRenderer esiPageRenderer;

    public ESIPageInfoScanningValve(ESIPageScanner esiPageScanner, ESIPageRenderer esiPageRenderer) {
        this.esiPageScanner = esiPageScanner;
        this.esiPageRenderer = esiPageRenderer;
    }

    public void setPageCache(HstCache pageCache) {
        this.pageCache = pageCache;
    }

    public boolean isEsiFragmentsProcessing() {
        return this.esiFragmentsProcessing;
    }

    public void setEsiFragmentsProcessing(boolean esiFragmentsProcessing) {
        this.esiFragmentsProcessing = esiFragmentsProcessing;
    }

    public boolean isEsiFragmentsProcessingOnlyForAsyncComponents() {
        return this.esiFragmentsProcessingOnlyForAsyncComponents;
    }

    public void setEsiFragmentsProcessingOnlyForAsyncComponents(boolean esiFragmentsProcessingOnlyForAsyncComponents) {
        this.esiFragmentsProcessingOnlyForAsyncComponents = esiFragmentsProcessingOnlyForAsyncComponents;
    }

    @Override
    public void invoke(ValveContext context) throws ContainerException {
        if (!this.isEsiFragmentsProcessing()) {
            context.invokeNext();
            return;
        }
        if (this.isEsiFragmentsProcessingOnlyForAsyncComponents()) {
            HstComponentWindow rootRenderingWindow = context.getRootComponentRenderingWindow();
            if (rootRenderingWindow == null) {
                rootRenderingWindow = context.getRootComponentWindow();
            }
            if (!this.hasAnyEsiModeAsyncComponentWindow(rootRenderingWindow)) {
                context.invokeNext();
                return;
            }
        }
        HstRequestContext requestContext = context.getRequestContext();
        HttpServletRequest request = requestContext.getServletRequest();
        try {
            HstPageInfo pageInfo;
            if (this.isRequestCacheable(context)) {
                context.invokeNext();
                pageInfo = (HstPageInfo)((Object)request.getAttribute(PageInfoRenderingValve.PAGE_INFO));
                if (pageInfo == null) {
                    log.warn("HstPageInfo was not found. It was supposed to be set by PageCachingValve.");
                }
            } else {
                pageInfo = this.createHstPageInfoByInvokingNextValve(context, this.pageCache.getTimeToLiveSeconds());
                request.setAttribute(PageInfoRenderingValve.PAGE_INFO, (Object)pageInfo);
            }
            if (pageInfo != null) {
                if (!(pageInfo instanceof ESIHstPageInfo)) {
                    String contentType = pageInfo.getContentType();
                    if (StringUtils.startsWith((String)contentType, (String)"text/")) {
                        ESIHstPageInfo esiPageInfo = this.convertHstPageInfoToESIPageInfo(pageInfo);
                        request.setAttribute(PageInfoRenderingValve.PAGE_INFO, (Object)esiPageInfo);
                        if (this.isRequestCacheable(context)) {
                            PageCacheKey pageCacheKey = context.getPageCacheContext().getPageCacheKey();
                            if (pageInfo.isNoCachePresentOrExpiresImmediately() || pageInfo instanceof UncacheableHstPageInfo) {
                                this.pageCache.put(this.pageCache.createUncacheableElement((Object)pageCacheKey, (Object)esiPageInfo));
                            } else {
                                CacheElement elem = this.pageCache.createElement((Object)pageCacheKey, (Object)esiPageInfo);
                                Long expiresHeader = pageInfo.getExpiresInSeconds();
                                if (expiresHeader != null) {
                                    elem.setTimeToLiveSeconds(expiresHeader.intValue());
                                }
                                this.pageCache.put(elem);
                            }
                        }
                        pageInfo = esiPageInfo;
                    } else {
                        log.debug("The cached pageInfo is not of text content ('{}'). So skipping to convert to ESIHstPageInfo.", (Object)contentType);
                    }
                }
                if (pageInfo instanceof ESIHstPageInfo) {
                    ((ESIHstPageInfo)pageInfo).setESIPageRenderer(this.esiPageRenderer);
                }
            }
        }
        catch (Exception e) {
            throw new ContainerException((Throwable)e);
        }
    }

    protected ESIHstPageInfo convertHstPageInfoToESIPageInfo(HstPageInfo pageInfo) throws Exception {
        String characterEncoding = StringUtils.defaultIfEmpty((String)pageInfo.getCharacterEncoding(), (String)"UTF-8");
        String bodyContent = new String(pageInfo.getUngzippedBody(), characterEncoding);
        ESIHstPageInfo esiPageInfo = new ESIHstPageInfo(pageInfo.getStatusCode(), pageInfo.getContentType(), (Collection)pageInfo.getSerializableCookies(), bodyContent, pageInfo.getCharacterEncoding(), pageInfo.getTimeToLiveSeconds(), (Collection<Header<? extends Serializable>>)pageInfo.getHeaders());
        List<ESIFragmentInfo> fragmentInfos = this.esiPageScanner.scanFragmentInfos(bodyContent);
        if (!fragmentInfos.isEmpty()) {
            esiPageInfo.addAllFragmentInfos(fragmentInfos);
        }
        return esiPageInfo;
    }

    protected boolean hasAnyEsiModeAsyncComponentWindow(HstComponentWindow window) {
        if (window == null) {
            return false;
        }
        ArrayList<HstComponentWindow> asyncWindowList = new ArrayList<HstComponentWindow>();
        this.fillFirstEsiModeAsyncComponentWindow(window, asyncWindowList);
        return !asyncWindowList.isEmpty();
    }

    protected boolean isEsiModeAsyncComponentWindow(HstComponentWindow window) {
        HstComponentInfo compInfo = window.getComponentInfo();
        if (!compInfo.isAsync()) {
            return false;
        }
        String asyncMode = StringUtils.defaultIfEmpty((String)compInfo.getAsyncMode(), (String)this.defaultAsynchronousComponentWindowRenderingMode);
        return StringUtils.equals((String)"esi", (String)asyncMode);
    }

    private void fillFirstEsiModeAsyncComponentWindow(HstComponentWindow window, List<HstComponentWindow> asyncWindowsList) {
        if (this.isEsiModeAsyncComponentWindow(window)) {
            asyncWindowsList.add(window);
        } else {
            Map childWindowsMap = window.getChildWindowMap();
            if (childWindowsMap != null) {
                for (HstComponentWindow childWindow : childWindowsMap.values()) {
                    this.fillFirstEsiModeAsyncComponentWindow(childWindow, asyncWindowsList);
                    if (asyncWindowsList.isEmpty()) continue;
                    break;
                }
            }
        }
    }
}

