/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.container;

import org.hippoecm.hst.configuration.hosting.VirtualHosts;
import org.hippoecm.hst.core.container.AbstractDiagnosticReportingValve;
import org.hippoecm.hst.core.container.ValveContext;
import org.hippoecm.hst.diagnosis.Task;
import org.hippoecm.hst.diagnosis.TaskLogFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagnosticReportingValve
extends AbstractDiagnosticReportingValve {
    private static Logger log = LoggerFactory.getLogger(DiagnosticReportingValve.class);

    protected void logDiagnosticSummary(ValveContext context, Task rootTask) {
        if (log.isInfoEnabled()) {
            VirtualHosts virtualHosts = context.getRequestContext().getResolvedMount().getMount().getVirtualHost().getVirtualHosts();
            long threshold = virtualHosts.getDiagnosticsThresholdMillis();
            if (threshold > -1L && rootTask.getDurationTimeMillis() < threshold) {
                log.debug("Skipping task '{}' because took only '{}' ms.", (Object)rootTask.getName(), (Object)rootTask.getDurationTimeMillis());
                return;
            }
            int diagnosticsDepth = virtualHosts.getDiagnosticsDepth();
            long unitThreshold = virtualHosts.getDiagnosticsUnitThresholdMillis();
            log.info("Diagnostic Summary:\n{}", (Object)TaskLogFormatUtils.getTaskLog((Task)rootTask, (int)diagnosticsDepth, (long)unitThreshold));
        }
    }
}

