/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.container;

import java.io.Serializable;
import java.util.Optional;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.core.container.RequestInfoCacheKeyFragmentCreator;
import org.hippoecm.hst.core.request.HstRequestContext;
import org.hippoecm.hst.util.HstRequestUtils;
import org.hippoecm.hst.util.WebFileUtils;
import org.onehippo.cms7.services.HippoServiceRegistry;
import org.onehippo.cms7.services.webfiles.WebFileBundle;
import org.onehippo.cms7.services.webfiles.WebFilesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRequestInfoCacheKeyFragmentCreator
implements RequestInfoCacheKeyFragmentCreator {
    private static final Logger log = LoggerFactory.getLogger(DefaultRequestInfoCacheKeyFragmentCreator.class);
    private Optional<String> webFilesAntiCacheValue = null;

    public Serializable create(HstRequestContext requestContext) {
        HttpServletRequest request = requestContext.getServletRequest();
        StringBuilder requestInfo = new StringBuilder(256);
        int delim = 65535;
        Optional<String> antiCacheValue = this.webFilesAntiCacheValue;
        if (antiCacheValue == null) {
            antiCacheValue = this.populateAntiCacheValue(requestContext);
        }
        if (antiCacheValue.isPresent()) {
            requestInfo.append(antiCacheValue.get()).append('\uffff');
        }
        requestInfo.append(request.getMethod()).append('\uffff');
        requestInfo.append(HstRequestUtils.getFarthestRequestScheme((HttpServletRequest)request)).append('\uffff');
        requestInfo.append(HstRequestUtils.getFarthestRequestHost((HttpServletRequest)request)).append('\uffff');
        requestInfo.append(request.getRequestURI()).append('\uffff');
        requestInfo.append(StringUtils.defaultString((String)request.getQueryString())).append('\uffff');
        requestInfo.append(requestContext.getBaseURL().getPathInfo()).append('\uffff');
        return requestInfo.toString();
    }

    public void reset() {
        this.webFilesAntiCacheValue = null;
    }

    private Optional<String> populateAntiCacheValue(HstRequestContext requestContext) {
        Optional<String> antiCacheValue = this.webFilesAntiCacheValue;
        if (antiCacheValue != null) {
            return antiCacheValue;
        }
        WebFilesService service = (WebFilesService)HippoServiceRegistry.getService(WebFilesService.class);
        if (service == null) {
            this.webFilesAntiCacheValue = antiCacheValue = Optional.empty();
            return antiCacheValue;
        }
        try {
            Session session = requestContext.getSession();
            String bundleName = WebFileUtils.getBundleName((HstRequestContext)requestContext);
            log.debug("Trying to get web file bundle '{}' with session user '{}'", (Object)bundleName, (Object)session.getUserID());
            WebFileBundle webFileBundle = service.getJcrWebFileBundle(session, bundleName);
            String stringAntiCacheValue = webFileBundle.getAntiCacheValue();
            if (stringAntiCacheValue == null) {
                this.webFilesAntiCacheValue = antiCacheValue = Optional.empty();
                return antiCacheValue;
            }
            this.webFilesAntiCacheValue = antiCacheValue = Optional.of(stringAntiCacheValue);
            return antiCacheValue;
        }
        catch (RepositoryException e) {
            if (log.isDebugEnabled()) {
                log.warn("Cannot get anti-cache value. Use cache key without it.", (Throwable)e);
            } else {
                log.warn("Cannot get anti-cache value. Use cache key without it : {}", (Object)e.toString());
            }
            this.webFilesAntiCacheValue = antiCacheValue = Optional.empty();
            return antiCacheValue;
        }
    }
}

