/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.container;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.hippoecm.hst.configuration.components.HstComponentInfo;
import org.hippoecm.hst.core.component.HstComponentException;
import org.hippoecm.hst.core.container.PageErrors;
import org.hippoecm.hst.util.KeyValue;

public class DefaultPageErrors
implements PageErrors {
    protected List<KeyValue<HstComponentInfo, Collection<HstComponentException>>> componentExceptions;
    protected List<HstComponentInfo> componentInfos;
    protected List<HstComponentException> allExceptions;

    public DefaultPageErrors(List<KeyValue<HstComponentInfo, Collection<HstComponentException>>> componentExceptions) {
        this.componentExceptions = componentExceptions;
    }

    public boolean isEmpty() {
        return this.componentExceptions == null || this.componentExceptions.isEmpty();
    }

    public Collection<HstComponentInfo> getComponentInfos() {
        if (this.componentInfos == null) {
            this.componentInfos = new ArrayList<HstComponentInfo>();
            for (KeyValue<HstComponentInfo, Collection<HstComponentException>> pair : this.componentExceptions) {
                this.componentInfos.add((HstComponentInfo)pair.getKey());
            }
        }
        return this.componentInfos;
    }

    public Collection<HstComponentException> getComponentExceptions(HstComponentInfo componentInfo) {
        for (KeyValue<HstComponentInfo, Collection<HstComponentException>> pair : this.componentExceptions) {
            HstComponentInfo componentInfoKey = (HstComponentInfo)pair.getKey();
            if (!componentInfoKey.getId().equals(componentInfo.getId())) continue;
            return (Collection)pair.getValue();
        }
        return Collections.emptyList();
    }

    public Collection<HstComponentException> getAllComponentExceptions() {
        if (this.allExceptions == null) {
            this.allExceptions = new ArrayList<HstComponentException>();
            for (KeyValue<HstComponentInfo, Collection<HstComponentException>> pair : this.componentExceptions) {
                this.allExceptions.addAll((Collection)pair.getValue());
            }
        }
        return this.allExceptions;
    }
}

