/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.container;

import org.hippoecm.hst.configuration.components.HstComponentInfo;
import org.hippoecm.hst.core.component.HstComponentException;
import org.hippoecm.hst.core.component.HstRequest;
import org.hippoecm.hst.core.component.HstResponse;
import org.hippoecm.hst.core.container.PageErrorHandler;
import org.hippoecm.hst.core.container.PageErrors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPageErrorHandler
implements PageErrorHandler {
    protected static final Logger log = LoggerFactory.getLogger(DefaultPageErrorHandler.class);

    public PageErrorHandler.Status handleComponentExceptions(PageErrors pageErrors, HstRequest hstRequest, HstResponse hstResponse) {
        if (!pageErrors.isEmpty()) {
            this.logWarningsForEachComponentExceptions(pageErrors);
        }
        return PageErrorHandler.Status.HANDLED_BUT_CONTINUE;
    }

    protected void logWarningsForEachComponentExceptions(PageErrors pageErrors) {
        for (HstComponentInfo componentInfo : pageErrors.getComponentInfos()) {
            for (HstComponentException componentException : pageErrors.getComponentExceptions(componentInfo)) {
                Object throwable = componentException;
                if (((Throwable)throwable).getCause() != null) {
                    throwable = ((Throwable)throwable).getCause();
                }
                if (log.isDebugEnabled()) {
                    log.warn("Component exception on " + componentInfo.getComponentClassName(), (Throwable)throwable);
                    continue;
                }
                if (!log.isWarnEnabled()) continue;
                log.warn("Component exception on {} : {} ", (Object)componentInfo.getComponentClassName(), (Object)((Throwable)throwable).toString());
            }
        }
    }
}

