/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.container;

import java.io.IOException;
import org.hippoecm.hst.configuration.components.HstComponentConfiguration;
import org.hippoecm.hst.core.container.AbstractBaseOrderableValve;
import org.hippoecm.hst.core.container.ContainerException;
import org.hippoecm.hst.core.container.ContainerNotFoundException;
import org.hippoecm.hst.core.container.HstComponentWindow;
import org.hippoecm.hst.core.container.HstContainerURL;
import org.hippoecm.hst.core.container.ValveContext;
import org.hippoecm.hst.core.internal.HstMutableRequestContext;
import org.hippoecm.hst.core.request.HstRequestContext;
import org.hippoecm.hst.core.request.ResolvedSiteMapItem;

public class ContextResolvingValve
extends AbstractBaseOrderableValve {
    @Override
    public void invoke(ValveContext context) throws ContainerException {
        HstMutableRequestContext requestContext = (HstMutableRequestContext)context.getRequestContext();
        ResolvedSiteMapItem resolvedSiteMapItem = requestContext.getResolvedSiteMapItem();
        if (resolvedSiteMapItem == null) {
            throw new ContainerException("No resolvedSiteMapItem found for this request. Cannot continue request processing");
        }
        HstComponentConfiguration rootComponentConfig = resolvedSiteMapItem.getHstComponentConfiguration();
        if (rootComponentConfig == null) {
            throw new ContainerNotFoundException(String.format("Resolved siteMapItem '%s' does not contain a ComponentConfiguration that can be resolved.", resolvedSiteMapItem.getHstSiteMapItem().getQualifiedId()));
        }
        if (rootComponentConfig.isMarkedDeleted()) {
            throw new ContainerNotFoundException(String.format("Resolved siteMapItem '%s' points to a component that is marked for deletion.", resolvedSiteMapItem.getHstSiteMapItem().getQualifiedId()));
        }
        try {
            HstComponentWindow rootComponentWindow = this.getComponentWindowFactory().create(context.getRequestContainerConfig(), (HstRequestContext)requestContext, rootComponentConfig, this.getComponentFactory());
            HstContainerURL baseURL = requestContext.getBaseURL();
            String resourceWindowRef = baseURL.getResourceWindowReferenceNamespace();
            String actionWindowReferenceNamespace = baseURL.getActionWindowReferenceNamespace();
            String componentRenderingWindowReferenceNamespace = baseURL.getComponentRenderingWindowReferenceNamespace();
            if (resourceWindowRef != null) {
                if ((rootComponentWindow = this.findComponentWindow(rootComponentWindow, resourceWindowRef)) == null) {
                    this.notFound("resource", resourceWindowRef, context);
                    return;
                }
                log.info("Found action request '{}' targeting component '{}'.", (Object)context.getServletRequest(), (Object)rootComponentWindow.getComponent().getComponentConfiguration());
            } else if (actionWindowReferenceNamespace != null) {
                if ((rootComponentWindow = this.findComponentWindow(rootComponentWindow, actionWindowReferenceNamespace)) == null) {
                    this.notFound("action", actionWindowReferenceNamespace, context);
                    return;
                }
                log.info("Found resource request '{}' targeting component '{}'.", (Object)context.getServletRequest(), (Object)rootComponentWindow.getComponent().getComponentConfiguration());
            } else if (componentRenderingWindowReferenceNamespace != null) {
                if ((rootComponentWindow = this.findComponentWindow(rootComponentWindow, componentRenderingWindowReferenceNamespace)) == null) {
                    this.notFound("component rendering", componentRenderingWindowReferenceNamespace, context);
                    return;
                }
                log.info("Found component rendering request '{}' targeting component '{}'.", (Object)context.getServletRequest(), (Object)rootComponentWindow.getComponent().getComponentConfiguration());
            }
            context.setRootComponentWindow(rootComponentWindow);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.warn("Failed to create component windows", (Throwable)e);
            } else if (log.isWarnEnabled()) {
                log.warn("Failed to create component windows: {}", (Object)e.toString());
            }
            throw new ContainerException("Failed to create component window for the configuration: " + rootComponentConfig.getId(), (Throwable)e);
        }
        context.invokeNext();
    }

    private void notFound(String type, String componentRenderingWindowReferenceNamespace, ValveContext context) throws ContainerException {
        log.warn("Illegal request for {} URL found because there is no component for id '{}' for matched sitemap item '{}'. Set 404 on response for request '{}'.", new Object[]{type, componentRenderingWindowReferenceNamespace, context.getRequestContext().getResolvedSiteMapItem().getHstSiteMapItem().getId(), context.getServletRequest()});
        try {
            context.getServletResponse().sendError(404);
        }
        catch (IOException e) {
            throw new ContainerException("Unable to set 404 on response after invalid resource path.", (Throwable)e);
        }
    }
}

