/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.container;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.hippoecm.hst.container.HstContainerRequest;
import org.hippoecm.hst.core.container.AbstractBaseOrderableValve;
import org.hippoecm.hst.core.container.ContainerException;
import org.hippoecm.hst.core.container.ValveContext;
import org.hippoecm.hst.diagnosis.HDC;
import org.hippoecm.hst.diagnosis.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerResourceDispatchingValve
extends AbstractBaseOrderableValve {
    private static Logger log = LoggerFactory.getLogger(ContainerResourceDispatchingValve.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(ValveContext context) throws ContainerException {
        HttpServletRequest request = context.getServletRequest();
        HttpServletResponse response = context.getServletResponse();
        try {
            Task chainingTask = null;
            String containerResourceDispatchPath = request.getPathInfo();
            HttpServletRequest unwrappedRequest = request;
            while (unwrappedRequest instanceof HttpServletRequestWrapper) {
                if (unwrappedRequest instanceof HstContainerRequest) {
                    unwrappedRequest = (HttpServletRequest)((HttpServletRequestWrapper)unwrappedRequest).getRequest();
                    break;
                }
                unwrappedRequest = (HttpServletRequest)((HttpServletRequestWrapper)unwrappedRequest).getRequest();
            }
            try {
                if (HDC.isStarted()) {
                    chainingTask = HDC.getCurrentTask().startSubtask("Dispatching");
                    chainingTask.setAttribute("dispatchPath", (Object)containerResourceDispatchPath);
                }
                context.getRequestContext().getServletContext().getRequestDispatcher(containerResourceDispatchPath).forward((ServletRequest)unwrappedRequest, (ServletResponse)response);
            }
            finally {
                if (chainingTask != null) {
                    chainingTask.stop();
                }
            }
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.warn("Failed to dispatch '{}'.", (Object)request, (Object)e);
            }
            log.warn("Failed to dispatch '{}' : {}", (Object)request, (Object)e.toString());
        }
        context.invokeNext();
    }
}

