/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.container;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationConverter;
import org.hippoecm.hst.core.container.ContainerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerConfigurationImpl
implements ContainerConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ContainerConfigurationImpl.class);
    protected Configuration configuration;

    public ContainerConfigurationImpl(Configuration configuration) {
        this.configuration = configuration;
    }

    public boolean isEmpty() {
        return this.configuration == null || this.configuration.isEmpty();
    }

    public boolean containsKey(String key) {
        return this.configuration.containsKey(key);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        try {
            return this.configuration.getBoolean(key, defaultValue);
        }
        catch (Exception e) {
            log.info("Return default value '{}' for '{}' because of '{}'", new Object[]{defaultValue, key, e.toString()});
            return defaultValue;
        }
    }

    public boolean getBoolean(String key) {
        try {
            return this.configuration.getBoolean(key);
        }
        catch (NoSuchElementException e) {
            log.info("Return 'false' for '{}' because of '{}'", (Object)key, (Object)e.toString());
            return false;
        }
    }

    public double getDouble(String key, double defaultValue) {
        try {
            return this.configuration.getDouble(key, defaultValue);
        }
        catch (Exception e) {
            log.info("Return default value '{}' for '{}' because of '{}'", new Object[]{defaultValue, key, e.toString()});
            return defaultValue;
        }
    }

    public double getDouble(String key) {
        try {
            return this.configuration.getDouble(key);
        }
        catch (NoSuchElementException e) {
            log.info("Return '0D' for '{}' because of '{}'", (Object)key, (Object)e.toString());
            return 0.0;
        }
    }

    public float getFloat(String key, float defaultValue) {
        try {
            return this.configuration.getFloat(key, defaultValue);
        }
        catch (Exception e) {
            log.info("Return default value '{}' for '{}' because of '{}'", new Object[]{Float.valueOf(defaultValue), key, e.toString()});
            return defaultValue;
        }
    }

    public float getFloat(String key) {
        try {
            return this.configuration.getFloat(key);
        }
        catch (NoSuchElementException e) {
            log.info("Return '0F' for '{}' because of '{}'", (Object)key, (Object)e.toString());
            return 0.0f;
        }
    }

    public int getInt(String key, int defaultValue) {
        try {
            return this.configuration.getInt(key, defaultValue);
        }
        catch (Exception e) {
            log.info("Return default value '{}' for '{}' because of '{}'", new Object[]{defaultValue, key, e.toString()});
            return defaultValue;
        }
    }

    public int getInt(String key) {
        try {
            return this.configuration.getInt(key);
        }
        catch (NoSuchElementException e) {
            log.info("Return '0' for '{}' because of '{}'", (Object)key, (Object)e.toString());
            return 0;
        }
    }

    public List<String> getList(String key) {
        return this.configuration.getList(key);
    }

    public long getLong(String key, long defaultValue) {
        return this.configuration.getLong(key, defaultValue);
    }

    public long getLong(String key) {
        return this.configuration.getLong(key);
    }

    public String getString(String key, String defaultValue) {
        try {
            return this.configuration.getString(key, defaultValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String getString(String key) {
        return this.configuration.getString(key);
    }

    public String[] getStringArray(String key) {
        return this.configuration.getStringArray(key);
    }

    public Iterator<String> getKeys() {
        return this.configuration.getKeys();
    }

    public boolean isDevelopmentMode() {
        return this.getBoolean("development.mode", false);
    }

    public void setProperty(String key, Object value) {
        this.configuration.setProperty(key, value);
    }

    public Properties toProperties() {
        return ConfigurationConverter.getProperties((Configuration)this.configuration);
    }
}

