/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.container;

import javax.servlet.http.HttpServletResponse;
import org.hippoecm.hst.core.container.AbstractBaseOrderableValve;
import org.hippoecm.hst.core.container.ContainerException;
import org.hippoecm.hst.core.container.HstComponentWindow;
import org.hippoecm.hst.core.container.ValveContext;
import org.hippoecm.hst.core.request.HstRequestContext;

public class ComponentRenderingValve
extends AbstractBaseOrderableValve {
    @Override
    public void invoke(ValveContext context) throws ContainerException {
        HstRequestContext requestContext = context.getRequestContext();
        String componentRenderingWindowReferenceNamespace = requestContext.getBaseURL().getComponentRenderingWindowReferenceNamespace();
        if (componentRenderingWindowReferenceNamespace == null) {
            context.invokeNext();
            return;
        }
        HstComponentWindow window = context.getRootComponentWindow();
        HttpServletResponse servletResponse = requestContext.getServletResponse();
        if (requestContext.isCmsRequest() || requestContext.isPreview()) {
            ComponentRenderingValve.setNoCacheHeaders(servletResponse);
        }
        if (!window.getComponentInfo().isStandalone()) {
            context.setRootComponentRenderingWindow(window);
            HstComponentWindow root = window;
            while (root.getParentWindow() != null) {
                root = root.getParentWindow();
            }
            context.setRootComponentWindow(root);
        }
        context.invokeNext();
    }

    private static void setNoCacheHeaders(HttpServletResponse response) {
        response.setDateHeader("Expires", -1L);
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
    }
}

