/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.container;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.configuration.hosting.Mount;
import org.hippoecm.hst.configuration.model.HstManager;
import org.hippoecm.hst.configuration.site.HstSiteProvider;
import org.hippoecm.hst.core.container.AbstractBaseOrderableValve;
import org.hippoecm.hst.core.container.ContainerException;
import org.hippoecm.hst.core.container.ValveContext;
import org.hippoecm.hst.core.internal.HstMutableRequestContext;
import org.hippoecm.hst.core.jcr.SessionSecurityDelegation;
import org.hippoecm.hst.core.request.HstRequestContext;
import org.hippoecm.hst.site.HstServices;
import org.hippoecm.hst.util.HstRequestUtils;
import org.onehippo.cms7.services.HippoServiceRegistry;
import org.onehippo.cms7.services.cmscontext.CmsContextService;
import org.onehippo.cms7.services.cmscontext.CmsSessionContext;

public class CmsSecurityValve
extends AbstractBaseOrderableValve {
    private SessionSecurityDelegation sessionSecurityDelegation;
    private final String[] CMS_INTERACTION_ATTRIBUTES = new String[]{HstSiteProvider.HST_SITE_PROVIDER_HTTP_SESSION_KEY};

    public void setSessionSecurityDelegation(SessionSecurityDelegation sessionSecurityDelegation) {
        this.sessionSecurityDelegation = sessionSecurityDelegation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(ValveContext context) throws ContainerException {
        CmsSessionContext cmsSessionContext;
        HttpServletRequest servletRequest = context.getServletRequest();
        HttpServletResponse servletResponse = context.getServletResponse();
        HstRequestContext requestContext = context.getRequestContext();
        if (!requestContext.isCmsRequest()) {
            String ignoredPrefix = requestContext.getResolvedMount().getMatchingIgnoredPrefix();
            if (!StringUtils.isEmpty((String)ignoredPrefix) && ignoredPrefix.equals(requestContext.getResolvedMount().getMount().getVirtualHost().getVirtualHosts().getCmsPreviewPrefix())) {
                CmsSecurityValve.sendError(servletResponse, 403);
                return;
            }
            context.invokeNext();
            return;
        }
        log.debug("Request '{}' is invoked from CMS context. Check whether the SSO handshake is done.", (Object)servletRequest.getRequestURL());
        HttpSession httpSession = servletRequest.getSession(false);
        CmsSessionContext cmsSessionContext2 = cmsSessionContext = httpSession != null ? CmsSessionContext.getContext((HttpSession)httpSession) : null;
        if (httpSession == null || cmsSessionContext == null) {
            CmsContextService cmsContextService = (CmsContextService)HippoServiceRegistry.getService(CmsContextService.class);
            if (cmsContextService == null) {
                log.debug("No CmsContextService available");
                CmsSecurityValve.sendError(servletResponse, 400);
                return;
            }
            String cmsContextServiceId = servletRequest.getParameter("cmsCSID");
            String cmsSessionContextId = servletRequest.getParameter("cmsSCID");
            if (cmsContextServiceId == null || cmsSessionContextId == null) {
                String method = servletRequest.getMethod();
                if (!"GET".equals(method) && !"HEAD".equals(method)) {
                    log.warn("Invalid request to redirect for authentication because request method is '{}' and only 'GET' or 'HEAD' are allowed", (Object)method);
                    CmsSecurityValve.sendError(servletResponse, 401);
                    return;
                }
                log.debug("No CmsSessionContext and/or CmsContextService IDs found. Redirect to the CMS");
                CmsSecurityValve.redirectToCms(servletRequest, servletResponse, requestContext, cmsContextService.getId());
                return;
            }
            if (!cmsContextServiceId.equals(cmsContextService.getId())) {
                log.warn("Cannot authorize request: not coming from this CMS HOST. Redirecting to cms authentication URL to retry.");
                CmsSecurityValve.redirectToCms(servletRequest, servletResponse, requestContext, cmsContextService.getId());
                return;
            }
            if (httpSession == null) {
                httpSession = servletRequest.getSession(true);
            }
            this.cleanupCmsInteractionAttributes(httpSession);
            cmsSessionContext = cmsContextService.attachSessionContext(cmsSessionContextId, httpSession);
            if (cmsSessionContext == null) {
                httpSession.invalidate();
                log.warn("Cannot authorize request: CmsSessionContext not found");
                CmsSecurityValve.sendError(servletResponse, 401);
                return;
            }
        }
        servletRequest.setAttribute("org.hippoecm.hst.container.cms_user_id", (Object)cmsSessionContext.getRepositoryCredentials().getUserID());
        servletRequest.setAttribute("org.hippoecm.hst.container.cms.request.repo.creds", (Object)cmsSessionContext.getRepositoryCredentials());
        HttpSession httpSession2 = httpSession;
        synchronized (httpSession2) {
            Session jcrSession = null;
            try {
                if (CmsSecurityValve.isCmsRestOrPageComposerRequest(servletRequest)) {
                    jcrSession = this.createCmsChannelManagerRestSession(servletRequest);
                } else if (this.sessionSecurityDelegation.sessionSecurityDelegationEnabled()) {
                    jcrSession = this.createCmsPreviewSession(servletRequest);
                }
                if (jcrSession != null) {
                    ((HstMutableRequestContext)requestContext).setSession(jcrSession);
                }
                context.invokeNext();
                if (jcrSession != null && jcrSession.hasPendingChanges()) {
                    log.warn("Request to {} triggered changes in JCR session that were not saved - they will be lost", (Object)servletRequest.getPathInfo());
                }
            }
            catch (LoginException e) {
                log.info("Credentials of CMS user '{}' are no longer valid, resetting its HTTP session and starting the SSO handshake again.", (Object)cmsSessionContext.getRepositoryCredentials().getUserID());
                httpSession.invalidate();
                CmsSecurityValve.redirectToCms(servletRequest, servletResponse, requestContext, null);
                return;
            }
            catch (RepositoryException e) {
                log.warn("RepositoryException : {}", (Object)e.toString());
                throw new ContainerException((Throwable)e);
            }
            finally {
                if (jcrSession != null) {
                    jcrSession.logout();
                }
            }
        }
    }

    private void cleanupCmsInteractionAttributes(HttpSession httpSession) {
        for (String s : this.CMS_INTERACTION_ATTRIBUTES) {
            httpSession.removeAttribute(s);
        }
    }

    private static void sendError(HttpServletResponse servletResponse, int errorCode) throws ContainerException {
        try {
            servletResponse.sendError(errorCode);
        }
        catch (IOException e) {
            throw new ContainerException(String.format("Unable to send unauthorized (%s) response to client", errorCode), (Throwable)e);
        }
    }

    private static void redirectToCms(HttpServletRequest servletRequest, HttpServletResponse servletResponse, HstRequestContext requestContext, String cmsContextServiceId) throws ContainerException {
        if (servletRequest.getParameterMap().containsKey("retry")) {
            CmsSecurityValve.sendError(servletResponse, 409);
            return;
        }
        try {
            String cmsAuthUrl = CmsSecurityValve.createCmsAuthenticationUrl(servletRequest, requestContext, cmsContextServiceId);
            servletResponse.sendRedirect(cmsAuthUrl);
        }
        catch (UnsupportedEncodingException e) {
            log.error("Unable to encode the destination url with UTF8 encoding " + e.getMessage(), (Throwable)e);
            CmsSecurityValve.sendError(servletResponse, 500);
        }
        catch (IOException e) {
            log.error("Something gone wrong so stopping valve invocation fall through: " + e.getMessage(), (Throwable)e);
            CmsSecurityValve.sendError(servletResponse, 500);
        }
    }

    private static String createCmsAuthenticationUrl(HttpServletRequest servletRequest, HstRequestContext requestContext, String cmsContextServiceId) throws ContainerException {
        String farthestRequestUrlPrefix = CmsSecurityValve.getFarthestUrlPrefix(servletRequest);
        String cmsLocation = CmsSecurityValve.getCmsLocationByPrefix(requestContext, farthestRequestUrlPrefix);
        String destinationPath = CmsSecurityValve.createDestinationPath(servletRequest, requestContext);
        StringBuilder authUrl = new StringBuilder(cmsLocation);
        if (!cmsLocation.endsWith("/")) {
            authUrl.append("/");
        }
        authUrl.append("auth?destinationPath=").append(destinationPath);
        if (cmsContextServiceId != null) {
            authUrl.append("&cmsCSID=").append(cmsContextServiceId);
        }
        return authUrl.toString();
    }

    private static String getFarthestUrlPrefix(HttpServletRequest servletRequest) {
        String farthestRequestScheme = HstRequestUtils.getFarthestRequestScheme((HttpServletRequest)servletRequest);
        String farthestRequestHost = HstRequestUtils.getFarthestRequestHost((HttpServletRequest)servletRequest, (boolean)false);
        return farthestRequestScheme + "://" + farthestRequestHost;
    }

    private static String getCmsLocationByPrefix(HstRequestContext requestContext, String prefix) throws ContainerException {
        Mount mount = requestContext.getResolvedMount().getMount();
        List cmsLocations = mount.getCmsLocations();
        for (String cmsLocation : cmsLocations) {
            if (!cmsLocation.startsWith(prefix)) continue;
            return cmsLocation;
        }
        throw new ContainerException("Could not establish a SSO between CMS & site application because no CMS location could be found that starts with '" + prefix + "'");
    }

    private static String createDestinationPath(HttpServletRequest servletRequest, HstRequestContext requestContext) {
        String queryString;
        StringBuilder destinationPath = new StringBuilder();
        destinationPath.append(servletRequest.getRequestURI());
        if (requestContext.getPathSuffix() != null) {
            HstManager hstManager = (HstManager)HstServices.getComponentManager().getComponent(HstManager.class.getName());
            String subPathDelimiter = hstManager.getPathSuffixDelimiter();
            destinationPath.append(subPathDelimiter).append(requestContext.getPathSuffix());
        }
        if ((queryString = servletRequest.getQueryString()) != null) {
            destinationPath.append("?").append(queryString);
        }
        return destinationPath.toString();
    }

    private static boolean isCmsRestOrPageComposerRequest(HttpServletRequest servletRequest) {
        return Boolean.TRUE.equals(servletRequest.getAttribute("org.hippoecm.hst.container.sso_cms_rest_request_context"));
    }

    private Session createCmsChannelManagerRestSession(HttpServletRequest request) throws LoginException, ContainerException {
        long start = System.currentTimeMillis();
        try {
            Credentials credentials = (Credentials)request.getAttribute("org.hippoecm.hst.container.cms.request.repo.creds");
            Session session = this.sessionSecurityDelegation.getDelegatedSession(credentials);
            log.debug("Acquiring cms rest session took '{}' ms.", (Object)(System.currentTimeMillis() - start));
            return session;
        }
        catch (LoginException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ContainerException("Failed to create session based on SSO.", (Throwable)e);
        }
    }

    private Session createCmsPreviewSession(HttpServletRequest request) throws LoginException, ContainerException {
        long start = System.currentTimeMillis();
        Credentials cmsUserCred = (Credentials)request.getAttribute("org.hippoecm.hst.container.cms.request.repo.creds");
        try {
            Session session = this.sessionSecurityDelegation.createPreviewSecurityDelegate(cmsUserCred, false);
            log.debug("Acquiring security delegate session took '{}' ms.", (Object)(System.currentTimeMillis() - start));
            return session;
        }
        catch (LoginException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ContainerException("Failed to create Session based on SSO.", (Throwable)e);
        }
    }
}

