/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.container;

import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import org.apache.commons.io.IOUtils;
import org.hippoecm.hst.core.component.HstRequest;
import org.hippoecm.hst.core.component.HstResponse;
import org.hippoecm.hst.core.component.HstURL;
import org.hippoecm.hst.core.container.AbstractAsynchronousComponentWindowRenderer;
import org.hippoecm.hst.core.container.HstComponentWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class AjaxAsynchronousComponentWindowRenderer
extends AbstractAsynchronousComponentWindowRenderer {
    private static Logger log = LoggerFactory.getLogger(AjaxAsynchronousComponentWindowRenderer.class);
    private static final char RANDOM_CHAR1 = (char)(97 + new Random().nextInt(10));
    private static final char RANDOM_CHAR2 = (char)(RANDOM_CHAR1 + '\u0001');
    private static final char RANDOM_CHAR3 = (char)(RANDOM_CHAR1 + 2);
    private static final String OBFUSCATED_ASYNC_VAR = String.valueOf(RANDOM_CHAR3) + AjaxAsynchronousComponentWindowRenderer.class.hashCode() + "Async";
    private static final String OBFUSCATED_HIPPO_VAR = String.valueOf(RANDOM_CHAR1) + AjaxAsynchronousComponentWindowRenderer.class.hashCode();
    private static final String OBFUSCATED_HIPPO_HST_VAR = OBFUSCATED_HIPPO_VAR + "." + String.valueOf(RANDOM_CHAR2) + AjaxAsynchronousComponentWindowRenderer.class.hashCode();
    private static final String HEAD_SCRIPT_KEY_HINT = AjaxAsynchronousComponentWindowRenderer.class.getName() + ".async";
    private static final String SIMPLE_IO_SCRIPT_RESOURCE_PATH = "simple-io-template.js";
    private static String obfuscatedScript = null;

    public void processWindowBeforeRender(HstComponentWindow window, HstRequest request, HstResponse response) {
        HstURL url = this.createAsyncComponentRenderingURL(request, response);
        Element hiddenDiv = response.createElement("div");
        hiddenDiv.setAttribute("id", url.toString());
        hiddenDiv.setAttribute("class", OBFUSCATED_ASYNC_VAR);
        hiddenDiv.setAttribute("style", "display:none;");
        response.addPreamble(hiddenDiv);
        if (!response.containsHeadElement(HEAD_SCRIPT_KEY_HINT)) {
            Element headScript = response.createElement("script");
            headScript.setAttribute("type", "text/javascript");
            headScript.setTextContent(AjaxAsynchronousComponentWindowRenderer.getIOScript());
            response.addHeadElement(headScript, HEAD_SCRIPT_KEY_HINT);
            Element endBodyScript = response.createElement("script");
            endBodyScript.setAttribute("org.hippoecm.hst.container.head.element.contribution.hint.category", "scripts");
            endBodyScript.setAttribute("type", "text/javascript");
            endBodyScript.setTextContent(OBFUSCATED_HIPPO_HST_VAR + ".AsyncPage.load();");
            response.addHeadElement(endBodyScript, "asyncLoad");
        }
    }

    private static String obfuscateNamespacedFunctions(String ioScriptTemplate) {
        log.debug("creating obfuscated io-script with RANDOM CHAR", (Object)OBFUSCATED_HIPPO_HST_VAR);
        String obfuscated = ioScriptTemplate.replaceAll("Hippo.Hst", OBFUSCATED_HIPPO_HST_VAR);
        obfuscated = obfuscated.replaceAll("Hippo", OBFUSCATED_HIPPO_VAR);
        obfuscated = obfuscated.replaceAll("_async", OBFUSCATED_ASYNC_VAR);
        return obfuscated;
    }

    private static String getIOScript() {
        if (obfuscatedScript != null) {
            return obfuscatedScript;
        }
        String ioScriptTemplate = AjaxAsynchronousComponentWindowRenderer.loadScript();
        obfuscatedScript = AjaxAsynchronousComponentWindowRenderer.obfuscateNamespacedFunctions(ioScriptTemplate);
        return obfuscatedScript;
    }

    private static String loadScript() {
        InputStream input = null;
        try {
            String ioScriptTemplate;
            input = AjaxAsynchronousComponentWindowRenderer.class.getResourceAsStream(SIMPLE_IO_SCRIPT_RESOURCE_PATH);
            if (input == null) {
                log.warn("Could not load simple-io-template.js");
                String string = "";
                return string;
            }
            String string = ioScriptTemplate = IOUtils.toString((InputStream)input, (String)"UTF-8");
            return string;
        }
        catch (IOException e) {
            log.warn("Could not load simple-io-template.js");
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
        return "";
    }
}

