/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.container;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.container.RequestContextProvider;
import org.hippoecm.hst.core.channelmanager.ComponentWindowResponseAppender;
import org.hippoecm.hst.core.component.HstRequest;
import org.hippoecm.hst.core.component.HstRequestImpl;
import org.hippoecm.hst.core.component.HstResponse;
import org.hippoecm.hst.core.component.HstResponseImpl;
import org.hippoecm.hst.core.component.HstResponseState;
import org.hippoecm.hst.core.component.HstURL;
import org.hippoecm.hst.core.container.AbstractBaseOrderableValve;
import org.hippoecm.hst.core.container.AsynchronousComponentWindowRenderer;
import org.hippoecm.hst.core.container.ContainerException;
import org.hippoecm.hst.core.container.HstComponentWindow;
import org.hippoecm.hst.core.container.HstContainerConfig;
import org.hippoecm.hst.core.container.HstContainerURL;
import org.hippoecm.hst.core.container.PageErrorHandler;
import org.hippoecm.hst.core.container.PageErrors;
import org.hippoecm.hst.core.container.ValveContext;
import org.hippoecm.hst.core.request.HstRequestContext;
import org.hippoecm.hst.site.HstServices;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;

public class AggregationValve
extends AbstractBaseOrderableValve {
    private static final String ASYNC_RENDERED_BY_ANCESTOR_FLAG_ATTR_NAME = AggregationValve.class.getName() + ".asyncByAncestor";
    private Map<String, AsynchronousComponentWindowRenderer> asynchronousComponentWindowRendererMap;
    private List<ComponentWindowResponseAppender> componentWindowResponseAppenders;

    public void setAsynchronousComponentWindowRendererMap(Map<String, AsynchronousComponentWindowRenderer> asynchronousComponentWindowRendererMap) {
        this.asynchronousComponentWindowRendererMap = asynchronousComponentWindowRendererMap;
    }

    public void setComponentWindowResponseAppenders(List<ComponentWindowResponseAppender> componentWindowResponseAppenders) {
        this.componentWindowResponseAppenders = componentWindowResponseAppenders;
    }

    @Override
    public void invoke(ValveContext context) throws ContainerException {
        block38: {
            HstComponentWindow errorCodeSendingWindow;
            HstContainerConfig requestContainerConfig;
            boolean redirectedOrForwarded;
            HstComponentWindow[] sortedComponentWindows;
            HstRequestContext requestContext = context.getRequestContext();
            HstContainerURL baseURL = requestContext.getBaseURL();
            String actionWindowReferenceNamespace = baseURL.getActionWindowReferenceNamespace();
            String resourceWindowRef = baseURL.getResourceWindowReferenceNamespace();
            if (actionWindowReferenceNamespace != null || resourceWindowRef != null) {
                context.invokeNext();
                return;
            }
            HttpServletRequest servletRequest = requestContext.getServletRequest();
            HttpServletResponse servletResponse = requestContext.getServletResponse();
            if (servletResponse.isCommitted()) {
                log.warn("Stopping aggregated rendering. The response is already committed.");
                context.invokeNext();
                return;
            }
            HstComponentWindow rootWindow = context.getRootComponentWindow();
            HstComponentWindow rootRenderingWindow = context.getRootComponentRenderingWindow();
            if (rootRenderingWindow == null) {
                rootRenderingWindow = rootWindow;
            }
            if (rootWindow == null) {
                log.warn("Skipping aggregated rendering. Cannot find the root component window for '{}'.", (Object)servletRequest);
                context.invokeNext();
                return;
            }
            HashMap<HstComponentWindow, HstRequest> requestMap = new HashMap<HstComponentWindow, HstRequest>();
            HashMap<HstComponentWindow, HstResponse> responseMap = new HashMap<HstComponentWindow, HstResponse>();
            this.createHstRequestResponseForWindows(rootWindow, rootRenderingWindow, requestContext, (ServletRequest)servletRequest, (ServletResponse)servletResponse, requestMap, responseMap, null, rootWindow == rootRenderingWindow);
            LinkedList<HstComponentWindow> sortedComponentWindowList = new LinkedList<HstComponentWindow>();
            this.sortComponentWindowsByHierarchy(rootWindow, sortedComponentWindowList);
            HstComponentWindow[] sortedComponentRenderingWindows = sortedComponentWindows = sortedComponentWindowList.toArray(new HstComponentWindow[sortedComponentWindowList.size()]);
            if (rootRenderingWindow != rootWindow) {
                LinkedList<HstComponentWindow> sortedComponentRenderingWindowList = new LinkedList<HstComponentWindow>();
                this.sortComponentWindowsByHierarchy(rootRenderingWindow, sortedComponentRenderingWindowList);
                sortedComponentRenderingWindows = sortedComponentRenderingWindowList.toArray(new HstComponentWindow[sortedComponentRenderingWindowList.size()]);
            }
            if (!(redirectedOrForwarded = this.processWindowsPrepareBeforeRender(requestContainerConfig = context.getRequestContainerConfig(), rootWindow, rootRenderingWindow, sortedComponentWindows, requestMap, responseMap))) {
                this.processWindowsBeforeRender(requestContainerConfig, rootWindow, rootRenderingWindow, sortedComponentWindows, requestMap, responseMap);
            }
            String redirectLocation = null;
            for (HstComponentWindow window : sortedComponentWindows) {
                if (window.getResponseState().getRedirectLocation() == null) continue;
                redirectLocation = window.getResponseState().getRedirectLocation();
                break;
            }
            String forwardPathInfo = rootWindow.getResponseState().getForwardPathInfo();
            PageErrors pageErrors = this.getPageErrors(sortedComponentWindows, true);
            if (pageErrors != null) {
                PageErrorHandler.Status handled = this.handleComponentExceptions(pageErrors, requestContainerConfig, rootWindow, (HstRequest)requestMap.get(rootWindow), (HstResponse)responseMap.get(rootWindow));
                if (rootWindow.getResponseState().getRedirectLocation() != null) {
                    redirectLocation = rootWindow.getResponseState().getRedirectLocation();
                }
                if (rootWindow.getResponseState().getForwardPathInfo() != null) {
                    forwardPathInfo = rootWindow.getResponseState().getForwardPathInfo();
                }
                if (handled == PageErrorHandler.Status.HANDLED_TO_STOP && redirectLocation == null && forwardPathInfo == null) {
                    context.invokeNext();
                    return;
                }
            }
            if ((errorCodeSendingWindow = this.findErrorCodeSendingWindow(sortedComponentWindows)) != null) {
                try {
                    int errorCode = errorCodeSendingWindow.getResponseState().getErrorCode();
                    String errorMessage = errorCodeSendingWindow.getResponseState().getErrorMessage();
                    String componentClassName = errorCodeSendingWindow.getComponentName();
                    log.debug("The component window has error status code, {} from {}.", (Object)errorCode, (Object)componentClassName);
                    if (errorMessage != null) {
                        servletResponse.sendError(errorCode, errorMessage);
                        break block38;
                    }
                    servletResponse.sendError(errorCode);
                }
                catch (IOException e) {
                    if (log.isDebugEnabled()) {
                        log.warn("Exception invocation on sendError().", (Throwable)e);
                    } else if (log.isWarnEnabled()) {
                        log.warn("Exception invocation on sendError(). {}", (Object)e.toString());
                    }
                    break block38;
                }
            }
            if (redirectLocation != null) {
                try {
                    for (int i = sortedComponentWindows.length - 1; i >= 0; --i) {
                        HstComponentWindow window = sortedComponentWindows[i];
                        window.getResponseState().flush(true);
                    }
                    boolean permanent = false;
                    if (301 == rootWindow.getResponseState().getStatus()) {
                        permanent = true;
                    }
                    if (redirectLocation.startsWith("http:") || redirectLocation.startsWith("https:")) {
                        this.sendRedirect(servletResponse, redirectLocation, permanent);
                        break block38;
                    }
                    if (redirectLocation.startsWith("/")) {
                        if (this.isAlwaysRedirectLocationToAbsoluteUrl()) {
                            String fullyQualifiedURL = requestContext.getVirtualHost().getBaseURL(servletRequest) + redirectLocation;
                            this.sendRedirect(servletResponse, fullyQualifiedURL, permanent);
                        } else {
                            this.sendRedirect(servletResponse, redirectLocation, permanent);
                        }
                        break block38;
                    }
                    throw new ContainerException("Can only redirect to a context relative path starting with a '/' or to a fully qualified url starting with http: or https: ");
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.warn("Exception during sendRedirect.", (Throwable)e);
                    } else if (log.isWarnEnabled()) {
                        log.warn("Exception during sendRedirect. {}", (Object)e.toString());
                    }
                    break block38;
                }
            }
            if (forwardPathInfo != null) {
                servletRequest.setAttribute("org.hippoecm.hst.container.forward.path_info", (Object)forwardPathInfo);
            } else {
                PageErrorHandler.Status handled;
                this.processWindowsRender(requestContainerConfig, sortedComponentRenderingWindows, requestMap, responseMap);
                pageErrors = this.getPageErrors(sortedComponentWindows, true);
                if (pageErrors == null || (handled = this.handleComponentExceptions(pageErrors, requestContainerConfig, rootWindow, (HstRequest)requestMap.get(rootWindow), (HstResponse)responseMap.get(rootWindow))) == PageErrorHandler.Status.HANDLED_TO_STOP) {
                    // empty if block
                }
                try {
                    boolean isPreviewOrCmsRequest;
                    boolean bl = isPreviewOrCmsRequest = requestContext.isPreview() || requestContext.isCmsRequest();
                    if (rootWindow == rootRenderingWindow && isPreviewOrCmsRequest) {
                        AggregationValve.setNoCacheHeaders(rootWindow.getResponseState());
                        if (requestContext.getResolvedMount().getMount().isVersionInPreviewHeader()) {
                            rootWindow.getResponseState().addHeader("X-HST-VERSION", HstServices.getImplementationVersion());
                        }
                    }
                    rootRenderingWindow.getResponseState().flush();
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.warn("Exception during flushing the response state.", (Throwable)e);
                    }
                    if (!log.isWarnEnabled()) break block38;
                    log.warn("Exception during flushing the response state. {}", (Object)e.toString());
                }
            }
        }
        context.invokeNext();
    }

    private static void setNoCacheHeaders(HstResponseState response) {
        response.setDateHeader("Expires", -1L);
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
    }

    private void sendRedirect(HttpServletResponse servletResponse, String redirectLocation, boolean permanent) throws IOException {
        if (permanent) {
            servletResponse.setStatus(301);
            servletResponse.setHeader("Location", redirectLocation);
        } else {
            servletResponse.sendRedirect(redirectLocation);
        }
    }

    protected void createHstRequestResponseForWindows(HstComponentWindow window, HstComponentWindow rootRenderingWindow, HstRequestContext requestContext, ServletRequest servletRequest, ServletResponse parentResponse, Map<HstComponentWindow, HstRequest> requestMap, Map<HstComponentWindow, HstResponse> responseMap, HstResponse topComponentHstResponse, boolean isComponentWindowRendered) {
        HstRequestImpl request = new HstRequestImpl((HttpServletRequest)servletRequest, requestContext, window, "RENDER_PHASE");
        window.bindResponseState((HttpServletRequest)servletRequest, (HttpServletResponse)parentResponse);
        HstResponse response = isComponentWindowRendered ? new HstResponseImpl((HttpServletRequest)servletRequest, (HttpServletResponse)parentResponse, requestContext, window, topComponentHstResponse) : new NoopHstResponseImpl();
        if (topComponentHstResponse == null && isComponentWindowRendered) {
            topComponentHstResponse = response;
        }
        requestMap.put(window, request);
        responseMap.put(window, response);
        Map childWindowMap = window.getChildWindowMap();
        if (childWindowMap != null) {
            for (Map.Entry entry : childWindowMap.entrySet()) {
                Object responseForChild = isComponentWindowRendered ? response : parentResponse;
                boolean isChildComponentWindowRendered = isComponentWindowRendered || entry.getValue() == rootRenderingWindow;
                this.createHstRequestResponseForWindows((HstComponentWindow)entry.getValue(), rootRenderingWindow, requestContext, servletRequest, (ServletResponse)responseForChild, requestMap, responseMap, topComponentHstResponse, isChildComponentWindowRendered);
            }
        }
    }

    protected void sortComponentWindowsByHierarchy(HstComponentWindow window, List<HstComponentWindow> sortedWindowList) {
        sortedWindowList.add(window);
        Map childWindowMap = window.getChildWindowMap();
        if (childWindowMap != null) {
            for (Map.Entry entry : childWindowMap.entrySet()) {
                this.sortComponentWindowsByHierarchy((HstComponentWindow)entry.getValue(), sortedWindowList);
            }
        }
    }

    protected boolean processWindowsPrepareBeforeRender(HstContainerConfig requestContainerConfig, HstComponentWindow rootWindow, HstComponentWindow rootRenderingWindow, HstComponentWindow[] sortedComponentWindows, Map<HstComponentWindow, HstRequest> requestMap, Map<HstComponentWindow, HstResponse> responseMap) throws ContainerException {
        boolean redirectedOrForwarded = false;
        for (HstComponentWindow window : sortedComponentWindows) {
            HstRequest request = requestMap.get(window);
            HstResponse response = responseMap.get(window);
            if (window.isVisible() && !this.isAsync(window, request)) {
                this.getComponentInvoker().invokePrepareBeforeRender(requestContainerConfig, (ServletRequest)request, (ServletResponse)response);
            }
            if (window.getResponseState().getRedirectLocation() != null) {
                redirectedOrForwarded = true;
                break;
            }
            if (rootWindow.getResponseState().getForwardPathInfo() == null) continue;
            redirectedOrForwarded = true;
            break;
        }
        return redirectedOrForwarded;
    }

    protected void processWindowsBeforeRender(HstContainerConfig requestContainerConfig, HstComponentWindow rootWindow, HstComponentWindow rootRenderingWindow, HstComponentWindow[] sortedComponentWindows, Map<HstComponentWindow, HstRequest> requestMap, Map<HstComponentWindow, HstResponse> responseMap) throws ContainerException {
        for (HstComponentWindow window : sortedComponentWindows) {
            HstRequest request = requestMap.get(window);
            HstResponse response = responseMap.get(window);
            if (window.isVisible()) {
                if (this.isAsync(window, request)) {
                    if (request.getAttribute(ASYNC_RENDERED_BY_ANCESTOR_FLAG_ATTR_NAME) == Boolean.TRUE) continue;
                    AsynchronousComponentWindowRenderer asynchronousComponentWindowRenderer = this.getAsynchronousComponentWindowRenderer(window);
                    if (asynchronousComponentWindowRenderer != null) {
                        asynchronousComponentWindowRenderer.processWindowBeforeRender(window, request, response);
                    } else {
                        log.error("Asynchronous component window rendering skipped! No asynchronousComponentWindowRenderer found for mode, '{}'.", (Object)this.defaultAsynchronousComponentWindowRenderingMode);
                    }
                } else {
                    this.getComponentInvoker().invokeBeforeRender(requestContainerConfig, (ServletRequest)request, (ServletResponse)response);
                }
            }
            if (window.getResponseState().getRedirectLocation() != null || rootWindow.getResponseState().getForwardPathInfo() != null) break;
            for (ComponentWindowResponseAppender componentWindowResponseAppender : this.componentWindowResponseAppenders) {
                componentWindowResponseAppender.process(rootWindow, rootRenderingWindow, window, request, response);
            }
        }
    }

    protected void processWindowsRender(HstContainerConfig requestContainerConfig, HstComponentWindow[] sortedComponentWindows, Map<HstComponentWindow, HstRequest> requestMap, Map<HstComponentWindow, HstResponse> responseMap) throws ContainerException {
        for (int i = sortedComponentWindows.length - 1; i >= 0; --i) {
            HstRequest request;
            HstComponentWindow window = sortedComponentWindows[i];
            if (!window.isVisible() || this.isAsync(window, request = requestMap.get(window))) continue;
            HstResponse response = responseMap.get(window);
            this.getComponentInvoker().invokeRender(requestContainerConfig, (ServletRequest)request, (ServletResponse)response);
            this.logPossibleWaste(responseMap, window);
        }
    }

    private void logPossibleWaste(Map<HstComponentWindow, HstResponse> responseMap, HstComponentWindow window) {
        if (!log.isWarnEnabled()) {
            return;
        }
        if (window.getChildWindowMap() == null) {
            return;
        }
        for (HstComponentWindow childWindow : window.getChildWindowMap().values()) {
            HstResponse childResponse = responseMap.get(childWindow);
            if (!(childResponse instanceof HstResponseImpl)) continue;
            HstResponseImpl childResponseImpl = (HstResponseImpl)childResponse;
            if (childWindow.getResponseState().isFlushed() || childWindow.getComponentInfo().isSuppressWasteMessage() || !StringUtils.isNotBlank((String)this.getRenderer(childWindow, childResponseImpl))) continue;
            if (childResponse.getHeadElements() == null || childResponse.getHeadElements().isEmpty()) {
                log.warn("POSSIBLE WASTE DETECTED in request '{}' : Component '{}' gets rendered but never adds anything to the response. Its renderer '{}' is never flushed to a parent component. This might be waste you are not aware of. If it is on purpose, for example because the component does only some processing that does not involve direct response contribution, you can mark the component with '{} = true'.", new Object[]{RequestContextProvider.get().getServletRequest(), childWindow.getComponent().getComponentConfiguration().getCanonicalPath(), this.getRenderer(childWindow, childResponseImpl), "hst:suppresswastemessage"});
                continue;
            }
            log.info("POSSIBLE WASTE DETECTED  in request '{}' : Component '{}' gets rendered but except for some head element(s) adds nothing to the response. Its renderer '{}' is never flushed to a parent component. This component might be waste. If it is on purpose, for example because the component does only some processing that does not involve direct response contribution, you can mark the component with '{} = true'.", new Object[]{RequestContextProvider.get().getServletRequest(), childWindow.getComponent().getComponentConfiguration().getCanonicalPath(), this.getRenderer(childWindow, childResponseImpl), "hst:suppresswastemessage"});
        }
    }

    private String getRenderer(HstComponentWindow window, HstResponseImpl hstResponse) {
        String dispatchUrl = hstResponse.getRenderPath();
        if (StringUtils.isNotBlank((String)dispatchUrl)) {
            return dispatchUrl;
        }
        dispatchUrl = window.getRenderPath();
        if (StringUtils.isNotBlank((String)dispatchUrl)) {
            return dispatchUrl;
        }
        return window.getNamedRenderer();
    }

    private boolean isAsync(HstComponentWindow window, HstRequest request) {
        if (request.getRequestContext().isCmsRequest()) {
            return false;
        }
        if (request.getRequestContext().getBaseURL().getComponentRenderingWindowReferenceNamespace() != null) {
            return false;
        }
        for (HstComponentWindow parent = window.getParentWindow(); parent != null; parent = parent.getParentWindow()) {
            if (!parent.getComponentInfo().isAsync()) continue;
            request.setAttribute(ASYNC_RENDERED_BY_ANCESTOR_FLAG_ATTR_NAME, (Object)Boolean.TRUE);
            return true;
        }
        return window.getComponentInfo().isAsync();
    }

    private AsynchronousComponentWindowRenderer getAsynchronousComponentWindowRenderer(HstComponentWindow window) {
        AsynchronousComponentWindowRenderer asynchronousComponentWindowRenderer = null;
        if (this.asynchronousComponentWindowRendererMap != null) {
            String asyncMode = window.getComponentInfo().getAsyncMode();
            if (StringUtils.isNotEmpty((String)asyncMode) && (asynchronousComponentWindowRenderer = this.asynchronousComponentWindowRendererMap.get(asyncMode)) == null) {
                log.warn("Unsupported asyncMode '{}' found for '{}'. Using default asyncMode '{}' instead. Supported asyncModes are '{}'.", (Object[])new String[]{asyncMode, window.getComponentInfo().getId(), this.defaultAsynchronousComponentWindowRenderingMode, this.asynchronousComponentWindowRendererMap.keySet().toString()});
            }
            if (asynchronousComponentWindowRenderer == null) {
                asynchronousComponentWindowRenderer = this.asynchronousComponentWindowRendererMap.get(this.defaultAsynchronousComponentWindowRenderingMode);
            }
        }
        return asynchronousComponentWindowRenderer;
    }

    private class NoopHstResponseImpl
    implements HstResponse {
        private NoopHstResponseImpl() {
        }

        public boolean isRendererSkipped() {
            return true;
        }

        public void addCookie(Cookie cookie) {
        }

        public void addHeadElement(Element element, String keyHint) {
        }

        public void addPreamble(Comment comment) {
        }

        public void addPreamble(Element element) {
        }

        public void addEpilogue(Comment comment) {
        }

        public boolean containsHeadElement(String keyHint) {
            return false;
        }

        public void addProcessedHeadElement(Element headElement) {
        }

        public HstURL createActionURL() {
            return null;
        }

        public Comment createComment(String comment) {
            return null;
        }

        public HstURL createComponentRenderingURL() {
            return null;
        }

        public Element createElement(String tagName) {
            return null;
        }

        public HstURL createNavigationalURL(String pathInfo) {
            return null;
        }

        public HstURL createRenderURL() {
            return null;
        }

        public HstURL createResourceURL() {
            return null;
        }

        public HstURL createResourceURL(String referenceNamespace) {
            return null;
        }

        public void flushChildContent(String name) throws IOException {
        }

        public void flushChildContent(String name, Writer writer) throws IOException {
        }

        public void forward(String pathInfo) throws IOException {
        }

        public List<String> getChildContentNames() {
            return null;
        }

        public List<Element> getHeadElements() {
            return null;
        }

        public String getNamespace() {
            return null;
        }

        public Element getWrapperElement() {
            return null;
        }

        public void sendError(int sc, String msg) throws IOException {
        }

        public void sendError(int sc) throws IOException {
        }

        public void sendRedirect(String location) throws IOException {
        }

        public void setRenderParameter(String key, String value) {
        }

        public void setRenderParameter(String key, String[] values) {
        }

        public void setRenderParameters(Map<String, String[]> parameters) {
        }

        public void setRenderPath(String renderPath) {
        }

        public void setServeResourcePath(String serveResourcePath) {
        }

        public void setStatus(int sc) {
        }

        public void setWrapperElement(Element element) {
        }

        public void addDateHeader(String name, long date) {
        }

        public void addHeader(String name, String value) {
        }

        public void addIntHeader(String name, int value) {
        }

        public boolean containsHeader(String name) {
            return false;
        }

        public String encodeRedirectURL(String url) {
            return null;
        }

        public String encodeRedirectUrl(String url) {
            return null;
        }

        public String encodeURL(String url) {
            return null;
        }

        public String encodeUrl(String url) {
            return null;
        }

        public void setDateHeader(String name, long date) {
        }

        public void setHeader(String name, String value) {
        }

        public void setIntHeader(String name, int value) {
        }

        public void setStatus(int sc, String sm) {
        }

        public void flushBuffer() throws IOException {
        }

        public int getBufferSize() {
            return 0;
        }

        public String getCharacterEncoding() {
            return null;
        }

        public String getContentType() {
            return null;
        }

        public Locale getLocale() {
            return null;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return null;
        }

        public PrintWriter getWriter() throws IOException {
            return null;
        }

        public boolean isCommitted() {
            return false;
        }

        public void reset() {
        }

        public void resetBuffer() {
        }

        public void setBufferSize(int size) {
        }

        public void setCharacterEncoding(String charset) {
        }

        public void setContentLength(int len) {
        }

        public void setContentType(String type) {
        }

        public void setLocale(Locale loc) {
        }

        public int getStatus() {
            return 200;
        }

        public String getHeader(String name) {
            return null;
        }

        public Collection<String> getHeaders(String name) {
            return Collections.emptyList();
        }

        public Collection<String> getHeaderNames() {
            return Collections.emptyList();
        }
    }
}

