/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.container;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.core.component.HstRequestImpl;
import org.hippoecm.hst.core.component.HstResponseImpl;
import org.hippoecm.hst.core.component.HstResponseState;
import org.hippoecm.hst.core.container.AbstractBaseOrderableValve;
import org.hippoecm.hst.core.container.ContainerException;
import org.hippoecm.hst.core.container.HstComponentWindow;
import org.hippoecm.hst.core.container.HstContainerURL;
import org.hippoecm.hst.core.container.HstContainerURLProvider;
import org.hippoecm.hst.core.container.PageErrorHandler;
import org.hippoecm.hst.core.container.PageErrors;
import org.hippoecm.hst.core.container.ValveContext;
import org.hippoecm.hst.core.request.HstRequestContext;

public class ActionValve
extends AbstractBaseOrderableValve {
    @Override
    public void invoke(ValveContext context) throws ContainerException {
        block26: {
            HstRequestContext requestContext = context.getRequestContext();
            HstContainerURL baseURL = requestContext.getBaseURL();
            String actionWindowReferenceNamespace = baseURL.getActionWindowReferenceNamespace();
            if (actionWindowReferenceNamespace == null) {
                context.invokeNext();
                return;
            }
            HttpServletRequest servletRequest = context.getServletRequest();
            HttpServletResponse servletResponse = context.getServletResponse();
            HstComponentWindow window = context.getRootComponentWindow();
            window.bindResponseState(servletRequest, servletResponse);
            HstRequestImpl request = new HstRequestImpl(servletRequest, requestContext, window, "ACTION_PHASE");
            HstResponseImpl response = new HstResponseImpl(servletRequest, servletResponse, requestContext, window, null);
            this.getComponentInvoker().invokeAction(context.getRequestContainerConfig(), (ServletRequest)request, (ServletResponse)response);
            HstResponseState responseState = window.getResponseState();
            PageErrors pageErrors = this.getPageErrors(new HstComponentWindow[]{window}, true);
            if (pageErrors != null) {
                PageErrorHandler.Status handled = this.handleComponentExceptions(pageErrors, context.getRequestContainerConfig(), window, request, response);
                String location = responseState.getRedirectLocation();
                if (handled == PageErrorHandler.Status.HANDLED_TO_STOP && location == null) {
                    return;
                }
            }
            Map<String, Object> renderParameters = response.getRenderParameters();
            response.setRenderParameters(null);
            if (renderParameters == null) {
                renderParameters = Collections.emptyMap();
            }
            String referenceNamespace = window.getReferenceNamespace();
            if (this.getUrlFactory().isReferenceNamespaceIgnored()) {
                referenceNamespace = "";
            }
            HstContainerURLProvider urlProvider = requestContext.getURLFactory().getContainerURLProvider();
            urlProvider.mergeParameters(baseURL, referenceNamespace, renderParameters);
            if (responseState.getErrorCode() > 0) {
                try {
                    int errorCode = responseState.getErrorCode();
                    String errorMessage = responseState.getErrorMessage();
                    String componentClassName = window.getComponentName();
                    log.debug("The action window has error status code: {} - {}", (Object)errorCode, (Object)componentClassName);
                    if (errorMessage != null) {
                        servletResponse.sendError(errorCode, errorMessage);
                        break block26;
                    }
                    servletResponse.sendError(errorCode);
                }
                catch (IOException e) {
                    if (log.isDebugEnabled()) {
                        log.warn("Exception invocation on sendError().", (Throwable)e);
                    } else if (log.isWarnEnabled()) {
                        log.warn("Exception invocation on sendError().");
                    }
                    break block26;
                }
            }
            if (responseState.getRedirectLocation() == null) {
                try {
                    if (baseURL.getActionParameterMap() != null) {
                        baseURL.getActionParameterMap().clear();
                    }
                    baseURL.setActionWindowReferenceNamespace(null);
                    responseState.sendRedirect(urlProvider.toURLString(baseURL, requestContext, null));
                }
                catch (UnsupportedEncodingException e) {
                    throw new ContainerException((Throwable)e);
                }
                catch (IOException e) {
                    throw new ContainerException((Throwable)e);
                }
            }
            try {
                responseState.flush();
                String location = responseState.getRedirectLocation();
                if (StringUtils.isEmpty((String)location)) {
                    location = "/";
                }
                if (location.startsWith("?")) {
                    location = "/" + location;
                }
                if (location.startsWith("http:") || location.startsWith("https:")) {
                    servletResponse.sendRedirect(location);
                } else {
                    if (!location.startsWith("/")) {
                        throw new ContainerException("Can only redirect to a context relative path starting with a '/'.");
                    }
                    if (this.isAlwaysRedirectLocationToAbsoluteUrl()) {
                        String absoluteRedirectUrl = requestContext.getVirtualHost().getBaseURL(servletRequest) + location;
                        servletResponse.sendRedirect(absoluteRedirectUrl);
                    } else {
                        servletResponse.sendRedirect(location);
                    }
                }
            }
            catch (IOException e) {
                log.warn("Unexpected exception during redirect to " + responseState.getRedirectLocation(), (Throwable)e);
            }
        }
    }
}

