/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.container;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.ehcache.constructs.web.GenericResponseWrapper;
import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.cache.ForwardPlaceHolderHstPageInfo;
import org.hippoecm.hst.cache.HstPageInfo;
import org.hippoecm.hst.cache.UncacheableHstPageInfo;
import org.hippoecm.hst.configuration.components.DelegatingHstComponentInfo;
import org.hippoecm.hst.configuration.components.HstComponentInfo;
import org.hippoecm.hst.configuration.hosting.Mount;
import org.hippoecm.hst.configuration.model.HstManager;
import org.hippoecm.hst.container.valves.AbstractOrderableValve;
import org.hippoecm.hst.content.tool.ContentBeansTool;
import org.hippoecm.hst.core.component.HstComponentException;
import org.hippoecm.hst.core.component.HstRequest;
import org.hippoecm.hst.core.component.HstResponse;
import org.hippoecm.hst.core.component.HstURLFactory;
import org.hippoecm.hst.core.container.ContainerConfiguration;
import org.hippoecm.hst.core.container.ContainerException;
import org.hippoecm.hst.core.container.DefaultPageErrors;
import org.hippoecm.hst.core.container.HstComponentFactory;
import org.hippoecm.hst.core.container.HstComponentInvoker;
import org.hippoecm.hst.core.container.HstComponentWindow;
import org.hippoecm.hst.core.container.HstComponentWindowFactory;
import org.hippoecm.hst.core.container.HstContainerConfig;
import org.hippoecm.hst.core.container.HstContainerURL;
import org.hippoecm.hst.core.container.PageErrorHandler;
import org.hippoecm.hst.core.container.PageErrors;
import org.hippoecm.hst.core.container.PageInfoRenderingValve;
import org.hippoecm.hst.core.container.Valve;
import org.hippoecm.hst.core.container.ValveContext;
import org.hippoecm.hst.core.internal.HstMutableRequestContext;
import org.hippoecm.hst.core.internal.HstRequestContextComponent;
import org.hippoecm.hst.core.linking.HstLinkCreator;
import org.hippoecm.hst.core.request.HstRequestContext;
import org.hippoecm.hst.core.request.HstSiteMapMatcher;
import org.hippoecm.hst.core.request.ResolvedSiteMapItem;
import org.hippoecm.hst.core.search.HstQueryManagerFactory;
import org.hippoecm.hst.core.sitemenu.HstSiteMenusManager;
import org.hippoecm.hst.resourcebundle.ResourceBundleRegistry;
import org.hippoecm.hst.util.DefaultKeyValue;
import org.hippoecm.hst.util.KeyValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseOrderableValve
extends AbstractOrderableValve
implements Valve {
    protected static final Logger log = LoggerFactory.getLogger(AbstractBaseOrderableValve.class);
    private static final String PAGE_INFO_CACHEABLE = PageInfoRenderingValve.class.getName() + ".pageInfoCacheable";
    protected ContainerConfiguration containerConfiguration;
    protected HstManager hstManager;
    protected HstSiteMapMatcher siteMapMatcher;
    protected HstRequestContextComponent requestContextComponent;
    protected HstComponentFactory componentFactory;
    protected HstComponentWindowFactory componentWindowFactory;
    protected HstComponentInvoker componentInvoker;
    protected HstURLFactory urlFactory;
    protected HstLinkCreator linkCreator;
    protected HstSiteMenusManager siteMenusManager;
    protected HstQueryManagerFactory hstQueryManagerFactory;
    protected PageErrorHandler defaultPageErrorHandler;
    protected ResourceBundleRegistry resourceBundleRegistry;
    protected ContentBeansTool contentBeansTool;
    protected boolean cachingObjectConverter = true;
    protected boolean alwaysRedirectLocationToAbsoluteUrl = true;
    protected String defaultAsynchronousComponentWindowRenderingMode = "ajax";

    public ContainerConfiguration getContainerConfiguration() {
        return this.containerConfiguration;
    }

    public void setContainerConfiguration(ContainerConfiguration containerConfiguration) {
        this.containerConfiguration = containerConfiguration;
    }

    public HstManager getHstManager() {
        return this.hstManager;
    }

    public void setHstManager(HstManager hstManager) {
        this.hstManager = hstManager;
    }

    public HstSiteMapMatcher getSiteMapMatcher() {
        return this.siteMapMatcher;
    }

    public void setSiteMapMatcher(HstSiteMapMatcher siteMapMatcher) {
        this.siteMapMatcher = siteMapMatcher;
    }

    public HstRequestContextComponent getRequestContextComponent() {
        return this.requestContextComponent;
    }

    public void setRequestContextComponent(HstRequestContextComponent requestContextComponent) {
        this.requestContextComponent = requestContextComponent;
    }

    public HstComponentFactory getComponentFactory() {
        return this.componentFactory;
    }

    public void setComponentFactory(HstComponentFactory componentFactory) {
        this.componentFactory = componentFactory;
    }

    public HstComponentWindowFactory getComponentWindowFactory() {
        return this.componentWindowFactory;
    }

    public void setComponentWindowFactory(HstComponentWindowFactory componentWindowFactory) {
        this.componentWindowFactory = componentWindowFactory;
    }

    public HstComponentInvoker getComponentInvoker() {
        return this.componentInvoker;
    }

    public void setComponentInvoker(HstComponentInvoker componentInvoker) {
        this.componentInvoker = componentInvoker;
    }

    public HstURLFactory getUrlFactory() {
        return this.urlFactory;
    }

    public void setUrlFactory(HstURLFactory urlFactory) {
        this.urlFactory = urlFactory;
    }

    public HstLinkCreator getLinkCreator() {
        return this.linkCreator;
    }

    public void setLinkCreator(HstLinkCreator linkCreator) {
        this.linkCreator = linkCreator;
    }

    public void setSiteMenusManager(HstSiteMenusManager siteMenusManager) {
        this.siteMenusManager = siteMenusManager;
    }

    public HstSiteMenusManager getHstSiteMenusManager() {
        return this.siteMenusManager;
    }

    public HstQueryManagerFactory getHstQueryManagerFactory() {
        return this.hstQueryManagerFactory;
    }

    public void setHstQueryManagerFactory(HstQueryManagerFactory hstQueryManagerFactory) {
        this.hstQueryManagerFactory = hstQueryManagerFactory;
    }

    public PageErrorHandler getDefaultPageErrorHandler() {
        return this.defaultPageErrorHandler;
    }

    public void setDefaultPageErrorHandler(PageErrorHandler defaultPageErrorHandler) {
        this.defaultPageErrorHandler = defaultPageErrorHandler;
    }

    public ResourceBundleRegistry getResourceBundleRegistry() {
        return this.resourceBundleRegistry;
    }

    public void setResourceBundleRegistry(ResourceBundleRegistry resourceBundleRegistry) {
        this.resourceBundleRegistry = resourceBundleRegistry;
    }

    public ContentBeansTool getContentBeansTool() {
        return this.contentBeansTool;
    }

    public void setContentBeansTool(ContentBeansTool contentBeansTool) {
        this.contentBeansTool = contentBeansTool;
    }

    public boolean isCachingObjectConverter() {
        return this.cachingObjectConverter;
    }

    public void setCachingObjectConverter(boolean cachingObjectConverter) {
        this.cachingObjectConverter = cachingObjectConverter;
    }

    public abstract void invoke(ValveContext var1) throws ContainerException;

    public void initialize() throws ContainerException {
    }

    public void destroy() {
    }

    public boolean isAlwaysRedirectLocationToAbsoluteUrl() {
        return this.alwaysRedirectLocationToAbsoluteUrl;
    }

    public void setAlwaysRedirectLocationToAbsoluteUrl(boolean alwaysRedirectLocationToAbsoluteUrl) {
        this.alwaysRedirectLocationToAbsoluteUrl = alwaysRedirectLocationToAbsoluteUrl;
    }

    public void setDefaultAsynchronousComponentWindowRenderingMode(String defaultAsynchronousComponentWindowRenderingMode) {
        this.defaultAsynchronousComponentWindowRenderingMode = StringUtils.defaultIfEmpty((String)defaultAsynchronousComponentWindowRenderingMode, (String)"ajax");
    }

    protected HstComponentWindow findComponentWindow(HstComponentWindow rootWindow, String windowReferenceNamespace) {
        HstComponentWindow componentWindow = null;
        String rootReferenceNamespace = rootWindow.getReferenceNamespace();
        if (rootReferenceNamespace.equals(windowReferenceNamespace)) {
            componentWindow = rootWindow;
        } else {
            int index;
            String[] rootReferenceNamespaces = rootReferenceNamespace.split(this.getComponentWindowFactory().getReferenceNameSeparator());
            String[] referenceNamespaces = windowReferenceNamespace.split(this.getComponentWindowFactory().getReferenceNameSeparator());
            for (index = 0; index < rootReferenceNamespaces.length && index < referenceNamespaces.length && rootReferenceNamespaces[index].equals(referenceNamespaces[index]); ++index) {
            }
            if (index < referenceNamespaces.length) {
                HstComponentWindow tempWindow;
                for (tempWindow = rootWindow; index < referenceNamespaces.length && tempWindow != null; tempWindow = tempWindow.getChildWindowByReferenceName(referenceNamespaces[index]), ++index) {
                }
                if (index == referenceNamespaces.length) {
                    componentWindow = tempWindow;
                }
            }
        }
        return componentWindow;
    }

    protected HstComponentWindow findErrorCodeSendingWindow(HstComponentWindow[] sortedComponentWindows) {
        for (HstComponentWindow window : sortedComponentWindows) {
            if (window.getResponseState().getErrorCode() <= 0) continue;
            return window;
        }
        return null;
    }

    protected PageErrors getPageErrors(HstComponentWindow[] sortedComponentWindows, boolean clearExceptions) {
        ArrayList<DefaultKeyValue> componentExceptions = null;
        for (HstComponentWindow window : sortedComponentWindows) {
            if (!window.hasComponentExceptions()) continue;
            if (componentExceptions == null) {
                componentExceptions = new ArrayList<DefaultKeyValue>();
            }
            DelegatingHstComponentInfo componentInfo = new DelegatingHstComponentInfo(window.getComponentInfo(), window.getComponentName());
            DefaultKeyValue pair = new DefaultKeyValue((Object)componentInfo, new ArrayList(window.getComponentExceptions()));
            componentExceptions.add(pair);
            if (!clearExceptions) continue;
            window.clearComponentExceptions();
        }
        if (componentExceptions != null && !componentExceptions.isEmpty()) {
            return new DefaultPageErrors((List<KeyValue<HstComponentInfo, Collection<HstComponentException>>>)componentExceptions);
        }
        return null;
    }

    protected PageErrorHandler.Status handleComponentExceptions(PageErrors pageErrors, HstContainerConfig requestContainerConfig, HstComponentWindow window, HstRequest hstRequest, HstResponse hstResponse) {
        PageErrorHandler pageErrorHandler;
        block15: {
            if (!pageErrors.isEmpty()) {
                HttpServletRequest request = hstRequest.getRequestContext().getServletRequest();
                log.warn("Component exception(s) found in page request, '{}'.", (Object)request);
            }
            if ((pageErrorHandler = (PageErrorHandler)hstRequest.getAttribute("org.hippoecm.hst.core.container.custom.errorhandler")) == null) {
                String pageErrorHandlerClassName = window.getPageErrorHandlerClassName();
                if (pageErrorHandlerClassName == null) {
                    pageErrorHandlerClassName = window.getParameter("org.hippoecm.hst.core.container.custom.errorhandler");
                }
                while (pageErrorHandlerClassName == null && window.getParentWindow() != null) {
                    pageErrorHandlerClassName = (window = window.getParentWindow()).getPageErrorHandlerClassName();
                    if (pageErrorHandlerClassName != null) continue;
                    pageErrorHandlerClassName = window.getParameter("org.hippoecm.hst.core.container.custom.errorhandler");
                }
                if (pageErrorHandlerClassName != null) {
                    try {
                        pageErrorHandler = (PageErrorHandler)this.getComponentFactory().getObjectInstance(requestContainerConfig, pageErrorHandlerClassName);
                    }
                    catch (Exception e) {
                        if (log.isDebugEnabled()) {
                            log.warn("Failed to get object of " + pageErrorHandlerClassName, (Throwable)e);
                        }
                        if (!log.isWarnEnabled()) break block15;
                        log.warn("Failed to get object of {}. {}", (Object)pageErrorHandlerClassName, (Object)e.toString());
                    }
                }
            }
        }
        if (pageErrorHandler == null) {
            pageErrorHandler = this.defaultPageErrorHandler;
        }
        if (pageErrorHandler == null) {
            return PageErrorHandler.Status.NOT_HANDLED;
        }
        try {
            return pageErrorHandler.handleComponentExceptions(pageErrors, hstRequest, hstResponse);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.warn("Exception during custom error handling.", (Throwable)e);
            } else if (log.isWarnEnabled()) {
                log.warn("Exception during custom error handling. {}", (Object)e.toString());
            }
            return PageErrorHandler.Status.HANDLED_BUT_CONTINUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HstPageInfo createHstPageInfoByInvokingNextValve(ValveContext context, long timeToLiveSeconds) throws Exception {
        HstRequestContext requestContext = context.getRequestContext();
        HttpServletResponse nonWrappedReponse = requestContext.getServletResponse();
        try {
            ByteArrayOutputStream outstr = new ByteArrayOutputStream(4096);
            GenericResponseWrapper responseWrapper = new GenericResponseWrapper(nonWrappedReponse, (OutputStream)outstr);
            ((HstMutableRequestContext)requestContext).setServletResponse((HttpServletResponse)responseWrapper);
            context.invokeNext();
            responseWrapper.flush();
            if (context.getServletRequest().getAttribute("org.hippoecm.hst.container.forward.path_info") != null) {
                String forwardPathInfo = (String)context.getServletRequest().getAttribute("org.hippoecm.hst.container.forward.path_info");
                ForwardPlaceHolderHstPageInfo forwardPlaceHolderHstPageInfo = new ForwardPlaceHolderHstPageInfo(forwardPathInfo);
                return forwardPlaceHolderHstPageInfo;
            }
            if (responseWrapper.getCookies() != null && !responseWrapper.getCookies().isEmpty()) {
                log.info("Response for '{}' contain cookies that are set after the page caching valve: Response won't be cached. Better to mark the hst component that sets cookies as uncacheable or load it asynchronous.", (Object)context.getServletRequest());
                UncacheableHstPageInfo forwardPathInfo = new UncacheableHstPageInfo(responseWrapper.getStatus(), responseWrapper.getContentType(), responseWrapper.getCookies(), outstr.toByteArray(), responseWrapper.getCharacterEncoding(), timeToLiveSeconds, responseWrapper.getAllHeaders());
                return forwardPathInfo;
            }
            String contentType = responseWrapper.getContentType();
            HstPageInfo hstPageInfo = new HstPageInfo(responseWrapper.getStatus(), contentType, responseWrapper.getCookies(), outstr.toByteArray(), responseWrapper.getCharacterEncoding(), timeToLiveSeconds, responseWrapper.getAllHeaders());
            return hstPageInfo;
        }
        finally {
            ((HstMutableRequestContext)requestContext).setServletResponse(nonWrappedReponse);
        }
    }

    protected boolean isRequestCacheable(ValveContext context) throws ContainerException {
        HttpServletRequest servletRequest = context.getServletRequest();
        if (servletRequest.getAttribute(PAGE_INFO_CACHEABLE) != null) {
            return (Boolean)servletRequest.getAttribute(PAGE_INFO_CACHEABLE);
        }
        boolean requestCacheable = this.isRequestCacheable(context.getRequestContext(), context);
        servletRequest.setAttribute(PAGE_INFO_CACHEABLE, (Object)requestCacheable);
        return requestCacheable;
    }

    private boolean isRequestCacheable(HstRequestContext requestContext, ValveContext context) throws ContainerException {
        HttpServletRequest request = requestContext.getServletRequest();
        String method = request.getMethod();
        if (!"GET".equals(method)) {
            context.getPageCacheContext().markUncacheable("Only GET requests are cacheable. Skipping it because the request method is not a GET.");
            log.debug("Only GET requests are cacheable. Skipping it because the request method is '{}'.", (Object)method);
            return false;
        }
        HstContainerURL baseURL = requestContext.getBaseURL();
        String actionWindowReferenceNamespace = baseURL.getActionWindowReferenceNamespace();
        if (actionWindowReferenceNamespace != null) {
            context.getPageCacheContext().markUncacheable("Action URLs are not cacheable");
            log.debug("'{}' is not cacheable because the url is action url.", (Object)request);
            return false;
        }
        String resourceWindowRef = baseURL.getResourceWindowReferenceNamespace();
        if (resourceWindowRef != null) {
            context.getPageCacheContext().markUncacheable("Resource URLs are not cacheable");
            log.debug("'{}' is not cacheable because the url is resource url.", (Object)request);
            return false;
        }
        if (!context.getPageCacheContext().isCacheable()) {
            log.debug("'{}' is not cacheable because PageCacheContext was already marked to not cache this request: {} ", (Object)request, (Object)context.getPageCacheContext().getReasonsUncacheable());
            return false;
        }
        if (requestContext.isCmsRequest()) {
            context.getPageCacheContext().markUncacheable("CMS requests are not cacheable");
            log.debug("'{}' is not cacheable because request is cms request", (Object)request);
            return false;
        }
        Mount mount = requestContext.getResolvedMount().getMount();
        if (mount.isPreview()) {
            context.getPageCacheContext().markUncacheable("Preview requests are not cacheable");
            log.debug("'{}' is not cacheable because request is preview request", (Object)request);
            return false;
        }
        ResolvedSiteMapItem resolvedSitemapItem = requestContext.getResolvedSiteMapItem();
        if (resolvedSitemapItem != null) {
            if (!this.isSiteMapItemAndComponentConfigCacheable(resolvedSitemapItem, context)) {
                context.getPageCacheContext().markUncacheable("Sitemap or component configuration indicated request is not cacheable");
                return false;
            }
        } else if (!mount.isCacheable()) {
            context.getPageCacheContext().markUncacheable("Mount indicates that request is not cacheable");
            log.debug("Request '{}' is not cacheable because mount '{}' is not cacheable.", (Object)request, (Object)mount.getName());
            return false;
        }
        return true;
    }

    private boolean isSiteMapItemAndComponentConfigCacheable(ResolvedSiteMapItem resolvedSitemapItem, ValveContext context) throws ContainerException {
        if (!resolvedSitemapItem.getHstSiteMapItem().isCacheable()) {
            log.debug("'{}' is not cacheable because hst sitemapitem '{}' is not cacheable.", (Object)context.getServletRequest(), (Object)resolvedSitemapItem.getHstSiteMapItem().getId());
            return false;
        }
        String componentRenderingWindowReferenceNamespace = context.getRequestContext().getBaseURL().getComponentRenderingWindowReferenceNamespace();
        if (componentRenderingWindowReferenceNamespace != null) {
            HstComponentWindow window = this.findComponentWindow(context.getRootComponentWindow(), componentRenderingWindowReferenceNamespace);
            if (window == null) {
                return false;
            }
            if (window.getComponentInfo().isStandalone()) {
                return window.getComponentInfo().isCompositeCacheable();
            }
            if (!resolvedSitemapItem.getHstComponentConfiguration().isCompositeCacheable()) {
                log.debug("'{}' is not cacheable because hst component '{}' is not cacheable.", (Object)context.getServletRequest(), (Object)resolvedSitemapItem.getHstComponentConfiguration().getId());
                return false;
            }
        } else if (!resolvedSitemapItem.getHstComponentConfiguration().isCompositeCacheable()) {
            log.debug("'{}' is not cacheable because hst component '{}' is not cacheable.", (Object)context.getServletRequest(), (Object)resolvedSitemapItem.getHstComponentConfiguration().getId());
            return false;
        }
        return true;
    }
}

