/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.component;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hippoecm.hst.core.component.HstComponentException;
import org.hippoecm.hst.core.component.HstURL;
import org.hippoecm.hst.core.container.ContainerException;
import org.hippoecm.hst.core.container.HstContainerURL;
import org.hippoecm.hst.core.container.HstContainerURLProvider;
import org.hippoecm.hst.core.request.HstRequestContext;

public class HstURLImpl
implements HstURL {
    protected String type = "render";
    protected String referenceNamespace;
    protected HstContainerURL baseContainerURL;
    protected Map<String, String[]> parameterMap = new LinkedHashMap<String, String[]>();
    protected String resourceID;
    protected HstContainerURLProvider urlProvider;
    protected transient HstRequestContext requestContext;
    protected String explicitContextPath;

    public HstURLImpl(String type, HstContainerURL baseContainerURL, String referenceNamespace, HstContainerURLProvider urlProvider, HstRequestContext requestContext) {
        this(type, baseContainerURL, referenceNamespace, urlProvider, requestContext, null);
    }

    public HstURLImpl(String type, HstContainerURL baseContainerURL, String referenceNamespace, HstContainerURLProvider urlProvider, HstRequestContext requestContext, String explicitContextPath) {
        this.type = type;
        this.baseContainerURL = baseContainerURL;
        this.referenceNamespace = referenceNamespace;
        this.urlProvider = urlProvider;
        this.requestContext = requestContext;
        this.explicitContextPath = explicitContextPath;
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameterMap;
    }

    public String getType() {
        return this.type;
    }

    public String getReferenceNamespace() {
        return this.referenceNamespace;
    }

    public HstContainerURL getBaseContainerURL() {
        return this.baseContainerURL;
    }

    public void setParameter(String name, String value) {
        String[] stringArray;
        if (value != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = value;
        } else {
            stringArray = null;
        }
        this.setParameter(name, stringArray);
    }

    public void setParameter(String name, String[] values) {
        this.parameterMap.put(name, values);
    }

    public void setParameters(Map<String, String[]> parameters) {
        for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
            this.setParameter(entry.getKey(), entry.getValue());
        }
    }

    public void setResourceID(String resourceID) {
        this.resourceID = resourceID;
    }

    public String getResourceID() {
        return this.resourceID;
    }

    public void write(Writer out) throws IOException {
        out.write(this.toString());
    }

    public void write(Writer out, boolean escapeXML) throws IOException {
        this.write(out);
    }

    public String toString() {
        HstContainerURL containerURL = this.urlProvider.createURL(this.baseContainerURL, (HstURL)this);
        containerURL.setResourceId(this.getResourceID());
        try {
            return this.urlProvider.toURLString(containerURL, this.requestContext, this.explicitContextPath);
        }
        catch (UnsupportedEncodingException e) {
            throw new HstComponentException((Throwable)e);
        }
        catch (ContainerException e) {
            throw new HstComponentException((Throwable)e);
        }
    }
}

