/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.component;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.lang.ArrayUtils;
import org.hippoecm.hst.core.component.HstResponse;
import org.hippoecm.hst.core.component.HstResponseState;
import org.hippoecm.hst.core.component.HstURL;
import org.hippoecm.hst.core.container.HstComponentWindow;
import org.hippoecm.hst.core.container.HstContainerURL;
import org.hippoecm.hst.core.request.HstRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;

public class HstResponseImpl
extends HttpServletResponseWrapper
implements HstResponse {
    private static final Logger log = LoggerFactory.getLogger(HstResponseImpl.class);
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected HstRequestContext requestContext;
    protected HstComponentWindow componentWindow;
    protected HstResponseState responseState;
    protected String redirectLocation;
    protected Map<String, String[]> renderParameters;
    protected HstResponse topParentHstResponse;
    protected String renderPath;

    public HstResponseImpl(HttpServletRequest request, HttpServletResponse response, HstRequestContext requestContext, HstComponentWindow componentWindow, HstResponse topParentHstResponse) {
        super(response);
        this.request = request;
        this.response = response;
        this.requestContext = requestContext;
        this.componentWindow = componentWindow;
        this.responseState = componentWindow.getResponseState();
        if (this.responseState == null) {
            throw new IllegalStateException(String.format("HstResponseState for window '%s' is null.", componentWindow.getName()));
        }
        this.topParentHstResponse = topParentHstResponse;
    }

    public HstURL createRenderURL() {
        return this.requestContext.getURLFactory().createURL("render", this.componentWindow.getReferenceNamespace(), null, this.requestContext);
    }

    public HstURL createNavigationalURL(String pathInfo) {
        HstContainerURL navURL = this.requestContext.getContainerURLProvider().createURL(this.requestContext.getBaseURL(), pathInfo);
        return this.requestContext.getURLFactory().createURL("render", null, navURL, this.requestContext);
    }

    public HstURL createComponentRenderingURL() {
        return this.requestContext.getURLFactory().createURL("component-rendering", this.componentWindow.getReferenceNamespace(), null, this.requestContext);
    }

    public HstURL createActionURL() {
        return this.requestContext.getURLFactory().createURL("action", this.componentWindow.getReferenceNamespace(), null, this.requestContext);
    }

    public HstURL createResourceURL() {
        return this.createResourceURL(this.componentWindow.getReferenceNamespace());
    }

    public HstURL createResourceURL(String referenceNamespace) {
        return this.requestContext.getURLFactory().createURL("resource", referenceNamespace, null, this.requestContext);
    }

    public String getNamespace() {
        return this.componentWindow.getReferenceNamespace();
    }

    public String getRedirectLocation() {
        return this.redirectLocation;
    }

    public void addCookie(Cookie cookie) {
        this.responseState.addCookie(cookie);
    }

    public void addDateHeader(String name, long date) {
        this.responseState.addDateHeader(name, date);
    }

    public void addHeader(String name, String value) {
        this.responseState.addHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        this.responseState.addIntHeader(name, value);
    }

    public boolean containsHeader(String name) {
        return this.responseState.containsHeader(name);
    }

    public void flushBuffer() throws IOException {
        this.responseState.flushBuffer();
    }

    public int getBufferSize() {
        return this.responseState.getBufferSize();
    }

    public String getCharacterEncoding() {
        return this.responseState.getCharacterEncoding();
    }

    public String getContentType() {
        return this.responseState.getContentType();
    }

    public Locale getLocale() {
        return this.responseState.getLocale();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        ServletOutputStream os = this.responseState.getOutputStream();
        return os != null ? os : super.getOutputStream();
    }

    public PrintWriter getWriter() throws IOException {
        PrintWriter pw = this.responseState.getWriter();
        return pw != null ? pw : super.getWriter();
    }

    public boolean isCommitted() {
        return this.responseState.isCommitted();
    }

    public void reset() {
        this.responseState.reset();
    }

    public void resetBuffer() {
        this.responseState.resetBuffer();
    }

    public void sendError(int errorCode, String errorMessage) throws IOException {
        this.responseState.sendError(errorCode, errorMessage);
    }

    public void sendError(int errorCode) throws IOException {
        this.responseState.sendError(errorCode);
    }

    public void sendRedirect(String redirectLocation) throws IOException {
        this.responseState.sendRedirect(redirectLocation);
    }

    public void setBufferSize(int size) {
        this.responseState.setBufferSize(size);
    }

    public void setCharacterEncoding(String charset) {
        this.responseState.setCharacterEncoding(charset);
    }

    public void setContentLength(int len) {
        this.responseState.setContentLength(len);
    }

    public void setContentType(String type) {
        this.responseState.setContentType(type);
    }

    public void setDateHeader(String name, long date) {
        this.responseState.setDateHeader(name, date);
    }

    public void setHeader(String name, String value) {
        this.responseState.setHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.responseState.setIntHeader(name, value);
    }

    public void setLocale(Locale locale) {
        this.responseState.setLocale(locale);
    }

    public void setStatus(int statusCode, String message) {
        this.responseState.setStatus(statusCode, message);
    }

    public void setStatus(int statusCode) {
        this.responseState.setStatus(statusCode);
    }

    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public String encodeRedirectURL(String url) {
        return url;
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public String encodeURL(String url) {
        if (url.indexOf("://") == -1 && !url.startsWith("/")) {
            return url;
        }
        return super.encodeURL(url);
    }

    public Element createElement(String tagName) {
        Element element = null;
        element = this.topParentHstResponse != null ? this.topParentHstResponse.createElement(tagName) : this.responseState.createElement(tagName);
        return element;
    }

    public Comment createComment(String comment) {
        Comment element = null;
        element = this.topParentHstResponse != null ? this.topParentHstResponse.createComment(comment) : this.responseState.createComment(comment);
        return element;
    }

    public void addHeadElement(Element element, String keyHint) {
        this.responseState.addHeadElement(element, keyHint);
    }

    public List<Element> getHeadElements() {
        return this.responseState.getHeadElements();
    }

    public boolean containsHeadElement(String keyHint) {
        boolean contained = false;
        if (this.topParentHstResponse == null) {
            contained = this.responseState.containsHeadElement(keyHint);
        } else if (this != this.topParentHstResponse) {
            contained = this.topParentHstResponse.containsHeadElement(keyHint);
        }
        return contained;
    }

    public void addProcessedHeadElement(Element headElement) {
        this.responseState.addProcessedHeadElement(headElement);
    }

    public void addPreamble(Comment comment) {
        this.responseState.addPreambleNode(comment);
    }

    public void addPreamble(Element element) {
        this.responseState.addPreambleNode(element);
    }

    public void addEpilogue(Comment comment) {
        this.responseState.addEpilogueNode(comment);
    }

    public void setWrapperElement(Element element) {
        this.responseState.setWrapperElement(element);
    }

    public Element getWrapperElement() {
        return this.responseState.getWrapperElement();
    }

    public void setRenderParameter(String key, String value) {
        if (value == null) {
            this.setRenderParameter(key, ArrayUtils.EMPTY_STRING_ARRAY);
        } else {
            this.setRenderParameter(key, new String[]{value});
        }
    }

    public void setRenderParameter(String key, String[] values) {
        if (this.renderParameters == null) {
            this.renderParameters = new HashMap<String, String[]>();
        }
        if (values == null) {
            this.renderParameters.remove(key);
        } else {
            this.renderParameters.put(key, values);
        }
    }

    public void setRenderParameters(Map<String, String[]> parameters) {
        if (parameters == null) {
            this.renderParameters = null;
        } else {
            if (this.renderParameters == null) {
                this.renderParameters = new HashMap<String, String[]>();
            } else {
                this.renderParameters.clear();
            }
            for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
                this.setRenderParameter(entry.getKey(), entry.getValue());
            }
        }
    }

    public Map<String, String[]> getRenderParameters() {
        return this.renderParameters;
    }

    public void setRenderPath(String renderPath) {
        this.renderPath = renderPath;
    }

    public String getRenderPath() {
        return this.renderPath;
    }

    public void setServeResourcePath(String serveResourcePath) {
        throw new UnsupportedOperationException("hst response is not allowed to invoke setServeResourcePath().");
    }

    public void flushChildContent(String name) throws IOException {
        this.flushChildContent(name, null);
    }

    public void flushChildContent(String name, Writer writer) throws IOException {
        HstComponentWindow childWindow = this.componentWindow.getChildWindow(name);
        if (childWindow == null) {
            log.debug("Cannot find child window with name '{}' for current window '{}'. Skip child.", (Object)name, (Object)this.componentWindow.getName());
        } else {
            childWindow.getResponseState().flush(writer);
        }
    }

    public List<String> getChildContentNames() {
        return this.componentWindow.getChildWindowNames();
    }

    public void forward(String pathInfo) throws IOException {
        this.responseState.forward(pathInfo);
    }

    public boolean isRendererSkipped() {
        return false;
    }
}

