/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.collections.EnumerationUtils;
import org.apache.commons.collections.collection.CompositeCollection;
import org.hippoecm.hst.core.component.HstRequest;
import org.hippoecm.hst.core.container.ContainerConfiguration;
import org.hippoecm.hst.core.container.HstComponentWindow;
import org.hippoecm.hst.core.request.HstRequestContext;

public class HstRequestImpl
extends HttpServletRequestWrapper
implements HstRequest {
    public static final String CONTAINER_ATTR_NAME_PREFIXES_PROP_KEY = HstRequest.class.getName() + ".containerAttributeNamePrefixes";
    public static final String CONTAINER_USER_PRINCIPAL_CLASSNAME_PROP_KEY = HstRequest.class.getName() + ".userPrincipalClassName";
    public static final String CONTAINER_ROLE_PRINCIPAL_CLASSNAME_PROP_KEY = HstRequest.class.getName() + ".rolePrincipalClassName";
    private static String[] CONTAINER_ATTR_NAME_PREFIXES = null;
    protected String lifecyclePhase;
    protected HstRequestContext requestContext;
    protected Map<String, Map<String, String[]>> namespaceParametersMap = new HashMap<String, Map<String, String[]>>();
    protected Map<String, Map<String, Object>> namespaceAttributesMap = new HashMap<String, Map<String, Object>>();
    protected HstComponentWindow componentWindow;
    protected String parameterNameComponentSeparator;
    protected boolean referenceNamespaceIgnored;

    public HstRequestImpl(HttpServletRequest servletRequest, HstRequestContext requestContext, HstComponentWindow componentWindow, String lifecyclePhase) {
        super(servletRequest);
        this.lifecyclePhase = lifecyclePhase;
        this.requestContext = requestContext;
        this.referenceNamespaceIgnored = this.requestContext.getURLFactory().isReferenceNamespaceIgnored() && "RENDER_PHASE".equals(lifecyclePhase);
        this.componentWindow = componentWindow;
        this.parameterNameComponentSeparator = requestContext.getContainerURLProvider().getParameterNameComponentSeparator();
    }

    public Map<String, String[]> getParameterMap() {
        String referenceNamespace = this.componentWindow.getReferenceNamespace();
        return this.getParameterMap(this.referenceNamespaceIgnored ? "" : referenceNamespace);
    }

    public Map<String, String[]> getParameterMap(String referencePath) {
        Map<String, Object> parameterMap;
        String namespace = this.getReferenceNamespacePath(referencePath);
        String prefix = this.getFullNamespacePrefix(namespace);
        if (this.namespaceParametersMap.isEmpty()) {
            if (this.referenceNamespaceIgnored) {
                this.namespaceParametersMap.put("", new HashMap(super.getParameterMap()));
            } else {
                boolean isRenderPhase = "RENDER_PHASE".equals(this.lifecyclePhase);
                String targetComponentReferencePrefix = isRenderPhase ? "" : this.getFullNamespacePrefix(this.getReferenceNamespace());
                boolean emptyTargetComponentReferencePrefix = "".equals(targetComponentReferencePrefix);
                Enumeration paramNames = super.getParameterNames();
                while (paramNames.hasMoreElements()) {
                    String paramKey;
                    String prefixKey;
                    boolean namespacedParameter;
                    String paramName = (String)paramNames.nextElement();
                    int index = paramName.indexOf(this.parameterNameComponentSeparator);
                    boolean bl = namespacedParameter = index != -1 && index < paramName.length() - 1;
                    if (namespacedParameter) {
                        prefixKey = paramName.substring(0, index + 1);
                        paramKey = paramName.substring(index + 1);
                    } else {
                        prefixKey = targetComponentReferencePrefix;
                        paramKey = paramName;
                    }
                    parameterMap = this.namespaceParametersMap.get(prefixKey);
                    if (parameterMap == null) {
                        parameterMap = new HashMap<String, String[]>();
                        this.namespaceParametersMap.put(prefixKey, parameterMap);
                    }
                    String[] paramValues = super.getParameterValues(paramName);
                    if (!parameterMap.containsKey(paramKey)) {
                        parameterMap.put(paramKey, paramValues);
                    }
                    if (namespacedParameter || isRenderPhase || emptyTargetComponentReferencePrefix) continue;
                    parameterMap = this.namespaceParametersMap.get("");
                    if (parameterMap == null) {
                        parameterMap = new HashMap();
                        this.namespaceParametersMap.put("", parameterMap);
                    }
                    if (parameterMap.containsKey(paramKey)) continue;
                    parameterMap.put(paramKey, paramValues);
                }
            }
        }
        if ((parameterMap = this.namespaceParametersMap.get(prefix)) == null) {
            parameterMap = Collections.emptyMap();
        }
        return parameterMap;
    }

    public Map<String, Object> getAttributeMap() {
        String referenceNamespace = this.componentWindow.getReferenceNamespace();
        return this.getAttributeMap(referenceNamespace);
    }

    public String getReferenceNamespace() {
        return this.componentWindow.getReferenceNamespace();
    }

    public Map<String, Object> getAttributeMap(String referencePath) {
        String namespace = this.getReferenceNamespacePath(referencePath);
        String prefix = this.getFullNamespacePrefix(namespace);
        int prefixLen = prefix.length();
        Map<String, Object> attributesMap = this.namespaceAttributesMap.get(prefix);
        if (attributesMap == null) {
            attributesMap = new HashMap<String, Object>();
            Enumeration attributeNames = super.getAttributeNames();
            while (attributeNames.hasMoreElements()) {
                String encodedAttributeName = (String)attributeNames.nextElement();
                if (!encodedAttributeName.startsWith(prefix)) continue;
                String attributeName = encodedAttributeName.substring(prefixLen);
                Object attributeValue = super.getAttribute(encodedAttributeName);
                attributesMap.put(attributeName, attributeValue);
            }
            this.namespaceAttributesMap.put(prefix, attributesMap);
        }
        return attributesMap;
    }

    public String getParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException("parameter name cannot be null.");
        }
        String[] value = this.getParameterMap().get(name);
        if (value == null) {
            return null;
        }
        if (value instanceof String[]) {
            return value[0];
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    public Enumeration getParameterNames() {
        return Collections.enumeration(this.getParameterMap().keySet());
    }

    public String[] getParameterValues(String name) {
        if (name == null) {
            throw new IllegalArgumentException("parameter name cannot be null.");
        }
        String[] value = this.getParameterMap().get(name);
        if (value == null) {
            return null;
        }
        if (value instanceof String[]) {
            return value;
        }
        if (value instanceof String) {
            return new String[]{(String)value};
        }
        return new String[]{value.toString()};
    }

    public Enumeration getAttributeNames() {
        List servletRequestAttrs = EnumerationUtils.toList((Enumeration)super.getAttributeNames());
        Set<String> localRequestAttrs = this.getAttributeMap().keySet();
        CompositeCollection composite = new CompositeCollection(new Collection[]{servletRequestAttrs, localRequestAttrs});
        return Collections.enumeration(composite);
    }

    public Object getAttribute(String name) {
        Object value;
        if (name == null) {
            throw new IllegalArgumentException("attribute name cannot be null.");
        }
        if (this.isContainerAttributeName(name)) {
            value = super.getAttribute(name);
        } else {
            String prefix;
            value = this.getAttributeMap().get(name);
            if (value == null && (value = super.getAttribute((prefix = this.getFullNamespacePrefix(this.componentWindow.getReferenceNamespace(), false)) + name)) == null) {
                value = super.getAttribute(name);
            }
        }
        return value;
    }

    public void setAttribute(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("attribute name cannot be null.");
        }
        if (value == null) {
            this.removeAttribute(name);
        } else if (this.isContainerAttributeName(name)) {
            super.setAttribute(name, value);
        } else {
            this.getAttributeMap().put(name, value);
            String prefix = this.getFullNamespacePrefix(this.componentWindow.getReferenceNamespace(), false);
            super.setAttribute(prefix + name, value);
        }
    }

    public void removeAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("attribute name cannot be null.");
        }
        if (this.isContainerAttributeName(name)) {
            super.removeAttribute(name);
        } else {
            this.getAttributeMap().remove(name);
            String prefix = this.getFullNamespacePrefix(this.componentWindow.getReferenceNamespace(), false);
            super.removeAttribute(prefix + name);
        }
    }

    public Locale getLocale() {
        Locale preferredLocale = this.requestContext.getPreferredLocale();
        if (preferredLocale == null) {
            preferredLocale = super.getLocale();
        }
        return preferredLocale;
    }

    public Enumeration getLocales() {
        Enumeration localesEnum = this.requestContext.getLocales();
        if (localesEnum == null) {
            localesEnum = super.getLocales();
        }
        return localesEnum;
    }

    public HstRequestContext getRequestContext() {
        return this.requestContext;
    }

    public HstComponentWindow getComponentWindow() {
        return this.componentWindow;
    }

    public String getResourceID() {
        return this.requestContext.getBaseURL().getResourceId();
    }

    protected String getReferenceNamespacePath(String referencePath) {
        return referencePath;
    }

    protected String getFullNamespacePrefix(String referenceNamespace) {
        return this.getFullNamespacePrefix(referenceNamespace, true);
    }

    protected String getFullNamespacePrefix(String referenceNamespace, boolean noSeparatorForEmpty) {
        if (referenceNamespace == null || "".equals(referenceNamespace)) {
            return noSeparatorForEmpty ? "" : this.parameterNameComponentSeparator;
        }
        return referenceNamespace + this.parameterNameComponentSeparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected boolean isContainerAttributeName(String attrName) {
        boolean containerAttrName = false;
        if (CONTAINER_ATTR_NAME_PREFIXES == null) {
            Class<HstRequestImpl> clazz = HstRequestImpl.class;
            // MONITORENTER : org.hippoecm.hst.core.component.HstRequestImpl.class
            if (CONTAINER_ATTR_NAME_PREFIXES == null) {
                ArrayList<String> containerAttrNamePrefixes = new ArrayList<String>(Arrays.asList("javax.servlet.", "org.hippoecm.hst.container."));
                ContainerConfiguration containerConfiguration = this.requestContext.getContainerConfiguration();
                if (containerConfiguration != null) {
                    containerAttrNamePrefixes.addAll(this.requestContext.getContainerConfiguration().getList(CONTAINER_ATTR_NAME_PREFIXES_PROP_KEY));
                }
                CONTAINER_ATTR_NAME_PREFIXES = containerAttrNamePrefixes.toArray(new String[containerAttrNamePrefixes.size()]);
            }
            // MONITOREXIT : clazz
        }
        String[] stringArray = CONTAINER_ATTR_NAME_PREFIXES;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            if (attrName.startsWith(prefix)) {
                return true;
            }
            ++n2;
        }
        return containerAttrName;
    }

    public String getLifecyclePhase() {
        return this.lifecyclePhase;
    }
}

