/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.component;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hippoecm.hst.core.component.HstComponentMetadata;
import org.hippoecm.hst.util.AnnotationsScanner;

public class HstComponentMetadataReader {
    private HstComponentMetadataReader() {
    }

    public static HstComponentMetadata getHstComponentMetadata(Class<?> clazz) {
        return new DefaultHstComponentMetadata(AnnotationsScanner.getMethodAnnotations(clazz));
    }

    private static class DefaultHstComponentMetadata
    implements HstComponentMetadata {
        final Map<String, Set<String>> methodAnnotations = new HashMap<String, Set<String>>();

        public DefaultHstComponentMetadata(Map<Method, Set<Annotation>> methodAnnotationsMap) {
            for (Map.Entry<Method, Set<Annotation>> methodAnnotation : methodAnnotationsMap.entrySet()) {
                HashSet<String> annotations = new HashSet<String>();
                for (Annotation annotation : methodAnnotation.getValue()) {
                    annotations.add(annotation.annotationType().getName());
                }
                Set<String> annotationsSet = this.methodAnnotations.get(methodAnnotation.getKey().getName());
                if (annotationsSet == null) {
                    annotationsSet = new HashSet<String>();
                    this.methodAnnotations.put(methodAnnotation.getKey().getName(), annotationsSet);
                }
                annotationsSet.addAll(annotations);
            }
        }

        public boolean hasMethodAnnotatedBy(String annotation, String methodName) {
            if (!this.methodAnnotations.containsKey(methodName)) {
                return false;
            }
            return this.methodAnnotations.get(methodName).contains(annotation);
        }
    }
}

