/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.channelmanager;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.hippoecm.hst.configuration.components.HstComponentConfiguration;
import org.hippoecm.hst.configuration.hosting.Mount;
import org.hippoecm.hst.configuration.internal.CanonicalInfo;
import org.hippoecm.hst.configuration.sitemap.HstSiteMap;
import org.hippoecm.hst.configuration.sitemap.HstSiteMapItem;
import org.hippoecm.hst.core.channelmanager.AbstractComponentWindowResponseAppender;
import org.hippoecm.hst.core.channelmanager.ComponentWindowAttributeContributor;
import org.hippoecm.hst.core.channelmanager.ComponentWindowResponseAppender;
import org.hippoecm.hst.core.component.HstRequest;
import org.hippoecm.hst.core.component.HstResponse;
import org.hippoecm.hst.core.container.HstComponentWindow;
import org.hippoecm.hst.core.request.HstRequestContext;
import org.hippoecm.hst.core.request.ResolvedSiteMapItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmsComponentWindowResponseAppender
extends AbstractComponentWindowResponseAppender
implements ComponentWindowResponseAppender {
    private static final Logger log = LoggerFactory.getLogger(CmsComponentWindowResponseAppender.class);
    private static final String WORKSPACE_PATH_ELEMENT = "/hst:workspace/";
    private List<ComponentWindowAttributeContributor> attributeContributors = Collections.emptyList();

    public void setAttributeContributors(List<ComponentWindowAttributeContributor> attributeContributors) {
        this.attributeContributors = attributeContributors;
    }

    public void process(HstComponentWindow rootWindow, HstComponentWindow rootRenderingWindow, HstComponentWindow window, HstRequest request, HstResponse response) {
        if (!this.isCmsRequest(request)) {
            return;
        }
        HttpSession session = request.getSession(false);
        if (session == null) {
            throw new IllegalStateException("HttpSession should never be null here.");
        }
        HstComponentConfiguration compConfig = (HstComponentConfiguration)window.getComponentInfo();
        if (CmsComponentWindowResponseAppender.isContainerOrContainerItem((HstComponentConfiguration)compConfig)) {
            if (this.isComposerMode(request)) {
                this.populateComponentMetaData(request, response, window);
            }
        } else if (this.isTopHstResponse(rootWindow, rootRenderingWindow, window)) {
            this.populatePageMetaData(request, response, session, compConfig);
        }
    }

    private void populatePageMetaData(HstRequest request, HstResponse response, HttpSession session, HstComponentConfiguration compConfig) {
        Object variant;
        HstRequestContext requestContext = request.getRequestContext();
        Mount mount = requestContext.getResolvedMount().getMount();
        HashMap<String, String> pageMetaData = new HashMap<String, String>();
        pageMetaData.put("HST-Mount-Id", mount.getIdentifier());
        pageMetaData.put("HST-Site-Id", mount.getHstSite().getCanonicalIdentifier());
        pageMetaData.put("HST-Page-Id", compConfig.getCanonicalIdentifier());
        ResolvedSiteMapItem resolvedSiteMapItem = requestContext.getResolvedSiteMapItem();
        if (resolvedSiteMapItem != null) {
            HstSiteMapItem hstSiteMapItem = resolvedSiteMapItem.getHstSiteMapItem();
            pageMetaData.put("HST-SitemapItem-Id", ((CanonicalInfo)hstSiteMapItem).getCanonicalIdentifier());
            HstSiteMap siteMap = hstSiteMapItem.getHstSiteMap();
            if (siteMap instanceof CanonicalInfo) {
                CanonicalInfo canonicalInfo = (CanonicalInfo)siteMap;
                pageMetaData.put("HST-Sitemap-Id", canonicalInfo.getCanonicalIdentifier());
                if (canonicalInfo.getCanonicalPath().contains(WORKSPACE_PATH_ELEMENT) && canonicalInfo.getCanonicalPath().startsWith(mount.getHstSite().getConfigurationPath())) {
                    pageMetaData.put("HST-Page-Editable", "true");
                } else {
                    pageMetaData.put("HST-Page-Editable", "false");
                }
            } else {
                log.warn("Expected sitemap of subtype {}. Cannot set sitemap id.", (Object)CanonicalInfo.class.getName());
            }
        }
        if ((variant = session.getAttribute("org.hippoecm.hst.container.render_variant")) == null) {
            variant = "hippo-default";
        }
        pageMetaData.put("HST-Render-Variant", variant.toString());
        pageMetaData.put("HST-Site-HasPreviewConfig", String.valueOf(mount.getHstSite().hasPreviewConfiguration()));
        for (Map.Entry entry : pageMetaData.entrySet()) {
            response.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        pageMetaData.put("HST-Type", "PAGE-META-DATA");
        pageMetaData.put("HST-Path-Info", requestContext.getBaseURL().getPathInfo());
        pageMetaData.put("HST-Channel-Id", mount.getChannel().getId());
        pageMetaData.put("HST-Context-Path", mount.getContextPath());
        response.addEpilogue(this.createCommentWithAttr(pageMetaData, response));
    }

    private void populateComponentMetaData(HstRequest request, HstResponse response, HstComponentWindow window) {
        HstComponentConfiguration config = (HstComponentConfiguration)window.getComponentInfo();
        if (!config.getCanonicalStoredLocation().contains(WORKSPACE_PATH_ELEMENT)) {
            log.debug("Component '{}' not editable as not part of hst:workspace configuration", (Object)config.toString());
            return;
        }
        HashMap<String, String> preambleAttributes = new HashMap<String, String>();
        HashMap<String, String> epilogueAttributes = new HashMap<String, String>();
        this.populateAttributes(window, request, preambleAttributes, epilogueAttributes);
        response.addPreamble(this.createCommentWithAttr(preambleAttributes, response));
        response.addEpilogue(this.createCommentWithAttr(epilogueAttributes, response));
    }

    final void populateAttributes(HstComponentWindow window, HstRequest request, Map<String, String> preambleAttributes, Map<String, String> epilogueAttributes) {
        for (ComponentWindowAttributeContributor attributeContributor : this.attributeContributors) {
            attributeContributor.contributePreamble(window, request, preambleAttributes);
            attributeContributor.contributeEpilogue(window, request, epilogueAttributes);
        }
    }
}

