/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.channelmanager;

import com.google.common.base.Strings;
import java.util.Map;
import org.hippoecm.hst.configuration.components.HstComponentConfiguration;
import org.hippoecm.hst.configuration.internal.ConfigurationLockInfo;
import org.hippoecm.hst.core.channelmanager.ComponentWindowAttributeContributor;
import org.hippoecm.hst.core.component.HstRequest;
import org.hippoecm.hst.core.component.HstURL;
import org.hippoecm.hst.core.component.HstURLFactory;
import org.hippoecm.hst.core.container.HstComponentWindow;
import org.hippoecm.hst.core.request.HstRequestContext;

public class CmsComponentComponentWindowAttributeContributor
implements ComponentWindowAttributeContributor {
    public void contributePreamble(HstComponentWindow window, HstRequest request, Map<String, String> populatingAttributesMap) {
        ConfigurationLockInfo lockInfo;
        HstComponentConfiguration compConfig = (HstComponentConfiguration)window.getComponentInfo();
        HstRequestContext requestContext = request.getRequestContext();
        populatingAttributesMap.put("uuid", compConfig.getCanonicalIdentifier());
        if (compConfig.getXType() != null) {
            populatingAttributesMap.put("HST-XType", compConfig.getXType());
        }
        if (compConfig.isInherited()) {
            populatingAttributesMap.put("HST-Inherited", "true");
        }
        String componentType = compConfig.getComponentType().toString();
        populatingAttributesMap.put("HST-Type", componentType);
        populatingAttributesMap.put("HST-Label", this.getLabel(compConfig));
        HstURLFactory urlFactory = requestContext.getURLFactory();
        HstURL url = urlFactory.createURL("component-rendering", window.getReferenceNamespace(), null, requestContext);
        populatingAttributesMap.put("url", url.toString());
        populatingAttributesMap.put("refNS", window.getReferenceNamespace());
        if (compConfig instanceof ConfigurationLockInfo && (lockInfo = (ConfigurationLockInfo)compConfig).getLockedBy() != null) {
            String cmsUserId = (String)request.getAttribute("org.hippoecm.hst.container.cms_user_id");
            populatingAttributesMap.put("HST-LockedBy", lockInfo.getLockedBy());
            if (lockInfo.getLockedBy().equals(cmsUserId)) {
                populatingAttributesMap.put("HST-LockedBy-Current-User", "true");
            } else {
                populatingAttributesMap.put("HST-LockedBy-Current-User", "false");
            }
            if (lockInfo.getLockedOn() != null) {
                populatingAttributesMap.put("HST-LockedOn", String.valueOf(lockInfo.getLockedOn().getTimeInMillis()));
            }
        }
        if (compConfig.getLastModified() != null) {
            populatingAttributesMap.put("HST-LastModified", String.valueOf(compConfig.getLastModified().getTimeInMillis()));
        }
    }

    public void contributeEpilogue(HstComponentWindow window, HstRequest request, Map<String, String> populatingAttributesMap) {
        HstComponentConfiguration config = (HstComponentConfiguration)window.getComponentInfo();
        populatingAttributesMap.put("HST-End", "true");
        populatingAttributesMap.put("uuid", config.getCanonicalIdentifier());
    }

    private String getLabel(HstComponentConfiguration config) {
        String label = config.getLabel();
        if (Strings.isNullOrEmpty((String)label)) {
            label = config.getName();
        }
        return label;
    }
}

