/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.autoreload;

import org.hippoecm.hst.core.channelmanager.AbstractComponentWindowResponseAppender;
import org.hippoecm.hst.core.channelmanager.ComponentWindowResponseAppender;
import org.hippoecm.hst.core.component.HstRequest;
import org.hippoecm.hst.core.component.HstResponse;
import org.hippoecm.hst.core.container.HstComponentWindow;
import org.onehippo.cms7.services.HippoServiceRegistry;
import org.onehippo.cms7.services.autoreload.AutoReloadService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class AutoReloadResponseAppender
extends AbstractComponentWindowResponseAppender
implements ComponentWindowResponseAppender {
    private static final String AUTO_RELOAD_HEAD_KEY_HINT = AutoReloadResponseAppender.class.getName() + ".autoreload";
    private static final Logger log = LoggerFactory.getLogger(AutoReloadResponseAppender.class);

    public void process(HstComponentWindow rootWindow, HstComponentWindow rootRenderingWindow, HstComponentWindow window, HstRequest request, HstResponse response) {
        Element autoReloadScript;
        boolean isComponentRenderingRequest;
        boolean bl = isComponentRenderingRequest = request.getRequestContext().getBaseURL().getComponentRenderingWindowReferenceNamespace() != null;
        if (isComponentRenderingRequest) {
            log.debug("No auto-reload head element will be added for component rendering request");
            return;
        }
        AutoReloadService autoReload = (AutoReloadService)HippoServiceRegistry.getService(AutoReloadService.class);
        if (autoReload == null) {
            log.debug("No auto-reload service available, do not append auto-reload script to response");
            return;
        }
        if (!autoReload.isEnabled()) {
            log.debug("Auto-reload service is disabled, do not append auto-reload script to response");
            return;
        }
        if (!this.isTopHstResponse(rootWindow, rootRenderingWindow, window)) {
            return;
        }
        if (!response.containsHeadElement(AUTO_RELOAD_HEAD_KEY_HINT) && (autoReloadScript = this.getAutoReloadScriptElement(request, response, autoReload)) != null) {
            log.info("Append auto-reload script");
            response.addHeadElement(autoReloadScript, AUTO_RELOAD_HEAD_KEY_HINT);
        }
    }

    private Element getAutoReloadScriptElement(HstRequest request, HstResponse response, AutoReloadService autoReload) {
        try {
            String script = autoReload.getJavaScript(request.getContextPath());
            Element headElement = response.createElement("script");
            headElement.setAttribute("type", "text/javascript");
            headElement.setTextContent(script);
            return headElement;
        }
        catch (IllegalArgumentException e) {
            log.warn("Failed to append auto-reload script", (Throwable)e);
            return null;
        }
    }
}

