/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.container;

import java.io.IOException;
import java.util.List;
import javax.jcr.Repository;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.BooleanUtils;
import org.hippoecm.hst.configuration.hosting.MatchException;
import org.hippoecm.hst.configuration.hosting.Mount;
import org.hippoecm.hst.configuration.hosting.VirtualHosts;
import org.hippoecm.hst.configuration.internal.ContextualizableMount;
import org.hippoecm.hst.configuration.model.HstManager;
import org.hippoecm.hst.configuration.sitemap.HstSiteMapItem;
import org.hippoecm.hst.configuration.sitemapitemhandlers.HstSiteMapItemHandlerConfiguration;
import org.hippoecm.hst.container.AbstractFilterBean;
import org.hippoecm.hst.container.HstContainerConfigImpl;
import org.hippoecm.hst.container.HstContainerRequest;
import org.hippoecm.hst.container.HstContainerRequestImpl;
import org.hippoecm.hst.container.RequestContextProvider;
import org.hippoecm.hst.core.ResourceLifecycleManagement;
import org.hippoecm.hst.core.component.HstURLFactory;
import org.hippoecm.hst.core.container.ContainerConstants;
import org.hippoecm.hst.core.container.ContainerException;
import org.hippoecm.hst.core.container.ContainerNotFoundException;
import org.hippoecm.hst.core.container.HstContainerConfig;
import org.hippoecm.hst.core.container.HstContainerURL;
import org.hippoecm.hst.core.container.HstRequestProcessor;
import org.hippoecm.hst.core.internal.HstMutableRequestContext;
import org.hippoecm.hst.core.internal.HstRequestContextComponent;
import org.hippoecm.hst.core.internal.MountDecorator;
import org.hippoecm.hst.core.internal.MutableResolvedMount;
import org.hippoecm.hst.core.jcr.pool.MultipleRepository;
import org.hippoecm.hst.core.request.HstRequestContext;
import org.hippoecm.hst.core.request.ResolvedMount;
import org.hippoecm.hst.core.request.ResolvedSiteMapItem;
import org.hippoecm.hst.core.request.ResolvedVirtualHost;
import org.hippoecm.hst.core.sitemapitemhandler.FilterChainAwareHstSiteMapItemHandler;
import org.hippoecm.hst.core.sitemapitemhandler.HstSiteMapItemHandler;
import org.hippoecm.hst.core.sitemapitemhandler.HstSiteMapItemHandlerException;
import org.hippoecm.hst.core.sitemapitemhandler.HstSiteMapItemHandlerFactory;
import org.hippoecm.hst.diagnosis.HDC;
import org.hippoecm.hst.diagnosis.Task;
import org.hippoecm.hst.util.GenericHttpServletRequestWrapper;
import org.hippoecm.hst.util.HstRequestUtils;
import org.onehippo.cms7.services.cmscontext.CmsSessionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.context.ServletContextAware;

public class HstDelegateeFilterBean
extends AbstractFilterBean
implements ServletContextAware,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(HstDelegateeFilterBean.class);
    private static final String FILTER_DONE_KEY = "filter.done_" + HstDelegateeFilterBean.class.getName();
    public static final String AUTORELOAD_PATHINFO = "/autoreload";
    private ServletContext servletContext;
    private HstContainerConfig requestContainerConfig;
    private HstManager hstManager;
    private HstRequestContextComponent requestContextComponent;
    private MountDecorator mountDecorator;
    private Repository repository;
    private HstRequestProcessor requestProcessor;
    private HstSiteMapItemHandlerFactory siteMapItemHandlerFactory;
    private HstURLFactory urlFactory;

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setHstManager(HstManager hstManager) {
        this.hstManager = hstManager;
    }

    public void setHstRequestContextComponent(HstRequestContextComponent requestContextComponent) {
        this.requestContextComponent = requestContextComponent;
    }

    public void setUrlFactory(HstURLFactory urlFactory) {
        this.urlFactory = urlFactory;
    }

    public void setSiteMapItemHandlerFactory(HstSiteMapItemHandlerFactory siteMapItemHandlerFactory) {
        this.siteMapItemHandlerFactory = siteMapItemHandlerFactory;
    }

    public void setMountDecorator(MountDecorator mountDecorator) {
        this.mountDecorator = mountDecorator;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void setHstRequestProcessor(HstRequestProcessor requestProcessor) {
        this.requestProcessor = requestProcessor;
    }

    public void afterPropertiesSet() throws Exception {
        this.requestContainerConfig = new HstContainerConfigImpl(this.servletContext, Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean isJaasLoginAttempt;
        if (request.getAttribute("org.hippoecm.hst.container.HstFilter.reset") != null) {
            request.removeAttribute(FILTER_DONE_KEY);
            request.removeAttribute("org.hippoecm.hst.container.HstFilter.reset");
        }
        if (request.getAttribute(FILTER_DONE_KEY) != null) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        HttpSession session = req.getSession(false);
        boolean bl = isJaasLoginAttempt = session != null && session.getAttribute("org.hippoecm.hst.security.servlet.LoginServlet.jaas_login_attempt_token") != null && session.getAttribute("org.hippoecm.hst.security.servlet.LoginServlet.jaas_login_attempt_token").equals(req.getParameter("token"));
        if (isJaasLoginAttempt && req.getAttribute("javax.servlet.forward.servlet_path") != null) {
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
            return;
        }
        request.setAttribute(FILTER_DONE_KEY, (Object)Boolean.TRUE);
        boolean requestContextSetToProvider = false;
        Task rootTask = null;
        HstContainerRequestImpl containerRequest = new HstContainerRequestImpl(req, this.hstManager.getPathSuffixDelimiter());
        try {
            ResolvedVirtualHost resolvedVirtualHost;
            String ip;
            if (this.isAutoReloadEndpoint((HstContainerRequest)containerRequest)) {
                log.info("Auto reload websocket endpoint request for {}, skip hst request processing", (Object)containerRequest);
                chain.doFilter(request, response);
                return;
            }
            if (containerRequest.getPathSuffix() == null && this.hstManager.isHstFilterExcludedPath(containerRequest.getPathInfo())) {
                log.info("'{}' part of excluded paths for hst request matching.", (Object)containerRequest);
                chain.doFilter(request, response);
                return;
            }
            String hostName = HstRequestUtils.getFarthestRequestHost((HttpServletRequest)containerRequest);
            VirtualHosts vHosts = this.hstManager.getVirtualHosts(this.isStaleConfigurationAllowedForRequest((HttpServletRequest)containerRequest, hostName));
            if (vHosts.isDiagnosticsEnabled(ip = HstRequestUtils.getFarthestRemoteAddr((HttpServletRequest)containerRequest))) {
                rootTask = HDC.start((String)HstDelegateeFilterBean.class.getSimpleName());
                rootTask.setAttribute("request", (Object)containerRequest.toString());
            }
            if ((resolvedVirtualHost = vHosts.matchVirtualHost(hostName)) == null) {
                log.warn("'{}' can not be matched to a host. Skip HST Filter and request processing. ", (Object)containerRequest);
                chain.doFilter(request, response);
                return;
            }
            log.debug("{} matched to host '{}'", (Object)containerRequest, (Object)resolvedVirtualHost.getVirtualHost());
            if (isJaasLoginAttempt) {
                String resourceURL = (String)session.getAttribute("org.hippoecm.hst.security.servlet.LoginServlet.jaas_login_attempt_resource_url");
                session.removeAttribute("org.hippoecm.hst.security.servlet.LoginServlet.jaas_login_attempt_resource_url");
                session.removeAttribute("org.hippoecm.hst.security.servlet.LoginServlet.jaas_login_attempt_token");
                log.debug("Redirect {} to '{}'", (Object)containerRequest, (Object)resourceURL);
                res.sendRedirect(resourceURL);
                return;
            }
            request.setAttribute("org.hippoecm.hst.configuration.hosting.VirtualHost.requestAttr", (Object)resolvedVirtualHost);
            HstMutableRequestContext requestContext = (HstMutableRequestContext)containerRequest.getAttribute("org.hippoecm.hst.core.request.HstRequestContext");
            if (requestContext == null) {
                requestContext = this.requestContextComponent.create();
                containerRequest.setAttribute("org.hippoecm.hst.core.request.HstRequestContext", (Object)requestContext);
            }
            requestContext.setServletContext(this.servletContext);
            requestContext.setServletRequest((HttpServletRequest)containerRequest);
            requestContext.setServletResponse(res);
            requestContext.setPathSuffix(containerRequest.getPathSuffix());
            if (BooleanUtils.toBoolean((String)request.getParameter("org.hippoecm.hst.container.request.fqu"))) {
                requestContext.setFullyQualifiedURLs(true);
            }
            this.initializeResourceLifecycleManagements();
            RequestContextProvider.set((HstRequestContext)requestContext);
            requestContextSetToProvider = true;
            ResolvedMount resolvedMount = requestContext.getResolvedMount();
            if (resolvedMount == null) {
                resolvedMount = resolvedVirtualHost.matchMount(containerRequest.getContextPath(), containerRequest.getPathInfo());
                if (resolvedMount == null) throw new MatchException(String.format("No matching Mount for '%s'", containerRequest));
                request.setAttribute(ContainerConstants.RESOLVED_MOUNT_REQUEST_ATTR, (Object)resolvedMount);
                requestContext.setResolvedMount(resolvedMount);
                String renderingHost = HstRequestUtils.getRenderingHost((HttpServletRequest)containerRequest);
                if (renderingHost != null) {
                    requestContext.setRenderHost(renderingHost);
                    if (this.requestComesFromCms(vHosts, resolvedMount) && session != null && CmsSessionContext.getContext((HttpSession)session) != null) {
                        requestContext.setCmsRequest(true);
                        if (!(resolvedMount instanceof MutableResolvedMount)) throw new MatchException("ResolvedMount must be an instance of MutableResolvedMount to be usable in CMS SSO environment. Cannot proceed request for " + hostName + " and " + containerRequest.getRequestURI());
                        Mount undecoratedMount = resolvedMount.getMount();
                        if (!(undecoratedMount instanceof ContextualizableMount)) {
                            String msg = String.format("The matched mount for request '%s' is not an instanceof of a ContextualizableMount. Cannot act as preview mount. Cannot proceed request for CMS SSO environment.", containerRequest);
                            throw new MatchException(msg);
                        }
                        Mount decoratedMount = this.mountDecorator.decorateMountAsPreview(undecoratedMount);
                        if (decoratedMount == undecoratedMount) {
                            log.debug("Matched mount pointing to site '{}' is already a preview so no need for CMS SSO context to decorate the mount to a preview", (Object)undecoratedMount.getMountPoint());
                        } else {
                            log.debug("Matched mount pointing to site '{}' is because of CMS SSO context replaced by preview decorated mount pointing to site '{}'", (Object)undecoratedMount.getMountPoint(), (Object)decoratedMount.getMountPoint());
                        }
                        ((MutableResolvedMount)resolvedMount).setMount(decoratedMount);
                    }
                }
            }
            log.debug("{} matched to mount '{}'", (Object)containerRequest, (Object)resolvedMount.getMount());
            req.setAttribute("org.hippoecm.hst.container.filter.chain", (Object)chain);
            this.setHstServletPath((GenericHttpServletRequestWrapper)containerRequest, resolvedMount);
            HstContainerURL hstContainerUrl = this.createOrGetContainerURL((HstContainerRequest)containerRequest, this.hstManager, requestContext, resolvedMount, res);
            String farthestRequestScheme = HstRequestUtils.getFarthestRequestScheme((HttpServletRequest)req);
            if (resolvedMount.getMount().isMapped()) {
                ResolvedSiteMapItem resolvedSiteMapItem = requestContext.getResolvedSiteMapItem();
                boolean processSiteMapItemHandlers = false;
                if (resolvedSiteMapItem == null) {
                    processSiteMapItemHandlers = true;
                    resolvedSiteMapItem = resolvedMount.matchSiteMapItem(hstContainerUrl.getPathInfo());
                    if (resolvedSiteMapItem == null) {
                        log.warn("'{}' could not be processed by the HST: Error resolving request to sitemap item", (Object)containerRequest);
                        HstDelegateeFilterBean.sendError(req, res, 404);
                        return;
                    }
                    log.debug("{} matched to sitemapitem  '{}'", (Object)containerRequest, (Object)resolvedSiteMapItem.getHstSiteMapItem());
                    requestContext.setResolvedSiteMapItem(resolvedSiteMapItem);
                    this.finishMatchingPhase(requestContext);
                }
                if (!this.isSupportedScheme(requestContext, resolvedSiteMapItem, farthestRequestScheme)) {
                    HstSiteMapItem hstSiteMapItem = resolvedSiteMapItem.getHstSiteMapItem();
                    switch (hstSiteMapItem.getSchemeNotMatchingResponseCode()) {
                        case 200: {
                            break;
                        }
                        case 301: {
                            res.setStatus(301);
                            String urlWithExplicitSchemeForRequest = HstRequestUtils.createURLWithExplicitSchemeForRequest((String)hstSiteMapItem.getScheme(), (Mount)resolvedSiteMapItem.getResolvedMount().getMount(), (HttpServletRequest)req);
                            log.debug("Scheme not allowed: MOVED PERMANENTLY {} to {}", (Object)containerRequest, (Object)urlWithExplicitSchemeForRequest);
                            res.setHeader("Location", urlWithExplicitSchemeForRequest);
                            return;
                        }
                        case 302: 
                        case 303: 
                        case 307: {
                            String urlWithExplicitSchemeForRequest = HstRequestUtils.createURLWithExplicitSchemeForRequest((String)hstSiteMapItem.getScheme(), (Mount)resolvedSiteMapItem.getResolvedMount().getMount(), (HttpServletRequest)req);
                            log.debug("Scheme not allowed: MOVED TEMPORARILY {} to {}", (Object)containerRequest, (Object)urlWithExplicitSchemeForRequest);
                            res.sendRedirect(urlWithExplicitSchemeForRequest);
                            return;
                        }
                        case 404: {
                            log.debug("Scheme not allowed for {} : SC_NOT_FOUND", (Object)containerRequest);
                            HstDelegateeFilterBean.sendError(req, res, 404);
                            return;
                        }
                        case 403: {
                            log.debug("Scheme not allowed for {} : SC_FORBIDDEN", (Object)containerRequest);
                            HstDelegateeFilterBean.sendError(req, res, 403);
                            return;
                        }
                        default: {
                            log.warn("Unsupported 'schemenotmatchingresponsecode' {} encountered. Continue rendering.", (Object)hstSiteMapItem.getSchemeNotMatchingResponseCode());
                        }
                    }
                }
                log.info("Start processing sitemap item '{}' for {}", (Object)resolvedSiteMapItem.getHstSiteMapItem(), (Object)containerRequest);
                this.processResolvedSiteMapItem((HttpServletRequest)containerRequest, res, chain, this.hstManager, this.siteMapItemHandlerFactory, requestContext, processSiteMapItemHandlers);
                return;
            } else {
                log.debug("{} matches mount {} that is not mapped by a sitemap.", (Object)containerRequest, (Object)resolvedMount.getMount());
                if (resolvedMount.getNamedPipeline() == null) {
                    log.warn("'{}' could not be processed by the HST: No hstSite and no custom namedPipeline for Mount", (Object)containerRequest);
                    HstDelegateeFilterBean.sendError(req, res, 404);
                    return;
                }
                this.finishMatchingPhase(requestContext);
                if (!this.isSupportedScheme(requestContext, resolvedMount, farthestRequestScheme)) {
                    Mount mount = resolvedMount.getMount();
                    switch (mount.getSchemeNotMatchingResponseCode()) {
                        case 200: {
                            break;
                        }
                        case 301: {
                            res.setStatus(301);
                            String urlWithExplicitSchemeForRequest = HstRequestUtils.createURLWithExplicitSchemeForRequest((String)mount.getScheme(), (Mount)mount, (HttpServletRequest)req);
                            log.debug("MOVED PERMANENTLY {} to {}", (Object)containerRequest, (Object)urlWithExplicitSchemeForRequest);
                            res.setHeader("Location", urlWithExplicitSchemeForRequest);
                            return;
                        }
                        case 302: 
                        case 303: 
                        case 307: {
                            String urlWithExplicitSchemeForRequest = HstRequestUtils.createURLWithExplicitSchemeForRequest((String)mount.getScheme(), (Mount)mount, (HttpServletRequest)req);
                            log.debug("MOVED TEMPORARILY {} to {}", (Object)containerRequest, (Object)urlWithExplicitSchemeForRequest);
                            res.sendRedirect(urlWithExplicitSchemeForRequest);
                            return;
                        }
                        case 404: {
                            log.debug("Scheme not allowed for {} : SC_NOT_FOUND", (Object)containerRequest);
                            HstDelegateeFilterBean.sendError(req, res, 404);
                            return;
                        }
                        case 403: {
                            log.debug("Scheme not allowed for {} : SC_FORBIDDEN", (Object)containerRequest);
                            HstDelegateeFilterBean.sendError(req, res, 403);
                            return;
                        }
                        default: {
                            log.warn("Unsupported 'schemenotmatchingresponsecode' {} encountered. Continue rendering.", (Object)mount.getSchemeNotMatchingResponseCode());
                        }
                    }
                }
                log.info("Start processing request for pipeline '{}' for {}", (Object)resolvedMount.getNamedPipeline(), (Object)containerRequest);
                this.requestProcessor.processRequest(this.requestContainerConfig, (HstRequestContext)requestContext, (HttpServletRequest)containerRequest, res, resolvedMount.getNamedPipeline());
            }
            return;
        }
        catch (MatchException | ContainerNotFoundException e) {
            if (log.isDebugEnabled()) {
                log.info("{} for '{}':", new Object[]{e.getClass().getName(), containerRequest, e});
            } else {
                log.info("{} for '{}': '{}'", new Object[]{e.getClass().getName(), containerRequest, e.toString()});
            }
            HstDelegateeFilterBean.sendError(req, res, 404);
            return;
        }
        catch (ContainerException e) {
            if (log.isDebugEnabled()) {
                log.warn("ContainerException for '{}':", (Object)containerRequest, (Object)e);
            } else {
                log.warn("ContainerException for '{}': {}", (Object)containerRequest, (Object)e.toString());
            }
            HstDelegateeFilterBean.sendError(req, res, 500);
            return;
        }
        finally {
            request.removeAttribute("org.hippoecm.hst.core.request.HstRequestContext");
            if (requestContextSetToProvider) {
                this.disposeHstRequestContext();
                RequestContextProvider.clear();
            }
            this.cleanupResourceLifecycleManagements();
            if (rootTask != null) {
                HDC.cleanUp();
            }
        }
    }

    private void finishMatchingPhase(HstMutableRequestContext requestContext) {
        requestContext.matchingFinished();
        if (!requestContext.isCmsRequest()) {
            return;
        }
        HttpSession session = requestContext.getServletRequest().getSession(false);
        if (session == null) {
            return;
        }
        ResolvedSiteMapItem resolvedSiteMapItem = requestContext.getResolvedSiteMapItem();
        if (resolvedSiteMapItem == null || !resolvedSiteMapItem.getHstSiteMapItem().isContainerResource()) {
            session.setAttribute("org.hippoecm.hst.container.render_mount", (Object)requestContext.getResolvedMount().getMount().getIdentifier());
            session.setAttribute("org.hippoecm.hst.container.render_host", (Object)requestContext.getRenderHost());
        }
    }

    private void disposeHstRequestContext() {
        HstRequestContext requestContext = RequestContextProvider.get();
        if (requestContext != null) {
            this.requestContextComponent.release(requestContext);
        }
    }

    private boolean isAutoReloadEndpoint(HstContainerRequest containerRequest) {
        return AUTORELOAD_PATHINFO.equals(containerRequest.getPathInfo()) && containerRequest.getHeader("Sec-WebSocket-Key") != null;
    }

    private void setHstServletPath(GenericHttpServletRequestWrapper request, ResolvedMount resolvedMount) {
        if (resolvedMount.getMatchingIgnoredPrefix() != null) {
            request.setServletPath("/" + resolvedMount.getMatchingIgnoredPrefix() + resolvedMount.getResolvedMountPath());
        } else {
            request.setServletPath(resolvedMount.getResolvedMountPath());
        }
    }

    private boolean isSupportedScheme(HstMutableRequestContext requestContext, ResolvedSiteMapItem resolvedSiteMapItem, String farthestRequestScheme) {
        if (requestContext.isCmsRequest()) {
            return true;
        }
        HstSiteMapItem hstSiteMapItem = resolvedSiteMapItem.getHstSiteMapItem();
        if (hstSiteMapItem.isSchemeAgnostic()) {
            return true;
        }
        if (hstSiteMapItem.getScheme().equals(farthestRequestScheme)) {
            return true;
        }
        return "https".equals(farthestRequestScheme) && resolvedSiteMapItem.getResolvedMount().getMount().getVirtualHost().isCustomHttpsSupported();
    }

    private boolean isSupportedScheme(HstMutableRequestContext requestContext, ResolvedMount resolvedMount, String farthestRequestScheme) {
        if (requestContext.isCmsRequest()) {
            return true;
        }
        Mount mount = resolvedMount.getMount();
        if (mount.isSchemeAgnostic()) {
            return true;
        }
        if (mount.getScheme().equals(farthestRequestScheme)) {
            return true;
        }
        return "https".equals(farthestRequestScheme) && mount.getVirtualHost().isCustomHttpsSupported();
    }

    private boolean isStaleConfigurationAllowedForRequest(HttpServletRequest request, String hostName) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            int index = hostName.indexOf(":");
            if (index > -1) {
                hostName = hostName.substring(0, index);
            }
            return !"127.0.0.1".equals(hostName);
        }
        return CmsSessionContext.getContext((HttpSession)session) == null;
    }

    private boolean requestComesFromCms(VirtualHosts vHosts, ResolvedMount resolvedMount) {
        if (vHosts.getCmsPreviewPrefix() == null || "".equals(vHosts.getCmsPreviewPrefix())) {
            return true;
        }
        return vHosts.getCmsPreviewPrefix().equals(resolvedMount.getMatchingIgnoredPrefix());
    }

    private HstContainerURL createOrGetContainerURL(HstContainerRequest containerRequest, HstManager hstSitesManager, HstMutableRequestContext requestContext, ResolvedMount mount, HttpServletResponse response) {
        HstContainerURL hstContainerURL = requestContext.getBaseURL();
        if (hstContainerURL == null) {
            hstContainerURL = this.urlFactory.getContainerURLProvider().parseURL((HttpServletRequest)containerRequest, response, mount);
            requestContext.setBaseURL(hstContainerURL);
        }
        return hstContainerURL;
    }

    private static void sendError(HttpServletRequest request, HttpServletResponse response, int errorCode) throws IOException {
        response.sendError(errorCode);
    }

    private void cleanupResourceLifecycleManagements() {
        if (this.repository instanceof MultipleRepository) {
            ResourceLifecycleManagement[] resourceLifecycleManagements;
            for (ResourceLifecycleManagement resourceLifecycleManagement : resourceLifecycleManagements = ((MultipleRepository)this.repository).getResourceLifecycleManagements()) {
                resourceLifecycleManagement.disposeResourcesAndReset();
            }
        }
    }

    private void initializeResourceLifecycleManagements() {
        if (this.repository instanceof MultipleRepository) {
            ResourceLifecycleManagement[] resourceLifecycleManagements;
            for (ResourceLifecycleManagement resourceLifecycleManagement : resourceLifecycleManagements = ((MultipleRepository)this.repository).getResourceLifecycleManagements()) {
                resourceLifecycleManagement.setActive(true);
            }
        }
    }

    protected void processResolvedSiteMapItem(HttpServletRequest containerRequest, HttpServletResponse res, FilterChain filterChain, HstManager hstSitesManager, HstSiteMapItemHandlerFactory siteMapItemHandlerFactory, HstMutableRequestContext requestContext, boolean processHandlers) throws ContainerException {
        ResolvedSiteMapItem resolvedSiteMapItem = requestContext.getResolvedSiteMapItem();
        if (processHandlers) {
            resolvedSiteMapItem = this.processHandlers(resolvedSiteMapItem, siteMapItemHandlerFactory, containerRequest, res, filterChain);
            if (resolvedSiteMapItem == null) {
                return;
            }
            if (requestContext.getResolvedSiteMapItem() != resolvedSiteMapItem) {
                log.debug("Resetting currently request context sitemap item '{}' to '{}'", (Object)requestContext.getResolvedSiteMapItem().getHstSiteMapItem(), (Object)resolvedSiteMapItem.getHstSiteMapItem());
                requestContext.setResolvedSiteMapItem(resolvedSiteMapItem);
            }
        }
        if (resolvedSiteMapItem.getErrorCode() > 0) {
            block12: {
                try {
                    log.info("The resolved sitemap item for {} has error status: {}", (Object)containerRequest, (Object)resolvedSiteMapItem.getErrorCode());
                    res.sendError(resolvedSiteMapItem.getErrorCode());
                }
                catch (IOException e) {
                    if (log.isDebugEnabled()) {
                        log.warn("Exception invocation on sendError().", (Throwable)e);
                    }
                    if (!log.isWarnEnabled()) break block12;
                    log.warn("Exception invocation on sendError() : {}", (Object)e.toString());
                }
            }
            return;
        }
        if (resolvedSiteMapItem.getStatusCode() > 0) {
            log.debug("Setting the status code to '{}' for '{}' because the matched sitemap item has specified the status code", (Object)String.valueOf(resolvedSiteMapItem.getStatusCode()), (Object)containerRequest.getRequestURL().toString());
            res.setStatus(resolvedSiteMapItem.getStatusCode());
        }
        log.info("Start processing request for pipeline '{}' for {}", (Object)resolvedSiteMapItem.getNamedPipeline(), (Object)containerRequest);
        this.requestProcessor.processRequest(this.requestContainerConfig, (HstRequestContext)requestContext, containerRequest, res, resolvedSiteMapItem.getNamedPipeline());
        if (containerRequest.getAttribute("org.hippoecm.hst.container.forward.path_info") != null) {
            String forwardPathInfo = (String)containerRequest.getAttribute("org.hippoecm.hst.container.forward.path_info");
            containerRequest.removeAttribute("org.hippoecm.hst.container.forward.path_info");
            resolvedSiteMapItem = resolvedSiteMapItem.getResolvedMount().matchSiteMapItem(forwardPathInfo);
            if (resolvedSiteMapItem == null) {
                String msg = String.format("Could not match request '%s' to a sitemap item for forwardPathInfo '%s'.", containerRequest, forwardPathInfo);
                throw new MatchException(msg);
            }
            requestContext.clearObjectAndQueryManagers();
            requestContext.setResolvedSiteMapItem(resolvedSiteMapItem);
            requestContext.setBaseURL(this.urlFactory.getContainerURLProvider().createURL(requestContext.getBaseURL(), forwardPathInfo));
            this.processResolvedSiteMapItem(containerRequest, res, filterChain, hstSitesManager, siteMapItemHandlerFactory, requestContext, true);
        }
    }

    protected ResolvedSiteMapItem processHandlers(ResolvedSiteMapItem orginalResolvedSiteMapItem, HstSiteMapItemHandlerFactory siteMapItemHandlerFactory, HttpServletRequest req, HttpServletResponse res, FilterChain filterChain) {
        ResolvedSiteMapItem newResolvedSiteMapItem = orginalResolvedSiteMapItem;
        List handlerConfigsFromMatchedSiteMapItem = orginalResolvedSiteMapItem.getHstSiteMapItem().getSiteMapItemHandlerConfigurations();
        for (HstSiteMapItemHandlerConfiguration handlerConfig : handlerConfigsFromMatchedSiteMapItem) {
            HstSiteMapItemHandler handler = siteMapItemHandlerFactory.getSiteMapItemHandlerInstance(this.requestContainerConfig, handlerConfig);
            log.debug("Processing siteMapItemHandler for configuration handler '{}'", (Object)handlerConfig.getName());
            try {
                newResolvedSiteMapItem = handler instanceof FilterChainAwareHstSiteMapItemHandler ? ((FilterChainAwareHstSiteMapItemHandler)handler).process(newResolvedSiteMapItem, req, res, filterChain) : handler.process(newResolvedSiteMapItem, req, res);
                if (newResolvedSiteMapItem != null) continue;
                log.debug("handler for '{}' return null. Request processing done. Return null", (Object)handlerConfig.getName());
                return null;
            }
            catch (HstSiteMapItemHandlerException e) {
                log.error("Exception during executing siteMapItemHandler '" + handlerConfig.getName() + "'");
                throw e;
            }
        }
        return newResolvedSiteMapItem;
    }
}

