/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.configuration.sitemenu;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hippoecm.hst.configuration.cache.CompositeConfigurationNodes;
import org.hippoecm.hst.configuration.model.HstNode;
import org.hippoecm.hst.configuration.site.HstSite;
import org.hippoecm.hst.configuration.sitemenu.HstSiteMenuConfiguration;
import org.hippoecm.hst.configuration.sitemenu.HstSiteMenuConfigurationService;
import org.hippoecm.hst.configuration.sitemenu.HstSiteMenusConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HstSiteMenusConfigurationService
implements HstSiteMenusConfiguration {
    private static final Logger log = LoggerFactory.getLogger(HstSiteMenusConfigurationService.class);
    private HstSite hstSite;
    private Map<String, HstSiteMenuConfiguration> hstSiteMenuConfigurations = new HashMap<String, HstSiteMenuConfiguration>();

    public HstSiteMenusConfigurationService(HstSite hstSite, CompositeConfigurationNodes.CompositeConfigurationNode siteMenusNode) {
        this.hstSite = hstSite;
        HashMap<String, HstSiteMenuConfigurationService> menus = new HashMap<String, HstSiteMenuConfigurationService>();
        for (HstNode siteMenu : siteMenusNode.getCompositeChildren().values()) {
            if ("hst:sitemenu".equals(siteMenu.getNodeTypeName())) {
                HstSiteMenuConfigurationService hstSiteMenuConfiguration = new HstSiteMenuConfigurationService(this, siteMenu);
                HstSiteMenuConfiguration old = menus.put(hstSiteMenuConfiguration.getName(), hstSiteMenuConfiguration);
                if (old == null) continue;
                log.error("Duplicate name for HstSiteMenuConfiguration found. The first one is replaced");
                continue;
            }
            log.error("Skipping siteMenu '{}' because not of type '{}'", (Object)siteMenu.getValueProvider().getPath(), (Object)"hst:sitemenu");
        }
        this.hstSiteMenuConfigurations = Collections.unmodifiableMap(menus);
    }

    public HstSite getSite() {
        return this.hstSite;
    }

    public Map<String, HstSiteMenuConfiguration> getSiteMenuConfigurations() {
        return this.hstSiteMenuConfigurations;
    }

    public HstSiteMenuConfiguration getSiteMenuConfiguration(String name) {
        return this.hstSiteMenuConfigurations.get(name);
    }
}

