/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.configuration.sitemenu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hippoecm.hst.configuration.internal.CanonicalInfo;
import org.hippoecm.hst.configuration.model.HstNode;
import org.hippoecm.hst.configuration.sitemenu.HstSiteMenuConfiguration;
import org.hippoecm.hst.configuration.sitemenu.HstSiteMenuItemConfiguration;
import org.hippoecm.hst.core.internal.StringPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HstSiteMenuItemConfigurationService
implements HstSiteMenuItemConfiguration,
CanonicalInfo {
    private static final Logger log = LoggerFactory.getLogger(HstSiteMenuItemConfigurationService.class);
    private static final String PARENT_PROPERTY_PLACEHOLDER = "${parent}";
    private HstSiteMenuConfiguration hstSiteMenuConfiguration;
    private HstSiteMenuItemConfiguration parent;
    private String name;
    private String canonicalIdentifier;
    private String canonicalPath;
    private List<HstSiteMenuItemConfiguration> childItems = new ArrayList<HstSiteMenuItemConfiguration>();
    private String siteMapItemPath;
    private String externalLink;
    private String mountAlias;
    private int depth;
    private boolean repositoryBased;
    private Map<String, Object> properties;
    private Set<String> roles;
    private Map<String, String> parameters = new HashMap<String, String>();
    private Map<String, String> localParameters = new HashMap<String, String>();

    public HstSiteMenuItemConfigurationService(HstNode siteMenuItem, HstSiteMenuItemConfiguration parent, HstSiteMenuConfiguration hstSiteMenuConfiguration) {
        this.parent = parent;
        this.hstSiteMenuConfiguration = hstSiteMenuConfiguration;
        this.canonicalIdentifier = siteMenuItem.getValueProvider().getIdentifier();
        this.canonicalPath = siteMenuItem.getValueProvider().getPath();
        this.name = StringPool.get((String)siteMenuItem.getValueProvider().getName());
        if (siteMenuItem.getValueProvider().hasProperty("hst:externallink")) {
            this.externalLink = StringPool.get((String)siteMenuItem.getValueProvider().getString("hst:externallink"));
        } else if (siteMenuItem.getValueProvider().hasProperty("hst:referencesitemapitem")) {
            this.siteMapItemPath = siteMenuItem.getValueProvider().getString("hst:referencesitemapitem");
            if (this.siteMapItemPath != null && this.siteMapItemPath.indexOf(PARENT_PROPERTY_PLACEHOLDER) > -1) {
                if (parent == null || parent.getSiteMapItemPath() == null) {
                    log.error("Cannot use '{}' for a sitemenu item that does not have a parent or a parent without sitemap item path. Used for: '{}'", (Object)PARENT_PROPERTY_PLACEHOLDER, (Object)this.name);
                } else {
                    this.siteMapItemPath = this.siteMapItemPath.replace(PARENT_PROPERTY_PLACEHOLDER, parent.getSiteMapItemPath());
                }
            }
        } else {
            log.info("HstSiteMenuItemConfiguration cannot be used for linking because no associated HstSiteMapItem present");
        }
        if (siteMenuItem.getValueProvider().hasProperty("hst:refidsitemapitem")) {
            log.warn("Propery hst:refidsitemapitem on sitemenuitem '{}' is unused and deprecated since 2.24.08/2.25.05. It will be ignored. You should use '{}' property instead to point to a sitemapitem refId.", (Object)siteMenuItem.getValueProvider().getPath(), (Object)"hst:referencesitemapitem");
        }
        this.mountAlias = siteMenuItem.getValueProvider().getString("hst:mountalias");
        if (siteMenuItem.getValueProvider().hasProperty("hst:repobased")) {
            this.repositoryBased = siteMenuItem.getValueProvider().getBoolean("hst:repobased");
        }
        if (siteMenuItem.getValueProvider().hasProperty("hst:depth")) {
            this.depth = siteMenuItem.getValueProvider().getLong("hst:depth").intValue();
        }
        if (this.repositoryBased && this.depth <= 0 || !this.repositoryBased && this.depth > 0) {
            this.repositoryBased = false;
            this.depth = 0;
            log.warn("Ambiguous configuration for repository based sitemenu: only when both repository based is true AND depth > 0 the configuration is correct for repository based navigation. Skipping repobased and depth setting for this item.");
        }
        this.properties = siteMenuItem.getValueProvider().getProperties();
        if (siteMenuItem.getValueProvider().hasProperty("hst:roles")) {
            String[] rolesProp = siteMenuItem.getValueProvider().getStrings("hst:roles");
            this.roles = new HashSet<String>(Arrays.asList(rolesProp));
        } else {
            this.roles = this.parent != null && parent.getRoles() != null ? new HashSet<String>(parent.getRoles()) : null;
        }
        String[] parameterNames = siteMenuItem.getValueProvider().getStrings("hst:parameternames");
        String[] parameterValues = siteMenuItem.getValueProvider().getStrings("hst:parametervalues");
        if (parameterNames != null && parameterValues != null) {
            if (parameterNames.length != parameterValues.length) {
                log.warn("Skipping parameters for component because they only make sense if there are equal number of names and values");
            } else {
                for (int i = 0; i < parameterNames.length; ++i) {
                    this.parameters.put(StringPool.get((String)parameterNames[i]), StringPool.get((String)parameterValues[i]));
                    this.localParameters.put(StringPool.get((String)parameterNames[i]), StringPool.get((String)parameterValues[i]));
                }
            }
        }
        if (this.parent != null) {
            for (Map.Entry parentParam : this.parent.getParameters().entrySet()) {
                if (this.parameters.containsKey(parentParam.getKey())) continue;
                this.parameters.put(StringPool.get((String)((String)parentParam.getKey())), StringPool.get((String)((String)parentParam.getValue())));
            }
        }
        for (HstNode childItem : siteMenuItem.getNodes()) {
            HstSiteMenuItemConfigurationService child = new HstSiteMenuItemConfigurationService(childItem, this, this.hstSiteMenuConfiguration);
            this.childItems.add(child);
        }
    }

    public boolean isWorkspaceConfiguration() {
        return false;
    }

    public List<HstSiteMenuItemConfiguration> getChildItemConfigurations() {
        return Collections.unmodifiableList(this.childItems);
    }

    public String getName() {
        return this.name;
    }

    public String getCanonicalIdentifier() {
        return this.canonicalIdentifier;
    }

    public String getCanonicalPath() {
        return this.canonicalPath;
    }

    public HstSiteMenuItemConfiguration getParentItemConfiguration() {
        return this.parent;
    }

    public HstSiteMenuConfiguration getHstSiteMenuConfiguration() {
        return this.hstSiteMenuConfiguration;
    }

    public String getSiteMapItemPath() {
        return this.siteMapItemPath;
    }

    public String getExternalLink() {
        return this.externalLink;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean isRepositoryBased() {
        return this.repositoryBased;
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public String getLocalParameter(String name) {
        return this.localParameters.get(name);
    }

    public Map<String, String> getLocalParameters() {
        return Collections.unmodifiableMap(this.localParameters);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String getMountAlias() {
        return this.mountAlias;
    }

    public Set<String> getRoles() {
        return this.roles;
    }
}

