/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.configuration.sitemenu;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.hippoecm.hst.configuration.ConfigurationUtils;
import org.hippoecm.hst.configuration.internal.CanonicalInfo;
import org.hippoecm.hst.configuration.internal.ConfigurationLockInfo;
import org.hippoecm.hst.configuration.model.HstNode;
import org.hippoecm.hst.configuration.sitemenu.HstSiteMenuConfiguration;
import org.hippoecm.hst.configuration.sitemenu.HstSiteMenuItemConfiguration;
import org.hippoecm.hst.configuration.sitemenu.HstSiteMenuItemConfigurationService;
import org.hippoecm.hst.configuration.sitemenu.HstSiteMenusConfiguration;
import org.hippoecm.hst.core.internal.StringPool;

public class HstSiteMenuConfigurationService
implements HstSiteMenuConfiguration,
CanonicalInfo,
ConfigurationLockInfo {
    private String name;
    private final String canonicalIdentifier;
    private final String canonicalPath;
    private final boolean workspaceConfiguration;
    private HstSiteMenusConfiguration hstSiteMenusConfiguration;
    private List<HstSiteMenuItemConfiguration> siteMenuItems = new ArrayList<HstSiteMenuItemConfiguration>();
    private HstSiteMenuItemConfiguration prototypeItem;
    private String lockedBy;
    private Calendar lockedOn;

    public HstSiteMenuConfigurationService(HstSiteMenusConfiguration hstSiteMenusConfiguration, HstNode siteMenu) {
        this.hstSiteMenusConfiguration = hstSiteMenusConfiguration;
        this.name = StringPool.get((String)siteMenu.getValueProvider().getName());
        this.canonicalIdentifier = siteMenu.getValueProvider().getIdentifier();
        this.canonicalPath = siteMenu.getValueProvider().getPath();
        this.workspaceConfiguration = ConfigurationUtils.isWorkspaceConfig((HstNode)siteMenu);
        for (HstNode siteMenuItem : siteMenu.getNodes()) {
            HstSiteMenuItemConfigurationService siteMenuItemConfiguration = new HstSiteMenuItemConfigurationService(siteMenuItem, null, this);
            if ("hst:prototypeitem".equals(siteMenuItem.getName())) {
                this.prototypeItem = siteMenuItemConfiguration;
                continue;
            }
            this.siteMenuItems.add(siteMenuItemConfiguration);
        }
        this.lockedBy = siteMenu.getValueProvider().getString("hst:lockedby");
        this.lockedOn = siteMenu.getValueProvider().getDate("hst:lockedon");
    }

    public String getName() {
        return this.name;
    }

    public String getCanonicalIdentifier() {
        return this.canonicalIdentifier;
    }

    public String getCanonicalPath() {
        return this.canonicalPath;
    }

    public boolean isWorkspaceConfiguration() {
        return this.workspaceConfiguration;
    }

    public List<HstSiteMenuItemConfiguration> getSiteMenuConfigurationItems() {
        return Collections.unmodifiableList(this.siteMenuItems);
    }

    public HstSiteMenusConfiguration getSiteMenusConfiguration() {
        return this.hstSiteMenusConfiguration;
    }

    public String getLockedBy() {
        return this.lockedBy;
    }

    public Calendar getLockedOn() {
        return this.lockedOn;
    }

    public HstSiteMenuItemConfiguration getPrototypeItem() {
        return this.prototypeItem;
    }
}

