/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.configuration.sitemapitemhandler;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hippoecm.hst.configuration.cache.CompositeConfigurationNodes;
import org.hippoecm.hst.configuration.model.HstNode;
import org.hippoecm.hst.configuration.model.ModelLoadingException;
import org.hippoecm.hst.configuration.sitemapitemhandler.HstSiteMapItemHandlerConfigurationService;
import org.hippoecm.hst.configuration.sitemapitemhandlers.HstSiteMapItemHandlerConfiguration;
import org.hippoecm.hst.configuration.sitemapitemhandlers.HstSiteMapItemHandlersConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HstSiteMapItemHandlersConfigurationService
implements HstSiteMapItemHandlersConfiguration {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(HstSiteMapItemHandlersConfigurationService.class);
    private Map<String, HstSiteMapItemHandlerConfiguration> siteMapItemHanderConfigurations = new HashMap<String, HstSiteMapItemHandlerConfiguration>();

    public HstSiteMapItemHandlersConfigurationService(CompositeConfigurationNodes.CompositeConfigurationNode ccn) throws ModelLoadingException {
        for (HstNode handlerNode : ccn.getCompositeChildren().values()) {
            if ("hst:sitemapitemhandler".equals(handlerNode.getNodeTypeName())) {
                try {
                    HstSiteMapItemHandlerConfigurationService siteMapItemHandler = new HstSiteMapItemHandlerConfigurationService(handlerNode);
                    this.siteMapItemHanderConfigurations.put(siteMapItemHandler.getId(), siteMapItemHandler);
                }
                catch (ModelLoadingException e) {
                    log.warn("Skipping handle '{}' because '{}'", (Object)handlerNode.getValueProvider().getPath(), (Object)e.getMessage());
                }
                continue;
            }
            log.warn("Skipping node '{}' because is not of type {}", (Object)handlerNode.getValueProvider().getPath(), (Object)"hst:sitemapitemhandler");
        }
    }

    public HstSiteMapItemHandlerConfiguration getSiteMapItemHandlerConfiguration(String id) {
        return this.siteMapItemHanderConfigurations.get(id);
    }

    public Map<String, HstSiteMapItemHandlerConfiguration> getSiteMapItemHandlerConfigurations() {
        return Collections.unmodifiableMap(this.siteMapItemHanderConfigurations);
    }
}

