/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.configuration.sitemap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hippoecm.hst.configuration.ConfigurationUtils;
import org.hippoecm.hst.configuration.cache.CompositeConfigurationNodes;
import org.hippoecm.hst.configuration.internal.CanonicalInfo;
import org.hippoecm.hst.configuration.model.HstNode;
import org.hippoecm.hst.configuration.model.ModelLoadingException;
import org.hippoecm.hst.configuration.site.HstSite;
import org.hippoecm.hst.configuration.site.MountSiteMapConfiguration;
import org.hippoecm.hst.configuration.sitemap.HstSiteMap;
import org.hippoecm.hst.configuration.sitemap.HstSiteMapItem;
import org.hippoecm.hst.configuration.sitemap.HstSiteMapItemService;
import org.hippoecm.hst.configuration.sitemapitemhandlers.HstSiteMapItemHandlersConfiguration;
import org.hippoecm.hst.service.Service;
import org.hippoecm.hst.util.DuplicateKeyNotAllowedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HstSiteMapService
implements HstSiteMap,
CanonicalInfo {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(HstSiteMapService.class);
    private final String canonicalIdentifier;
    private final String canonicalPath;
    private final boolean workspaceConfiguration;
    private HstSite hstSite;
    private Map<String, HstSiteMapItem> rootSiteMapItems = new LinkedHashMap<String, HstSiteMapItem>();
    private Map<String, HstSiteMapItem> siteMapDescendants = new DuplicateKeyNotAllowedHashMap();
    private Map<String, HstSiteMapItem> siteMapDescendantsByRefId = new HashMap<String, HstSiteMapItem>();

    public HstSiteMapService(HstSite hstSite, CompositeConfigurationNodes.CompositeConfigurationNode siteMapNode, MountSiteMapConfiguration mountSiteMapConfiguration, HstSiteMapItemHandlersConfiguration siteMapItemHandlersConfiguration) throws ModelLoadingException {
        this.hstSite = hstSite;
        this.canonicalIdentifier = siteMapNode.getMainConfigNode().getValueProvider().getIdentifier();
        this.canonicalPath = siteMapNode.getMainConfigNode().getValueProvider().getPath();
        this.workspaceConfiguration = ConfigurationUtils.isWorkspaceConfig((HstNode)siteMapNode.getMainConfigNode());
        for (HstNode hstNode : siteMapNode.getCompositeChildren().values()) {
            if ("hst:sitemapitem".equals(hstNode.getNodeTypeName())) {
                try {
                    HstSiteMapItemService siteMapItemService = new HstSiteMapItemService(hstNode, mountSiteMapConfiguration, siteMapItemHandlersConfiguration, null, this, 1);
                    this.rootSiteMapItems.put(siteMapItemService.getValue(), siteMapItemService);
                }
                catch (ModelLoadingException e) {
                    if (log.isDebugEnabled()) {
                        log.warn("Skipping sitemap item '{}'", (Object)hstNode.getValueProvider().getPath(), (Object)e);
                        continue;
                    }
                    if (!log.isWarnEnabled()) continue;
                    log.warn("Skipping sitemap item '{}' : '{}'", (Object)hstNode.getValueProvider().getPath(), (Object)e.getMessage());
                }
                continue;
            }
            log.warn("Skipping node '{}' because is not of type {}", (Object)hstNode.getValueProvider().getPath(), (Object)"hst:sitemapitem");
        }
        for (HstSiteMapItem hstSiteMapItem : this.rootSiteMapItems.values()) {
            this.populateDescendants(hstSiteMapItem);
        }
        for (HstSiteMapItem hstSiteMapItem : this.rootSiteMapItems.values()) {
            ((HstSiteMapItemService)hstSiteMapItem).optimize();
        }
    }

    private void populateDescendants(HstSiteMapItem hstSiteMapItem) throws ModelLoadingException {
        HstSiteMapItem prevValue;
        try {
            this.siteMapDescendants.put(hstSiteMapItem.getId(), hstSiteMapItem);
        }
        catch (IllegalArgumentException e) {
            throw new ModelLoadingException("HstSiteMapItem with already existing id encountered. Not allowed to have duplicate id's within one HstSiteMap. Duplicate id = '" + hstSiteMapItem.getId() + "'", e);
        }
        if (hstSiteMapItem.getRefId() != null && (prevValue = this.siteMapDescendantsByRefId.put(hstSiteMapItem.getRefId(), hstSiteMapItem)) != null) {
            log.warn("HstSiteMapItem with already existing refId encountered. Not allowed to have duplicate refId's within one HstSiteMap. Duplicate refId = '{}' for HstSiteMapItem with id='{}'. Previous HstSiteMapItem with same refId is replaced.", (Object)hstSiteMapItem.getRefId(), (Object)hstSiteMapItem.getId());
        }
        for (HstSiteMapItem child : hstSiteMapItem.getChildren()) {
            this.populateDescendants(child);
        }
    }

    public String getCanonicalIdentifier() {
        return this.canonicalIdentifier;
    }

    public String getCanonicalPath() {
        return this.canonicalPath;
    }

    public boolean isWorkspaceConfiguration() {
        return this.workspaceConfiguration;
    }

    public Service[] getChildServices() {
        return this.rootSiteMapItems.values().toArray(new Service[this.rootSiteMapItems.size()]);
    }

    public HstSiteMapItem getSiteMapItem(String value) {
        return this.rootSiteMapItems.get(value);
    }

    public HstSiteMapItem getSiteMapItemById(String id) {
        return this.siteMapDescendants.get(id);
    }

    public HstSiteMapItem getSiteMapItemByRefId(String refId) {
        return this.siteMapDescendantsByRefId.get(refId);
    }

    public List<HstSiteMapItem> getSiteMapItems() {
        return Collections.unmodifiableList(new ArrayList<HstSiteMapItem>(this.rootSiteMapItems.values()));
    }

    public HstSite getSite() {
        return this.hstSite;
    }
}

