/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.configuration.sitemap;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.configuration.ConfigurationUtils;
import org.hippoecm.hst.configuration.internal.CanonicalInfo;
import org.hippoecm.hst.configuration.internal.ConfigurationLockInfo;
import org.hippoecm.hst.configuration.model.HstNode;
import org.hippoecm.hst.configuration.model.ModelLoadingException;
import org.hippoecm.hst.configuration.site.MountSiteMapConfiguration;
import org.hippoecm.hst.configuration.sitemap.HstSiteMap;
import org.hippoecm.hst.configuration.sitemap.HstSiteMapItem;
import org.hippoecm.hst.configuration.sitemapitemhandlers.HstSiteMapItemHandlerConfiguration;
import org.hippoecm.hst.configuration.sitemapitemhandlers.HstSiteMapItemHandlersConfiguration;
import org.hippoecm.hst.core.internal.CollectionOptimizer;
import org.hippoecm.hst.core.internal.StringPool;
import org.hippoecm.hst.core.util.PropertyParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HstSiteMapItemService
implements HstSiteMapItem,
CanonicalInfo,
ConfigurationLockInfo {
    private static final Logger log = LoggerFactory.getLogger(HstSiteMapItemService.class);
    private static final String PARENT_PROPERTY_PLACEHOLDER = "${parent}";
    public static final String CONTAINER_RESOURCE_PIPELINE_NAME = "ContainerResourcePipeline";
    public static final String WEB_FILE_PIPELINE_NAME = "WebFilePipeline";
    public static final Set<String> CDN_SUPPORTED_PIPELINES = ImmutableSet.of((Object)"ContainerResourcePipeline", (Object)"WebFilePipeline");
    private Map<String, HstSiteMapItem> childSiteMapItems = new HashMap<String, HstSiteMapItem>();
    private Map<String, HstSiteMapItemHandlerConfiguration> siteMapItemHandlerConfigurations = new LinkedHashMap<String, HstSiteMapItemHandlerConfiguration>();
    private String id;
    private final String canonicalIdentifier;
    private final String canonicalPath;
    private String lockedBy;
    private Calendar lockedOn;
    private final boolean workspaceConfiguration;
    private String refId;
    private String pageTitle;
    private String value;
    private String locale;
    private int statusCode;
    private int errorCode;
    private String parameterizedPath;
    private int occurences;
    private String relativeContentPath;
    private String componentConfigurationId;
    private Map<String, String> componentConfigurationIdMappings;
    private boolean authenticated;
    private Set<String> roles;
    private Set<String> users;
    private boolean excludedForLinkRewriting;
    private boolean isWildCard;
    private boolean isAny;
    private String namedPipeline;
    private boolean useableInRightContextOnly;
    private Map<String, String> keyToPropertyPlaceHolderMap = new HashMap<String, String>(0);
    private int depth;
    private HstSiteMap hstSiteMap;
    private HstSiteMapItemService parentItem;
    private Map<String, String> parameters = new HashMap<String, String>();
    private Map<String, String> localParameters = new HashMap<String, String>();
    private List<HstSiteMapItemService> containsWildCardChildSiteMapItems = new ArrayList<HstSiteMapItemService>();
    private List<HstSiteMapItemService> containsAnyChildSiteMapItems = new ArrayList<HstSiteMapItemService>();
    private boolean containsAny;
    private boolean containsWildCard;
    private boolean isExplicitItem;
    private String postfix;
    private String extension;
    private String prefix;
    private final boolean cacheable;
    private String scheme;
    private boolean schemeAgnostic;
    private int schemeNotMatchingResponseCode = -1;
    private final String[] resourceBundleIds;
    private boolean containerResource;
    private boolean hiddenInChannelManager;
    private boolean markedDeleted;

    HstSiteMapItemService(HstNode node, MountSiteMapConfiguration mountSiteMapConfiguration, HstSiteMapItemHandlersConfiguration siteMapItemHandlersConfiguration, HstSiteMapItem parentItem, HstSiteMap hstSiteMap, int depth) throws ModelLoadingException {
        Object[] siteMapItemHandlerIds;
        this.parentItem = (HstSiteMapItemService)parentItem;
        this.hstSiteMap = hstSiteMap;
        this.depth = depth;
        this.canonicalIdentifier = node.getValueProvider().getIdentifier();
        this.canonicalPath = StringPool.get((String)node.getValueProvider().getPath());
        this.workspaceConfiguration = ConfigurationUtils.isWorkspaceConfig((HstNode)node);
        this.lockedBy = node.getValueProvider().getString("hst:lockedby");
        this.lockedOn = node.getValueProvider().getDate("hst:lockedon");
        HstNode crNode = node;
        StringBuilder idBuilder = new StringBuilder("/").append(crNode.getValueProvider().getName());
        while (crNode.getParent().getNodeTypeName().equals("hst:sitemapitem")) {
            crNode = crNode.getParent();
            idBuilder.insert(0, crNode.getValueProvider().getName()).insert(0, "/");
        }
        this.id = StringPool.get((String)idBuilder.toString().substring(1));
        this.value = StringPool.get((String)node.getValueProvider().getName());
        if (node.getValueProvider().hasProperty("hst:refId")) {
            this.refId = StringPool.get((String)node.getValueProvider().getString("hst:refId"));
        }
        if (node.getValueProvider().hasProperty("hst:pagetitle")) {
            this.pageTitle = StringPool.get((String)node.getValueProvider().getString("hst:pagetitle"));
        }
        this.statusCode = node.getValueProvider().getLong("hst:statuscode").intValue();
        this.errorCode = node.getValueProvider().getLong("hst:errorcode").intValue();
        if (parentItem != null) {
            this.parameterizedPath = this.parentItem.getParameterizedPath() + "/";
            this.occurences = this.parentItem.getWildCardAnyOccurences();
        } else {
            this.parameterizedPath = "";
        }
        if ("_default_".equals(this.value)) {
            ++this.occurences;
            this.parameterizedPath = this.parameterizedPath + "${" + this.occurences + "}";
            this.isWildCard = true;
        } else if ("_any_".equals(this.value)) {
            ++this.occurences;
            this.parameterizedPath = this.parameterizedPath + "${" + this.occurences + "}";
            this.isAny = true;
        } else if (this.value.contains("_default_")) {
            this.containsWildCard = true;
            this.postfix = this.value.substring(this.value.indexOf("_default_") + "_default_".length());
            this.prefix = this.value.substring(0, this.value.indexOf("_default_"));
            if (this.postfix.contains(".")) {
                this.extension = this.postfix.substring(this.postfix.indexOf("."));
            }
            if (parentItem != null) {
                ((HstSiteMapItemService)parentItem).addWildCardPrefixedChildSiteMapItems(this);
            }
            ++this.occurences;
            this.parameterizedPath = this.parameterizedPath + this.value.replace("_default_", "${" + this.occurences + "}");
        } else if (this.value.contains("_any_")) {
            this.containsAny = true;
            this.postfix = this.value.substring(this.value.indexOf("_any_") + "_any_".length());
            if (this.postfix.contains(".")) {
                this.extension = this.postfix.substring(this.postfix.indexOf("."));
            }
            this.prefix = this.value.substring(0, this.value.indexOf("_any_"));
            if (parentItem != null) {
                ((HstSiteMapItemService)parentItem).addAnyPrefixedChildSiteMapItems(this);
            }
            ++this.occurences;
            this.parameterizedPath = this.parameterizedPath + this.value.replace("_any_", "${" + this.occurences + "}");
        } else {
            this.parameterizedPath = this.parameterizedPath + this.value;
        }
        this.isExplicitItem = !this.isWildCard && !this.isAny && !this.containsWildCard && !this.containsAny;
        this.parameterizedPath = StringPool.get((String)this.parameterizedPath);
        this.prefix = StringPool.get((String)this.prefix);
        this.postfix = StringPool.get((String)this.postfix);
        this.extension = StringPool.get((String)this.extension);
        Properties mountParameters = new Properties();
        for (Map.Entry<String, String> entry : mountSiteMapConfiguration.getParameters().entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            mountParameters.setProperty(entry.getKey(), entry.getValue());
        }
        PropertyParser mountParameterParser = new PropertyParser(mountParameters, "${", "}", PropertyParser.DEFAULT_VALUE_SEPARATOR, true);
        String[] parameterNames = node.getValueProvider().getStrings("hst:parameternames");
        String[] parameterValues = node.getValueProvider().getStrings("hst:parametervalues");
        String[] componentConfigurationNames = node.getValueProvider().getStrings("hst:componentconfigurationmappingnames");
        String[] componentConfigurationValues = node.getValueProvider().getStrings("hst:componentconfigurationmappingvalues");
        if (componentConfigurationNames != null && componentConfigurationValues != null) {
            if (componentConfigurationNames.length != componentConfigurationValues.length) {
                log.warn("Skipping componentConfigurationMappings for sitemapitem '{}' because they only make sense if there are equal number of names and values", (Object)this.canonicalPath);
            } else {
                this.componentConfigurationIdMappings = new HashMap<String, String>();
                for (int i = 0; i < componentConfigurationNames.length; ++i) {
                    this.componentConfigurationIdMappings.put(StringPool.get((String)componentConfigurationNames[i]), StringPool.get((String)componentConfigurationValues[i]));
                }
            }
        }
        if (parameterNames != null && parameterValues != null) {
            if (parameterNames.length != parameterValues.length) {
                log.warn("Skipping parameters for sitemapitem '{}' because they only make sense if there are equal number of names and values", (Object)this.canonicalPath);
            } else {
                String[] clonedParameterNames = Arrays.copyOf(parameterNames, parameterNames.length);
                String[] stringArray = Arrays.copyOf(parameterValues, parameterValues.length);
                for (int i = 0; i < clonedParameterNames.length; ++i) {
                    if (stringArray[i] != null && stringArray[i].contains("${")) {
                        String resolved = (String)mountParameterParser.resolveProperty(clonedParameterNames[i], stringArray[i]);
                        if (HstSiteMapItemService.containsInvalidOrNonIntegerPlaceholders(resolved)) {
                            log.warn("Invalid irreplaceable property placeholder found for parameter name '{}' with value '{}' for sitemap item '{}'. Setting value for '{}' to null", (Object[])new String[]{clonedParameterNames[i], stringArray[i], this.id, clonedParameterNames[i]});
                            stringArray[i] = null;
                        } else {
                            stringArray[i] = resolved;
                        }
                    }
                    this.parameters.put(StringPool.get((String)clonedParameterNames[i]), StringPool.get((String)stringArray[i]));
                    this.localParameters.put(StringPool.get((String)clonedParameterNames[i]), StringPool.get((String)stringArray[i]));
                }
            }
        }
        if (parentItem != null) {
            for (Map.Entry<String, String> entry : this.parentItem.getParameters().entrySet()) {
                if (this.parameters.containsKey(entry.getKey())) continue;
                this.parameters.put(StringPool.get((String)entry.getKey()), StringPool.get((String)entry.getValue()));
            }
        }
        this.relativeContentPath = node.getValueProvider().getString("hst:relativecontentpath");
        if (this.relativeContentPath != null && this.relativeContentPath.contains(PARENT_PROPERTY_PLACEHOLDER)) {
            if (parentItem == null || parentItem.getRelativeContentPath() == null) {
                log.error("Cannot use '{}' for a sitemap item that does not have a parent or a parent without relative content path. Used at: '{}'", (Object)PARENT_PROPERTY_PLACEHOLDER, (Object)this.id);
            } else {
                this.relativeContentPath = this.relativeContentPath.replace(PARENT_PROPERTY_PLACEHOLDER, parentItem.getRelativeContentPath());
            }
        }
        if (this.relativeContentPath != null && this.relativeContentPath.contains("${")) {
            String resolved = (String)mountParameterParser.resolveProperty("relativeContentPath", this.relativeContentPath);
            if (HstSiteMapItemService.containsInvalidOrNonIntegerPlaceholders(resolved)) {
                log.warn("Invalid irreplaceable property placeholder found for hst:relativecontentpath '{}' for sitemap item '{}'.Setting relativeContentPath to null", (Object[])new String[]{this.relativeContentPath, this.canonicalPath});
                this.relativeContentPath = null;
            } else {
                this.relativeContentPath = resolved;
            }
        }
        if (this.relativeContentPath != null) {
            this.relativeContentPath = this.relativeContentPath.trim();
        }
        this.relativeContentPath = StringPool.get((String)this.relativeContentPath);
        this.componentConfigurationId = node.getValueProvider().getString("hst:componentconfigurationid");
        if (this.componentConfigurationId != null && this.componentConfigurationId.contains("${")) {
            String resolved = (String)mountParameterParser.resolveProperty("componentConfigurationId", this.componentConfigurationId);
            if (HstSiteMapItemService.containsInvalidOrNonIntegerPlaceholders(resolved)) {
                log.warn("Invalid irreplaceable property placeholder found for {} '{}' for sitemap item '{}'. Setting relativeContentPath to null", (Object[])new String[]{"hst:componentconfigurationid", this.relativeContentPath, this.canonicalPath});
                this.componentConfigurationId = null;
            } else {
                this.componentConfigurationId = resolved;
            }
        }
        this.componentConfigurationId = StringPool.get((String)this.componentConfigurationId);
        if (this.componentConfigurationId != null && this.componentConfigurationId.startsWith("hst:abstractpages")) {
            log.warn("Invalid {} '{}' for '{}' because a sitemap item should not reference an abstract page.", (Object[])new String[]{"hst:componentconfigurationid", this.componentConfigurationId, this.canonicalPath});
        }
        if (ArrayUtils.isEmpty((Object[])(siteMapItemHandlerIds = node.getValueProvider().getStrings("hst:sitemapitemhandlerids")))) {
            siteMapItemHandlerIds = mountSiteMapConfiguration.getDefaultSiteMapItemHandlerIds();
        }
        if (siteMapItemHandlerIds != null && siteMapItemHandlersConfiguration != null) {
            for (Object handlerId : siteMapItemHandlerIds) {
                HstSiteMapItemHandlerConfiguration handlerConfiguration = siteMapItemHandlersConfiguration.getSiteMapItemHandlerConfiguration((String)handlerId);
                if (handlerConfiguration == null) {
                    log.error("Incorrect configuration: SiteMapItem '{}' contains a handlerId '{}' which cannot be found in the siteMapItemHandlers configuration. The handler will be ignored", (Object)this.getQualifiedId(), handlerId);
                    continue;
                }
                this.siteMapItemHandlerConfigurations.put(StringPool.get((String)handlerId), handlerConfiguration);
            }
        }
        this.locale = node.getValueProvider().hasProperty("hst:locale") ? node.getValueProvider().getString("hst:locale") : (parentItem != null ? parentItem.getLocale() : mountSiteMapConfiguration.getLocale());
        this.locale = StringPool.get((String)this.locale);
        if (node.getValueProvider().hasProperty("hst:authenticated")) {
            this.authenticated = node.getValueProvider().getBoolean("hst:authenticated");
        } else if (this.parentItem != null) {
            this.authenticated = parentItem.isAuthenticated();
        }
        if (node.getValueProvider().hasProperty("hst:roles")) {
            Object[] objectArray = node.getValueProvider().getStrings("hst:roles");
            this.roles = new HashSet<String>();
            CollectionUtils.addAll(this.roles, (Object[])objectArray);
        } else {
            this.roles = this.parentItem != null ? new HashSet<String>(parentItem.getRoles()) : new HashSet<String>(0);
        }
        if (node.getValueProvider().hasProperty("hst:users")) {
            Object[] objectArray = node.getValueProvider().getStrings("hst:users");
            this.users = new HashSet<String>();
            CollectionUtils.addAll(this.users, (Object[])objectArray);
        } else {
            this.users = parentItem != null ? new HashSet<String>(parentItem.getUsers()) : new HashSet<String>();
        }
        if (node.getValueProvider().hasProperty("hst:containerresource")) {
            this.containerResource = node.getValueProvider().getBoolean("hst:containerresource");
        } else if (parentItem != null) {
            this.containerResource = parentItem.isContainerResource();
        }
        if (this.containerResource) {
            if (!this.canonicalPath.contains("/hst:default/hst:sitemap/")) {
                String string = String.format("Invalid sitemap item configuration for '%s'. A sitemap item is only allowed to be marked with '%s = true' if the sitemap item is located in '%s'.", this.canonicalPath, "hst:containerresource", "/hst:default/hst:sitemap/");
                throw new ModelLoadingException(string);
            }
            log.info("Sitemap item '{}' is a container resource item. Default the properties '{}' will be set to '{}', '{}' = true and '{}' = true, unless the properties are explicitly configured on this item or a parent item to have a different value", new Object[]{this.canonicalPath, "hst:namedpipeline", CONTAINER_RESOURCE_PIPELINE_NAME, "hst:excludedforlinkrewriting", "hst:schemeagnostic"});
            this.excludedForLinkRewriting = true;
            this.schemeAgnostic = true;
            this.namedPipeline = CONTAINER_RESOURCE_PIPELINE_NAME;
        }
        if (node.getValueProvider().hasProperty("hst:state")) {
            if ("deleted".equals(node.getValueProvider().getString("hst:state"))) {
                this.markedDeleted = true;
            }
        } else if (parentItem != null) {
            this.markedDeleted = parentItem.isMarkedDeleted();
        }
        if (this.markedDeleted) {
            this.hiddenInChannelManager = true;
            this.excludedForLinkRewriting = true;
        } else {
            if (node.getValueProvider().hasProperty("hst:hiddeninchannelmanager")) {
                this.hiddenInChannelManager = node.getValueProvider().getBoolean("hst:hiddeninchannelmanager");
            } else if (parentItem != null) {
                this.hiddenInChannelManager = parentItem.isHiddenInChannelManager();
            }
            if (node.getValueProvider().hasProperty("hst:excludedforlinkrewriting")) {
                this.excludedForLinkRewriting = node.getValueProvider().getBoolean("hst:excludedforlinkrewriting");
            } else if (parentItem != null) {
                this.excludedForLinkRewriting = parentItem.isExcludedForLinkRewriting();
            }
        }
        if (node.getValueProvider().hasProperty("hst:namedpipeline")) {
            this.namedPipeline = node.getValueProvider().getString("hst:namedpipeline");
        } else if (parentItem != null) {
            this.namedPipeline = parentItem.getNamedPipeline();
        }
        if (this.namedPipeline == null) {
            this.namedPipeline = mountSiteMapConfiguration.getNamedPipeline();
        }
        this.namedPipeline = StringPool.get((String)this.namedPipeline);
        this.cacheable = node.getValueProvider().hasProperty("hst:cacheable") ? node.getValueProvider().getBoolean("hst:cacheable") : (this.parentItem != null ? parentItem.isCacheable() : mountSiteMapConfiguration.isCacheable());
        this.scheme = null;
        if (node.getValueProvider().hasProperty("hst:scheme")) {
            this.scheme = StringPool.get((String)node.getValueProvider().getString("hst:scheme"));
        }
        if (StringUtils.isBlank((String)this.scheme)) {
            String string = this.scheme = parentItem != null ? parentItem.getScheme() : mountSiteMapConfiguration.getScheme();
        }
        if (node.getValueProvider().hasProperty("hst:schemeagnostic")) {
            this.schemeAgnostic = node.getValueProvider().getBoolean("hst:schemeagnostic");
        } else if (parentItem != null) {
            this.schemeAgnostic = parentItem.isSchemeAgnostic();
        } else if (!this.containerResource) {
            this.schemeAgnostic = mountSiteMapConfiguration.isSchemeAgnostic();
        }
        if (node.getValueProvider().hasProperty("hst:schemenotmatchresponsecode")) {
            this.schemeNotMatchingResponseCode = (int)node.getValueProvider().getLong("hst:schemenotmatchresponsecode").longValue();
            if (!ConfigurationUtils.isSupportedSchemeNotMatchingResponseCode((int)this.schemeNotMatchingResponseCode)) {
                log.warn("Invalid '{}' configured on '{}'. Use inherited value. Supported values are '{}'", (Object[])new String[]{"hst:schemenotmatchresponsecode", node.getValueProvider().getPath(), ConfigurationUtils.supportedSchemeNotMatchingResponseCodesAsString()});
                this.schemeNotMatchingResponseCode = -1;
            }
        }
        if (this.schemeNotMatchingResponseCode == -1) {
            int n = this.schemeNotMatchingResponseCode = parentItem != null ? parentItem.getSchemeNotMatchingResponseCode() : mountSiteMapConfiguration.getSchemeNotMatchingResponseCode();
        }
        this.resourceBundleIds = node.getValueProvider().hasProperty("hst:resourcebundleid") ? StringUtils.split((String)StringPool.get((String)node.getValueProvider().getString("hst:resourcebundleid")), (String)" ,\t\f\r\n") : (parentItem != null ? parentItem.getResourceBundleIds() : mountSiteMapConfiguration.getDefaultResourceBundleIds());
        for (HstNode child : node.getNodes()) {
            if (!"hst:sitemapitem".equals(child.getNodeTypeName())) continue;
            try {
                HstSiteMapItemService siteMapItemService = new HstSiteMapItemService(child, mountSiteMapConfiguration, siteMapItemHandlersConfiguration, this, this.hstSiteMap, depth + 1);
                this.childSiteMapItems.put(siteMapItemService.getValue(), siteMapItemService);
            }
            catch (ModelLoadingException e) {
                if (log.isDebugEnabled()) {
                    log.warn("Skipping root sitemap '{}'", (Object)child.getValueProvider().getPath(), (Object)e);
                    continue;
                }
                if (!log.isWarnEnabled()) continue;
                log.warn("Skipping root sitemap '{}'", (Object)child.getValueProvider().getPath());
            }
        }
    }

    public HstSiteMapItem getChild(String value) {
        return this.childSiteMapItems.get(value);
    }

    public List<HstSiteMapItem> getChildren() {
        return Collections.unmodifiableList(new ArrayList<HstSiteMapItem>(this.childSiteMapItems.values()));
    }

    public String getComponentConfigurationId() {
        return this.componentConfigurationId;
    }

    public Map<String, String> getComponentConfigurationIdMappings() {
        return this.componentConfigurationIdMappings;
    }

    public String getId() {
        return this.id;
    }

    public String getCanonicalIdentifier() {
        return this.canonicalIdentifier;
    }

    public String getCanonicalPath() {
        return this.canonicalPath;
    }

    public boolean isWorkspaceConfiguration() {
        return this.workspaceConfiguration;
    }

    public String getLockedBy() {
        return this.lockedBy;
    }

    public Calendar getLockedOn() {
        return this.lockedOn;
    }

    public String getRefId() {
        return this.refId;
    }

    public String getRelativeContentPath() {
        return this.relativeContentPath;
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getLocalParameter(String name) {
        return this.localParameters.get(name);
    }

    public Map<String, String> getLocalParameters() {
        return this.localParameters;
    }

    public HstSiteMapItemHandlerConfiguration getSiteMapItemHandlerConfiguration(String handlerId) {
        return this.siteMapItemHandlerConfigurations.get(handlerId);
    }

    public List<HstSiteMapItemHandlerConfiguration> getSiteMapItemHandlerConfigurations() {
        return Collections.unmodifiableList(new ArrayList<HstSiteMapItemHandlerConfiguration>(this.siteMapItemHandlerConfigurations.values()));
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public Set<String> getUsers() {
        return this.users;
    }

    public String getValue() {
        return this.value;
    }

    public String getPageTitle() {
        return this.pageTitle;
    }

    public String getLocale() {
        return this.locale;
    }

    public boolean isWildCard() {
        return this.isWildCard;
    }

    public boolean isAny() {
        return this.isAny;
    }

    public HstSiteMap getHstSiteMap() {
        return this.hstSiteMap;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public String getScheme() {
        return this.scheme;
    }

    public boolean isSchemeAgnostic() {
        return this.schemeAgnostic;
    }

    public int getSchemeNotMatchingResponseCode() {
        return this.schemeNotMatchingResponseCode;
    }

    public String getResourceBundleId() {
        if (this.resourceBundleIds == null || this.resourceBundleIds.length == 0) {
            return null;
        }
        return this.resourceBundleIds[0];
    }

    public String[] getResourceBundleIds() {
        if (this.resourceBundleIds == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return (String[])ArrayUtils.clone((Object[])this.resourceBundleIds);
    }

    public boolean isContainerResource() {
        return this.containerResource;
    }

    public boolean isHiddenInChannelManager() {
        return this.hiddenInChannelManager;
    }

    public HstSiteMapItem getParentItem() {
        return this.parentItem;
    }

    public String getParameterizedPath() {
        return this.parameterizedPath;
    }

    public int getWildCardAnyOccurences() {
        return this.occurences;
    }

    public void addWildCardPrefixedChildSiteMapItems(HstSiteMapItemService hstSiteMapItem) {
        this.containsWildCardChildSiteMapItems.add(hstSiteMapItem);
    }

    public void addAnyPrefixedChildSiteMapItems(HstSiteMapItemService hstSiteMapItem) {
        this.containsAnyChildSiteMapItems.add(hstSiteMapItem);
    }

    public HstSiteMapItem getWildCardPatternChild(String value, List<HstSiteMapItem> excludeList) {
        if (value == null || this.containsWildCardChildSiteMapItems.isEmpty()) {
            return null;
        }
        return this.match(value, this.containsWildCardChildSiteMapItems, excludeList);
    }

    public HstSiteMapItem getAnyPatternChild(String[] elements, int position, List<HstSiteMapItem> excludeList) {
        if (this.value == null || this.containsAnyChildSiteMapItems.isEmpty()) {
            return null;
        }
        StringBuilder remainder = new StringBuilder(elements[position]);
        while (++position < elements.length) {
            remainder.append("/").append(elements[position]);
        }
        return this.match(remainder.toString(), this.containsAnyChildSiteMapItems, excludeList);
    }

    public boolean patternMatch(String value, String prefix, String postfix) {
        if (prefix != null && !"".equals(prefix)) {
            if (prefix.length() >= value.length()) {
                return false;
            }
            if (!value.substring(0, prefix.length()).equals(prefix)) {
                return false;
            }
        }
        if (postfix != null && !"".equals(postfix)) {
            if (postfix.length() >= value.length()) {
                return false;
            }
            if (!value.substring(value.length() - postfix.length()).equals(postfix)) {
                return false;
            }
        }
        return true;
    }

    private HstSiteMapItem match(String value, List<HstSiteMapItemService> patternSiteMapItems, List<HstSiteMapItem> excludeList) {
        for (HstSiteMapItemService item : patternSiteMapItems) {
            if (excludeList.contains(item) || !this.patternMatch(value, item.getPrefix(), item.getPostfix())) continue;
            return item;
        }
        return null;
    }

    public String getNamedPipeline() {
        return this.namedPipeline;
    }

    public String getPostfix() {
        return this.postfix;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean containsWildCard() {
        return this.containsWildCard;
    }

    public boolean containsAny() {
        return this.containsAny;
    }

    public boolean isExplicitElement() {
        return this.isExplicitItem;
    }

    public boolean isExplicitPath() {
        return this.parentItem == null ? this.isExplicitElement() : this.isExplicitElement() && this.parentItem.isExplicitPath();
    }

    public void setUseableInRightContextOnly(boolean useableInRightContextOnly) {
        this.useableInRightContextOnly = useableInRightContextOnly;
    }

    public boolean isUseableInRightContextOnly() {
        return this.useableInRightContextOnly;
    }

    public void setKeyToPropertyPlaceHolderMap(Map<String, String> keyToPropertyPlaceHolderMap) {
        this.keyToPropertyPlaceHolderMap = keyToPropertyPlaceHolderMap;
    }

    public Map<String, String> getKeyToPropertyPlaceHolderMap() {
        return this.keyToPropertyPlaceHolderMap;
    }

    public int getDepth() {
        return this.depth;
    }

    public String getQualifiedId() {
        return this.canonicalPath;
    }

    public boolean isExcludedForLinkRewriting() {
        return this.excludedForLinkRewriting;
    }

    public boolean isMarkedDeleted() {
        return this.markedDeleted;
    }

    static boolean containsInvalidOrNonIntegerPlaceholders(String input) {
        if (input == null) {
            return false;
        }
        int nextPlaceholder = input.indexOf("${");
        while (nextPlaceholder >= 0) {
            int start = nextPlaceholder + 2;
            int end = input.indexOf(125, start + 1);
            if (end < 0) {
                return true;
            }
            for (int i = start; i < end; ++i) {
                if (Character.isDigit(input.charAt(i))) continue;
                return true;
            }
            nextPlaceholder = input.indexOf("${", end);
        }
        return false;
    }

    void optimize() {
        this.childSiteMapItems = CollectionOptimizer.optimizeHashMap(this.childSiteMapItems);
        this.siteMapItemHandlerConfigurations = CollectionOptimizer.optimizeLinkedHashMap(this.siteMapItemHandlerConfigurations);
        this.componentConfigurationIdMappings = CollectionOptimizer.optimizeHashMap(this.componentConfigurationIdMappings);
        this.users = CollectionOptimizer.optimizeHashSet(this.users);
        this.roles = CollectionOptimizer.optimizeHashSet(this.roles);
        this.parameters = CollectionOptimizer.optimizeHashMap(this.parameters);
        this.localParameters = CollectionOptimizer.optimizeHashMap(this.localParameters);
        this.containsAnyChildSiteMapItems = CollectionOptimizer.optimizeArrayList(this.containsAnyChildSiteMapItems);
        this.containsWildCardChildSiteMapItems = CollectionOptimizer.optimizeArrayList(this.containsWildCardChildSiteMapItems);
        for (HstSiteMapItem child : this.childSiteMapItems.values()) {
            ((HstSiteMapItemService)child).optimize();
        }
    }

    public String toString() {
        return "HstSiteMapItemService{canonicalPath='" + this.canonicalPath + '\'' + ", site=" + this.hstSiteMap.getSite() + '}';
    }
}

